/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.theplumteam.data.IPlayerDiscovery;
import com.theplumteam.data.PlayerDataManager;
import com.theplumteam.network.SyncTokenDataPacket;
import com.theplumteam.server.ServerTickHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadGuaranteedTokenCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReloadGuaranteedTokenCommand.class);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"blockpops").then(((LiteralArgumentBuilder)Commands.literal((String)"reloadguaranteed").requires(source -> source.hasPermission(2))).executes(ReloadGuaranteedTokenCommand::executeCommand)));
    }

    private static int executeCommand(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            ServerPlayer player = source.getPlayerOrException();
            IPlayerDiscovery discovery = PlayerDataManager.getDiscovery((Player)player);
            discovery.setUsedTodaySpecialToken(false);
            PlayerDataManager.markDirty((Player)player, discovery);
            LOGGER.info("Reloaded guaranteed token for player {}", (Object)player.getName().getString());
            long gameTime = player.serverLevel().getGameTime();
            long nextRegularTime = discovery.getNextRegularTokenTime();
            long ticksUntilNext = Math.max(0L, nextRegularTime - gameTime);
            long millisUntilReset = ServerTickHandler.calculateMillisUntilNextReset();
            SyncTokenDataPacket.sendToPlayer(player, discovery.getRegularTokens(), ticksUntilNext, !discovery.hasUsedTodaySpecialToken(), millisUntilReset);
            source.sendSuccess(() -> Component.literal((String)"Reloaded guaranteed token"), true);
            return 1;
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.literal((String)"This command can only be executed by a player"));
            LOGGER.error("Error executing reloadguaranteed command", (Throwable)e);
            return 0;
        }
    }
}

