/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.data.neoforge;

import com.theplumteam.BlockPopsMod;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;

public class StateSaverAndLoader
extends SavedData {
    private final HashMap<UUID, CompoundTag> players = new HashMap();

    @NotNull
    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        CompoundTag playersTag = new CompoundTag();
        this.players.forEach((uuid, playerData) -> playersTag.put(uuid.toString(), (Tag)playerData.copy()));
        tag.put("players", (Tag)playersTag);
        return tag;
    }

    public static StateSaverAndLoader createFromTag(CompoundTag tag, HolderLookup.Provider registries) {
        StateSaverAndLoader state = new StateSaverAndLoader();
        CompoundTag playersTag = tag.getCompound("players");
        playersTag.getAllKeys().forEach(key -> {
            try {
                UUID uuid = UUID.fromString(key);
                state.players.put(uuid, playersTag.getCompound(key).copy());
            }
            catch (IllegalArgumentException e) {
                BlockPopsMod.LOGGER.warn("Invalid UUID in saved data: {}", key);
            }
        });
        return state;
    }

    public static StateSaverAndLoader getServerState(MinecraftServer server) {
        DimensionDataStorage persistentStateManager = server.overworld().getDataStorage();
        StateSaverAndLoader state = (StateSaverAndLoader)persistentStateManager.computeIfAbsent(new SavedData.Factory(StateSaverAndLoader::new, StateSaverAndLoader::createFromTag), "blockpops_player_data");
        state.setDirty();
        return state;
    }

    public static CompoundTag getPlayerState(Player player) {
        if (player.level().isClientSide()) {
            return new CompoundTag();
        }
        MinecraftServer server = player.getServer();
        if (server == null) {
            return new CompoundTag();
        }
        StateSaverAndLoader serverState = StateSaverAndLoader.getServerState(server);
        return serverState.players.computeIfAbsent(player.getUUID(), uuid -> new CompoundTag());
    }
}

