/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.event;

import com.theplumteam.blockentity.BoxBlockEntity;
import com.theplumteam.blockentity.FigureBlockEntity;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="blockpops")
public class FigurePoseEventHandler {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BoxBlockEntity boxBlockEntity;
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        if (!event.getEntity().isShiftKeyDown()) {
            return;
        }
        if (event.getLevel().isClientSide()) {
            return;
        }
        BlockEntity blockEntity = event.getLevel().getBlockEntity(event.getPos());
        if (blockEntity instanceof FigureBlockEntity) {
            FigureBlockEntity figureBlockEntity = (FigureBlockEntity)blockEntity;
            if (figureBlockEntity.hasFigure()) {
                figureBlockEntity.cyclePose();
                event.getEntity().displayClientMessage((Component)Component.literal((String)("Pose changed to: " + figureBlockEntity.getPoseIndex())), true);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
            return;
        }
        if (blockEntity instanceof BoxBlockEntity && (boxBlockEntity = (BoxBlockEntity)blockEntity).hasFigure() && boxBlockEntity.isFigureExtracted()) {
            boxBlockEntity.cyclePose();
            event.getEntity().displayClientMessage((Component)Component.literal((String)("Pose changed to: " + boxBlockEntity.getPoseIndex())), true);
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }
}

