/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.figure;

import com.mojang.authlib.GameProfile;
import com.theplumteam.BlockPopsMod;
import com.theplumteam.block.PopBlockColor;
import com.theplumteam.data.IPlayerDiscovery;
import com.theplumteam.data.PlayerDataManager;
import com.theplumteam.figure.FigureCollection;
import com.theplumteam.figure.FigureDefinition;
import com.theplumteam.server.config.ServerConfig;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;

public class PlayerCollectionGenerator {
    private static final String COLLECTION_ID = "world_players";
    private static final String COLLECTION_NAME = "World Players";

    public static FigureCollection generate(MinecraftServer server) {
        try {
            File[] playerFiles;
            Path worldPath = server.getWorldPath(LevelResource.ROOT);
            File playerdataDir = worldPath.resolve("playerdata").toFile();
            ArrayList<FigureDefinition> playerFigures = new ArrayList<FigureDefinition>();
            HashSet<UUID> processedPlayers = new HashSet<UUID>();
            GameProfileCache profileCache = server.getProfileCache();
            ResourceLocation defaultModel = ResourceLocation.fromNamespaceAndPath((String)"blockpops", (String)"geo/figure/box_figure_default.geo.json");
            ResourceLocation defaultAnimation = ResourceLocation.fromNamespaceAndPath((String)"blockpops", (String)"animations/figure/box_figure_default.animation.json");
            if (playerdataDir.exists() && playerdataDir.isDirectory() && (playerFiles = playerdataDir.listFiles((dir, name) -> name.endsWith(".dat"))) != null && playerFiles.length > 0) {
                for (File playerFile : playerFiles) {
                    try {
                        PopBlockColor defaultColor;
                        String filename = playerFile.getName();
                        String uuidString = filename.substring(0, filename.length() - 4);
                        UUID playerUUID = UUID.fromString(uuidString);
                        Object playerName = "Unknown Player";
                        if (profileCache != null) {
                            Optional profile = profileCache.get(playerUUID);
                            playerName = profile.isPresent() ? ((GameProfile)profile.get()).getName() : "Player " + uuidString.substring(0, 8);
                        }
                        PopBlockColor favoriteColor = defaultColor = ServerConfig.getInstance().getDefaultPlayerColor();
                        ServerPlayer onlinePlayer = server.getPlayerList().getPlayer(playerUUID);
                        if (onlinePlayer != null) {
                            IPlayerDiscovery discovery = PlayerDataManager.getDiscovery((Player)onlinePlayer);
                            if (discovery.hasChosenFavoriteColor() && discovery.getFavoriteColor() != null) {
                                favoriteColor = discovery.getFavoriteColor();
                            }
                            BlockPopsMod.LOGGER.debug("Loaded favorite color from online player {}: {}", playerName, (Object)favoriteColor.getSerializedName());
                        } else {
                            try {
                                CompoundTag modData;
                                CompoundTag playerData;
                                File playerDataFile = new File(playerdataDir, uuidString + ".dat");
                                if (playerDataFile.exists() && (playerData = NbtIo.readCompressed((Path)playerDataFile.toPath(), (NbtAccounter)NbtAccounter.unlimitedHeap())) != null && (modData = playerData.getCompound("blockpops_data")).contains("FavoriteColor", 8)) {
                                    try {
                                        favoriteColor = PopBlockColor.valueOf(modData.getString("FavoriteColor").toUpperCase());
                                    }
                                    catch (IllegalArgumentException e) {
                                        BlockPopsMod.LOGGER.warn("Invalid favorite color found for player {}, defaulting to ORIGINAL", (Object)playerUUID);
                                    }
                                }
                                BlockPopsMod.LOGGER.debug("Loaded favorite color from disk for offline player {}: {}", playerName, (Object)favoriteColor.getSerializedName());
                            }
                            catch (Exception e) {
                                BlockPopsMod.LOGGER.warn("Failed to load favorite color for player {}, defaulting to ORIGINAL: {}", (Object)playerUUID, (Object)e.getMessage());
                            }
                        }
                        FigureDefinition playerFigure = new FigureDefinition(uuidString, (String)playerName, defaultModel, defaultAnimation, playerUUID, favoriteColor);
                        playerFigures.add(playerFigure);
                        processedPlayers.add(playerUUID);
                        BlockPopsMod.LOGGER.debug("Added player figure from .dat file: {} ({})", playerName, (Object)playerUUID);
                    }
                    catch (IllegalArgumentException e) {
                        BlockPopsMod.LOGGER.warn("Failed to parse player UUID from file: {}", (Object)playerFile.getName());
                    }
                }
            }
            List onlinePlayers = server.getPlayerList().getPlayers();
            for (ServerPlayer onlinePlayer : onlinePlayers) {
                UUID playerUUID = onlinePlayer.getUUID();
                if (processedPlayers.contains(playerUUID)) continue;
                String playerName = onlinePlayer.getName().getString();
                String uuidString = playerUUID.toString();
                PopBlockColor defaultColorOnline = ServerConfig.getInstance().getDefaultPlayerColor();
                IPlayerDiscovery discovery = PlayerDataManager.getDiscovery((Player)onlinePlayer);
                PopBlockColor favoriteColor = discovery.hasChosenFavoriteColor() && discovery.getFavoriteColor() != null ? discovery.getFavoriteColor() : defaultColorOnline;
                FigureDefinition playerFigure = new FigureDefinition(uuidString, playerName, defaultModel, defaultAnimation, playerUUID, favoriteColor);
                playerFigures.add(playerFigure);
                processedPlayers.add(playerUUID);
                BlockPopsMod.LOGGER.debug("Added online player figure (no .dat file yet): {} ({})", (Object)playerName, (Object)playerUUID);
            }
            BlockPopsMod.LOGGER.info("Generated World Players collection with {} figures", (Object)playerFigures.size());
            ResourceLocation boxTexture = ResourceLocation.fromNamespaceAndPath((String)"blockpops", (String)"textures/block/box/default.png");
            ResourceLocation logoTexture = ResourceLocation.fromNamespaceAndPath((String)"blockpops", (String)"textures/block/box/logo/logo_worldplayers.png");
            FigureCollection.LogoConfig logoConfig = new FigureCollection.LogoConfig(logoTexture, -0.915f, -0.165f, -0.001f, 4.004f, 4.503f, 1.0f);
            return new FigureCollection(COLLECTION_ID, COLLECTION_NAME, "Minecraft", null, boxTexture, logoConfig, playerFigures, new int[]{152, 48, 167});
        }
        catch (Exception e) {
            BlockPopsMod.LOGGER.error("Failed to generate World Players collection", (Throwable)e);
            return PlayerCollectionGenerator.createEmptyCollection();
        }
    }

    private static FigureCollection createEmptyCollection() {
        ResourceLocation boxTexture = ResourceLocation.fromNamespaceAndPath((String)"blockpops", (String)"textures/block/box/default.png");
        ResourceLocation logoTexture = ResourceLocation.fromNamespaceAndPath((String)"blockpops", (String)"textures/block/box/logo/logo_worldplayers.png");
        FigureCollection.LogoConfig logoConfig = new FigureCollection.LogoConfig(logoTexture, -0.915f, -0.165f, -0.001f, 4.004f, 4.503f, 1.0f);
        return new FigureCollection(COLLECTION_ID, COLLECTION_NAME, "Minecraft", null, boxTexture, logoConfig, new ArrayList<FigureDefinition>(), new int[]{152, 48, 167});
    }

    public static String getCollectionId() {
        return COLLECTION_ID;
    }
}

