/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.item;

import com.theplumteam.block.BoxBlock;
import com.theplumteam.block.FigureBlock;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureCollection;
import com.theplumteam.figure.FigureDefinition;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;

public class GeoBlockItem
extends BlockItem {
    public GeoBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public BoxBlock getBoxBlock() {
        return (BoxBlock)this.getBlock();
    }

    private CompoundTag getBlockEntityTag(ItemStack stack) {
        CustomData customData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        return customData != null ? customData.copyTag() : null;
    }

    public Component getName(ItemStack stack) {
        CompoundTag blockEntityTag;
        String collectionId = null;
        Block block = this.getBlock();
        if (block instanceof BoxBlock) {
            FigureDefinition figure;
            BoxBlock boxBlock = (BoxBlock)block;
            blockEntityTag = this.getBlockEntityTag(stack);
            String figureId = "";
            if (blockEntityTag != null) {
                if (blockEntityTag.contains("CollectionId")) {
                    collectionId = blockEntityTag.getString("CollectionId");
                }
                if (blockEntityTag.contains("FigureId")) {
                    figureId = blockEntityTag.getString("FigureId");
                }
            }
            if (collectionId == null || collectionId.isEmpty()) {
                return super.getName(stack);
            }
            FigureCollection collection = CollectionRegistry.getCollection(collectionId).orElse(null);
            if (collection == null) {
                return super.getName(stack);
            }
            String collectionName = collection.getName();
            if (figureId != null && !figureId.isEmpty() && (figure = (FigureDefinition)collection.getFigure(figureId).orElse(null)) != null) {
                return Component.literal((String)figure.getName()).withStyle(ChatFormatting.WHITE);
            }
            return Component.literal((String)(collectionName + " Box"));
        }
        if (this.getBlock() instanceof FigureBlock) {
            blockEntityTag = this.getBlockEntityTag(stack);
            String figureId = "";
            if (blockEntityTag != null) {
                if (blockEntityTag.contains("CollectionId")) {
                    collectionId = blockEntityTag.getString("CollectionId");
                }
                if (blockEntityTag.contains("FigureId")) {
                    figureId = blockEntityTag.getString("FigureId");
                }
            }
            if (collectionId == null || collectionId.isEmpty() || figureId.isEmpty()) {
                return super.getName(stack);
            }
            FigureCollection collection = CollectionRegistry.getCollection(collectionId).orElse(null);
            if (collection == null) {
                return super.getName(stack);
            }
            FigureDefinition figure = collection.getFigure(figureId).orElse(null);
            if (figure != null) {
                return Component.literal((String)figure.getName()).withStyle(ChatFormatting.WHITE);
            }
        }
        return super.getName(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        String collectionId = null;
        String figureId = "";
        CompoundTag blockEntityTag = this.getBlockEntityTag(stack);
        Block block = this.getBlock();
        if (block instanceof BoxBlock) {
            BoxBlock boxBlock = (BoxBlock)block;
            if (blockEntityTag != null) {
                if (blockEntityTag.contains("CollectionId")) {
                    collectionId = blockEntityTag.getString("CollectionId");
                }
                if (blockEntityTag.contains("FigureId")) {
                    figureId = blockEntityTag.getString("FigureId");
                }
            }
        } else if (this.getBlock() instanceof FigureBlock) {
            if (blockEntityTag != null) {
                if (blockEntityTag.contains("CollectionId")) {
                    collectionId = blockEntityTag.getString("CollectionId");
                }
                if (blockEntityTag.contains("FigureId")) {
                    figureId = blockEntityTag.getString("FigureId");
                }
            }
        } else {
            return;
        }
        if (collectionId == null || collectionId.isEmpty()) {
            return;
        }
        FigureCollection collection = CollectionRegistry.getCollection(collectionId).orElse(null);
        if (collection != null && figureId != null && !figureId.isEmpty()) {
            tooltip.add((Component)Component.literal((String)collection.getName()).withStyle(ChatFormatting.GRAY));
            FigureDefinition figure = collection.getFigure(figureId).orElse(null);
            if (figure != null && figure.hasAlternatives()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.blockpops.has_alternatives").withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
            }
            if (this.getBlock() instanceof FigureBlock) {
                tooltip.add((Component)Component.translatable((String)"tooltip.blockpops.pose_hint").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
            }
        }
    }
}

