/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import com.theplumteam.BlockPopsMod;
import com.theplumteam.command.ModCommands;
import com.theplumteam.data.IPlayerDiscovery;
import com.theplumteam.data.PlayerDataManager;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureCollection;
import com.theplumteam.figure.PlayerCollectionGenerator;
import com.theplumteam.network.OpenFavoriteColorScreenPacket;
import com.theplumteam.network.SyncDiscoveryDataPacket;
import com.theplumteam.network.SyncDynamicCollectionsPacket;
import com.theplumteam.network.SyncTokenDataPacket;
import com.theplumteam.registry.ModBlockEntities;
import com.theplumteam.registry.ModBlocks;
import com.theplumteam.registry.ModCreativeTabs;
import com.theplumteam.registry.ModItems;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@Mod(value="blockpops")
public final class BlockPopsModForge {
    public BlockPopsModForge(IEventBus modEventBus) {
        ModBlocks.register();
        ModItems.register();
        ModBlockEntities.register();
        ModCreativeTabs.register();
        this.registerServerEvents();
        NeoForge.EVENT_BUS.register((Object)this);
        BlockPopsMod.init();
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
        BlockPopsMod.LOGGER.info("Registered BlockPops commands");
    }

    private void registerServerEvents() {
        LifecycleEvent.SERVER_STARTING.register(server -> {
            BlockPopsMod.LOGGER.info("Loading static collections on server...");
            CollectionRegistry.loadCollections(server.getResourceManager());
            BlockPopsMod.LOGGER.info("Generating World Players collection...");
            FigureCollection playerCollection = PlayerCollectionGenerator.generate(server);
            CollectionRegistry.registerDynamicCollection(playerCollection);
        });
        PlayerEvent.PLAYER_JOIN.register(player -> {
            if (player.getServer() != null) {
                FigureCollection updatedPlayerCollection = PlayerCollectionGenerator.generate(player.getServer());
                CollectionRegistry.registerDynamicCollection(updatedPlayerCollection);
                BlockPopsMod.LOGGER.debug("Updated World Players collection after player join: {}", (Object)player.getName().getString());
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = player;
                    ArrayList<FigureCollection> allCollections = new ArrayList<FigureCollection>(CollectionRegistry.getAllCollections());
                    SyncDynamicCollectionsPacket.sendToPlayer(serverPlayer, allCollections);
                    BlockPopsMod.LOGGER.info("Synced {} collections to joining player {}", (Object)allCollections.size(), (Object)player.getName().getString());
                }
                ArrayList<FigureCollection> dynamicUpdate = new ArrayList<FigureCollection>();
                dynamicUpdate.add(updatedPlayerCollection);
                for (ServerPlayer p : player.getServer().getPlayerList().getPlayers()) {
                    if (p == player) continue;
                    SyncDynamicCollectionsPacket.sendToPlayer(p, dynamicUpdate);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = player;
                    IPlayerDiscovery discovery = PlayerDataManager.getDiscovery((Player)serverPlayer);
                    Set<String> discoveredSet = discovery.getDiscoveredSet();
                    Map<String, String> figureSkins = discovery.getAllFigureSkins();
                    Map<String, String> figureQuickSkins = discovery.getAllFigureQuickSkins();
                    SyncDiscoveryDataPacket.sendToPlayer(serverPlayer, discoveredSet, figureSkins, figureQuickSkins);
                    BlockPopsMod.LOGGER.info("Synced {} discovered figures, {} skins, and {} quick skins to {}", new Object[]{discoveredSet.size(), figureSkins.size(), figureQuickSkins.size(), serverPlayer.getName().getString()});
                    long gameTime = serverPlayer.serverLevel().getGameTime();
                    long nextRegularTime = discovery.getNextRegularTokenTime();
                    long ticksUntilNext = Math.max(0L, nextRegularTime - gameTime);
                    long millisUntilReset = BlockPopsModForge.calculateMillisUntilNextReset();
                    SyncTokenDataPacket.sendToPlayer(serverPlayer, discovery.getRegularTokens(), ticksUntilNext, !discovery.hasUsedTodaySpecialToken(), millisUntilReset);
                    BlockPopsMod.LOGGER.info("Synced token data to {}: {} regular tokens, special: {}", new Object[]{serverPlayer.getName().getString(), discovery.getRegularTokens(), !discovery.hasUsedTodaySpecialToken() ? "available" : "used"});
                    if (!discovery.hasChosenFavoriteColor()) {
                        BlockPopsMod.LOGGER.info("Player {} has not chosen a favorite color. Sending packet to open selection screen.", (Object)serverPlayer.getName().getString());
                        OpenFavoriteColorScreenPacket.sendToPlayer(serverPlayer);
                    }
                }
            }
        });
    }

    private static long calculateMillisUntilNextReset() {
        ZonedDateTime now = ZonedDateTime.now(ZoneId.of("UTC"));
        ZonedDateTime nextReset = now.withHour(18).withMinute(0).withSecond(0).withNano(0);
        if (now.getHour() >= 18) {
            nextReset = nextReset.plusDays(1L);
        }
        return nextReset.toInstant().toEpochMilli() - now.toInstant().toEpochMilli();
    }
}

