/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.neoforge;

import com.theplumteam.BlockPopsMod;
import com.theplumteam.block.PopBlockColor;
import com.theplumteam.client.renderer.BoxBlockItemRenderer;
import com.theplumteam.client.renderer.BoxBlockRenderer;
import com.theplumteam.client.renderer.ClawMachineBlockItemRenderer;
import com.theplumteam.client.renderer.ClawMachineBlockRenderer;
import com.theplumteam.client.renderer.FigureBlockItemRenderer;
import com.theplumteam.client.renderer.FigureBlockRenderer;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.network.ModNetworking;
import com.theplumteam.registry.ModBlockEntities;
import com.theplumteam.registry.ModItems;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;

@EventBusSubscriber(modid="blockpops", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class BlockPopsModForgeClient {
    private static BoxBlockItemRenderer boxRenderer;
    private static FigureBlockItemRenderer figureRenderer;
    private static ClawMachineBlockItemRenderer clawRenderer;

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        ModNetworking.initClient();
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.BOX_BLOCK.get(), context -> new BoxBlockRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.CLAW_MACHINE_BLOCK.get(), context -> new ClawMachineBlockRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.FIGURE_BLOCK.get(), context -> new FigureBlockRenderer());
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        ArrayList<Item> boxItems = new ArrayList<Item>();
        for (PopBlockColor color : PopBlockColor.values()) {
            RegistrySupplier<Item> itemSupplier = ModItems.DEFAULT_BOX_BLOCK_ITEMS.get((Object)color);
            if (itemSupplier == null) continue;
            boxItems.add((Item)itemSupplier.get());
        }
        for (Map.Entry entry : ModItems.BOX_BLOCK_ITEMS.entrySet()) {
            RegistrySupplier itemSupplier = (RegistrySupplier)entry.getValue();
            if (itemSupplier == null) continue;
            boxItems.add((Item)itemSupplier.get());
        }
        if (!boxItems.isEmpty()) {
            IClientItemExtensions boxExtensions = new IClientItemExtensions(){

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    if (boxRenderer == null) {
                        boxRenderer = new BoxBlockItemRenderer();
                    }
                    return boxRenderer;
                }
            };
            event.registerItem(boxExtensions, boxItems.toArray(new Item[0]));
            BlockPopsMod.LOGGER.info("Registered box item renderer for {} items", (Object)boxItems.size());
        }
        if (ModItems.FIGURE_BLOCK_ITEM != null) {
            event.registerItem(new IClientItemExtensions(){

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    if (figureRenderer == null) {
                        figureRenderer = new FigureBlockItemRenderer();
                    }
                    return figureRenderer;
                }
            }, new Item[]{(Item)ModItems.FIGURE_BLOCK_ITEM.get()});
            BlockPopsMod.LOGGER.info("Registered figure block item renderer");
        }
        if (ModItems.CLAW_MACHINE_BLOCK_ITEM != null) {
            event.registerItem(new IClientItemExtensions(){

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    if (clawRenderer == null) {
                        clawRenderer = new ClawMachineBlockItemRenderer();
                    }
                    return clawRenderer;
                }
            }, new Item[]{(Item)ModItems.CLAW_MACHINE_BLOCK_ITEM.get()});
            BlockPopsMod.LOGGER.info("Registered claw machine block item renderer");
        }
    }

    @SubscribeEvent
    public static void registerResourceListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new SimplePreparableReloadListener<Void>(){

            protected Void prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
                return null;
            }

            protected void apply(Void unused, ResourceManager resourceManager, ProfilerFiller profiler) {
                CollectionRegistry.loadCollections(resourceManager);
            }
        });
    }
}

