/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.network;

import com.theplumteam.blockentity.BoxBlockEntity;
import com.theplumteam.network.ModNetworking;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FigurePositionPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(FigurePositionPacket.class);
    private final BlockPos pos;
    private final double offsetX;
    private final double offsetY;
    private final double offsetZ;
    private final double scale;
    private final double hitboxOffsetX;
    private final double hitboxOffsetY;
    private final double hitboxOffsetZ;
    private final double hitboxScaleX;
    private final double hitboxScaleY;
    private final double hitboxScaleZ;
    private final Double logoPositionX;
    private final Double logoPositionY;
    private final Double logoPositionZ;
    private final Double logoScaleX;
    private final Double logoScaleY;
    private final Double logoScaleZ;

    public FigurePositionPacket(BlockPos pos, double offsetX, double offsetY, double offsetZ, double scale, double hitboxOffsetX, double hitboxOffsetY, double hitboxOffsetZ, double hitboxScaleX, double hitboxScaleY, double hitboxScaleZ, Double logoPositionX, Double logoPositionY, Double logoPositionZ, Double logoScaleX, Double logoScaleY, Double logoScaleZ) {
        this.pos = pos;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.scale = scale;
        this.hitboxOffsetX = hitboxOffsetX;
        this.hitboxOffsetY = hitboxOffsetY;
        this.hitboxOffsetZ = hitboxOffsetZ;
        this.hitboxScaleX = hitboxScaleX;
        this.hitboxScaleY = hitboxScaleY;
        this.hitboxScaleZ = hitboxScaleZ;
        this.logoPositionX = logoPositionX;
        this.logoPositionY = logoPositionY;
        this.logoPositionZ = logoPositionZ;
        this.logoScaleX = logoScaleX;
        this.logoScaleY = logoScaleY;
        this.logoScaleZ = logoScaleZ;
    }

    public RegistryFriendlyByteBuf encode() {
        RegistryFriendlyByteBuf buffer = new RegistryFriendlyByteBuf(Unpooled.buffer(), (RegistryAccess)RegistryAccess.EMPTY);
        buffer.writeBlockPos(this.pos);
        buffer.writeDouble(this.offsetX);
        buffer.writeDouble(this.offsetY);
        buffer.writeDouble(this.offsetZ);
        buffer.writeDouble(this.scale);
        buffer.writeDouble(this.hitboxOffsetX);
        buffer.writeDouble(this.hitboxOffsetY);
        buffer.writeDouble(this.hitboxOffsetZ);
        buffer.writeDouble(this.hitboxScaleX);
        buffer.writeDouble(this.hitboxScaleY);
        buffer.writeDouble(this.hitboxScaleZ);
        buffer.writeBoolean(this.logoPositionX != null);
        if (this.logoPositionX != null) {
            buffer.writeDouble(this.logoPositionX.doubleValue());
        }
        buffer.writeBoolean(this.logoPositionY != null);
        if (this.logoPositionY != null) {
            buffer.writeDouble(this.logoPositionY.doubleValue());
        }
        buffer.writeBoolean(this.logoPositionZ != null);
        if (this.logoPositionZ != null) {
            buffer.writeDouble(this.logoPositionZ.doubleValue());
        }
        buffer.writeBoolean(this.logoScaleX != null);
        if (this.logoScaleX != null) {
            buffer.writeDouble(this.logoScaleX.doubleValue());
        }
        buffer.writeBoolean(this.logoScaleY != null);
        if (this.logoScaleY != null) {
            buffer.writeDouble(this.logoScaleY.doubleValue());
        }
        buffer.writeBoolean(this.logoScaleZ != null);
        if (this.logoScaleZ != null) {
            buffer.writeDouble(this.logoScaleZ.doubleValue());
        }
        return buffer;
    }

    public static FigurePositionPacket decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.readBlockPos();
        double offsetX = buffer.readDouble();
        double offsetY = buffer.readDouble();
        double offsetZ = buffer.readDouble();
        double scale = buffer.readDouble();
        double hitboxOffsetX = buffer.readDouble();
        double hitboxOffsetY = buffer.readDouble();
        double hitboxOffsetZ = buffer.readDouble();
        double hitboxScaleX = buffer.readDouble();
        double hitboxScaleY = buffer.readDouble();
        double hitboxScaleZ = buffer.readDouble();
        Double logoPositionX = buffer.readBoolean() ? Double.valueOf(buffer.readDouble()) : null;
        Double logoPositionY = buffer.readBoolean() ? Double.valueOf(buffer.readDouble()) : null;
        Double logoPositionZ = buffer.readBoolean() ? Double.valueOf(buffer.readDouble()) : null;
        Double logoScaleX = buffer.readBoolean() ? Double.valueOf(buffer.readDouble()) : null;
        Double logoScaleY = buffer.readBoolean() ? Double.valueOf(buffer.readDouble()) : null;
        Double logoScaleZ = buffer.readBoolean() ? Double.valueOf(buffer.readDouble()) : null;
        return new FigurePositionPacket(pos, offsetX, offsetY, offsetZ, scale, hitboxOffsetX, hitboxOffsetY, hitboxOffsetZ, hitboxScaleX, hitboxScaleY, hitboxScaleZ, logoPositionX, logoPositionY, logoPositionZ, logoScaleX, logoScaleY, logoScaleZ);
    }

    public static void handleServer(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        FigurePositionPacket packet = FigurePositionPacket.decode(buf);
        LOGGER.info("Received FigurePositionPacket on server - Position: {}", (Object)packet.pos);
        context.queue(() -> {
            Player patt0$temp = context.getPlayer();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                BlockEntity blockEntity = player.level().getBlockEntity(packet.pos);
                if (blockEntity instanceof BoxBlockEntity) {
                    BoxBlockEntity boxBlockEntity = (BoxBlockEntity)blockEntity;
                    LOGGER.info("Setting figure offset, scale, hitbox offset, hitbox scale, and logo config");
                    boxBlockEntity.setFigureOffset(packet.offsetX, packet.offsetY, packet.offsetZ);
                    boxBlockEntity.setFigureScale(packet.scale);
                    boxBlockEntity.setHitboxOffset(packet.hitboxOffsetX, packet.hitboxOffsetY, packet.hitboxOffsetZ);
                    boxBlockEntity.setHitboxScale(packet.hitboxScaleX, packet.hitboxScaleY, packet.hitboxScaleZ);
                    boxBlockEntity.setLogoPosition(packet.logoPositionX, packet.logoPositionY, packet.logoPositionZ);
                    boxBlockEntity.setLogoScale(packet.logoScaleX, packet.logoScaleY, packet.logoScaleZ);
                    boxBlockEntity.setChanged();
                    LOGGER.info("Figure position updated successfully");
                } else {
                    LOGGER.warn("BlockEntity at {} is not a BoxBlockEntity", (Object)packet.pos);
                }
            }
        });
    }

    public void sendToServer() {
        NetworkManager.sendToServer((ResourceLocation)ModNetworking.FIGURE_POSITION, (RegistryFriendlyByteBuf)this.encode());
    }
}

