/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.network;

import com.theplumteam.client.discovery.ClientDiscoveryManager;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncDiscoveryDataPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncDiscoveryDataPacket.class);
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"blockpops", (String)"sync_discovery_data");
    private final Set<String> discoveredFigures;
    private final Map<String, String> figureSkins;
    private final Map<String, String> figureQuickSkins;

    public SyncDiscoveryDataPacket(Set<String> discoveredFigures, Map<String, String> figureSkins, Map<String, String> figureQuickSkins) {
        this.discoveredFigures = new HashSet<String>(discoveredFigures);
        this.figureSkins = new HashMap<String, String>(figureSkins);
        this.figureQuickSkins = new HashMap<String, String>(figureQuickSkins);
    }

    public RegistryFriendlyByteBuf encode() {
        RegistryFriendlyByteBuf buffer = new RegistryFriendlyByteBuf(Unpooled.buffer(), (RegistryAccess)RegistryAccess.EMPTY);
        buffer.writeInt(this.discoveredFigures.size());
        for (String string : this.discoveredFigures) {
            buffer.writeUtf(string);
        }
        buffer.writeInt(this.figureSkins.size());
        for (Map.Entry entry : this.figureSkins.entrySet()) {
            buffer.writeUtf((String)entry.getKey());
            buffer.writeUtf((String)entry.getValue());
        }
        buffer.writeInt(this.figureQuickSkins.size());
        for (Map.Entry entry : this.figureQuickSkins.entrySet()) {
            buffer.writeUtf((String)entry.getKey());
            buffer.writeUtf((String)entry.getValue());
        }
        return buffer;
    }

    public static SyncDiscoveryDataPacket decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashSet<String> discoveredFigures = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            discoveredFigures.add(buffer.readUtf());
        }
        int skinsSize = buffer.readInt();
        HashMap<String, String> figureSkins = new HashMap<String, String>();
        for (int i = 0; i < skinsSize; ++i) {
            String figureId = buffer.readUtf();
            String skinUrl = buffer.readUtf();
            figureSkins.put(figureId, skinUrl);
        }
        int qsSize = buffer.readInt();
        HashMap<String, String> figureQuickSkins = new HashMap<String, String>();
        for (int i = 0; i < qsSize; ++i) {
            String figureId = buffer.readUtf();
            String quickSkinId = buffer.readUtf();
            figureQuickSkins.put(figureId, quickSkinId);
        }
        return new SyncDiscoveryDataPacket(discoveredFigures, figureSkins, figureQuickSkins);
    }

    public static void handleClient(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        SyncDiscoveryDataPacket packet = SyncDiscoveryDataPacket.decode(buf);
        context.queue(() -> {
            LOGGER.info("Received discovery data sync: {} figures discovered, {} skins, {} quick skins", new Object[]{packet.discoveredFigures.size(), packet.figureSkins.size(), packet.figureQuickSkins.size()});
            ClientDiscoveryManager.setData(packet.discoveredFigures, packet.figureSkins, packet.figureQuickSkins);
        });
    }

    public static void sendToPlayer(ServerPlayer player, Set<String> discoveredFigures, Map<String, String> figureSkins) {
        SyncDiscoveryDataPacket.sendToPlayer(player, discoveredFigures, figureSkins, new HashMap<String, String>());
    }

    public static void sendToPlayer(ServerPlayer player, Set<String> discoveredFigures, Map<String, String> figureSkins, Map<String, String> figureQuickSkins) {
        SyncDiscoveryDataPacket packet = new SyncDiscoveryDataPacket(discoveredFigures, figureSkins, figureQuickSkins);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)ID, (RegistryFriendlyByteBuf)packet.encode());
    }

    public Set<String> getDiscoveredFigures() {
        return this.discoveredFigures;
    }

    public Map<String, String> getFigureSkins() {
        return this.figureSkins;
    }

    public Map<String, String> getFigureQuickSkins() {
        return this.figureQuickSkins;
    }
}

