/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.network;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.theplumteam.block.PopBlockColor;
import com.theplumteam.data.IPlayerDiscovery;
import com.theplumteam.data.PlayerDataManager;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureDefinition;
import com.theplumteam.figure.FigureType;
import com.theplumteam.network.UnlockFigurePacket;
import com.theplumteam.registry.ModItems;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Method;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnlockCollectionPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnlockCollectionPacket.class);
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"blockpops", (String)"unlock_collection");
    private final String collectionId;

    public UnlockCollectionPacket(String collectionId) {
        this.collectionId = collectionId;
    }

    public RegistryFriendlyByteBuf encode() {
        RegistryFriendlyByteBuf buffer = new RegistryFriendlyByteBuf(Unpooled.buffer(), (RegistryAccess)RegistryAccess.EMPTY);
        buffer.writeUtf(this.collectionId);
        return buffer;
    }

    public static UnlockCollectionPacket decode(FriendlyByteBuf buffer) {
        String collectionId = buffer.readUtf();
        return new UnlockCollectionPacket(collectionId);
    }

    public static void handleServer(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        UnlockCollectionPacket packet = UnlockCollectionPacket.decode(buf);
        context.queue(() -> {
            Player patt0$temp = context.getPlayer();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                LOGGER.info("Player {} requested to unlock collection: {}", (Object)player.getName().getString(), (Object)packet.collectionId);
                IPlayerDiscovery discovery = PlayerDataManager.getDiscovery((Player)player);
                UnlockCollectionPacket.unlockEntireCollection(player, packet.collectionId, discovery);
                PlayerDataManager.markDirty((Player)player, discovery);
            }
        });
    }

    private static void unlockEntireCollection(ServerPlayer player, String collectionId, IPlayerDiscovery discovery) {
        CollectionRegistry.getCollection(collectionId).ifPresent(collection -> {
            List<FigureDefinition> figures = collection.getFigures();
            if (figures.isEmpty()) {
                LOGGER.warn("Collection {} has no figures", (Object)collectionId);
                return;
            }
            LOGGER.info("Unlocking {} figures from collection {} for player {}", new Object[]{figures.size(), collectionId, player.getName().getString()});
            for (FigureDefinition figure : figures) {
                UnlockCollectionPacket.giveBoxForFigure(player, collectionId, figure, discovery);
            }
            LOGGER.info("Successfully unlocked all figures from collection {} for player {}", (Object)collectionId, (Object)player.getName().getString());
        });
    }

    @Nullable
    private static String getQuickSkinIdFromServer(UUID playerId) {
        try {
            Class<?> repoClass = Class.forName("com.quickskin.mod.server.data.ServerPlayerAppearanceRepository");
            Method getInstanceMethod = repoClass.getMethod("getInstance", new Class[0]);
            Object repoInstance = getInstanceMethod.invoke(null, new Object[0]);
            Method getAppearanceMethod = repoClass.getMethod("getAppearance", UUID.class);
            Object appearance = getAppearanceMethod.invoke(repoInstance, playerId);
            if (appearance != null) {
                Class<?> appearanceClass = appearance.getClass();
                Method getSkinIdMethod = appearanceClass.getMethod("getSkinId", new Class[0]);
                return (String)getSkinIdMethod.invoke(appearance, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static void giveBoxForFigure(ServerPlayer player, String collectionId, FigureDefinition figure, IPlayerDiscovery discovery) {
        String oldSnapshot;
        ItemStack boxItem = null;
        if (collectionId.equals("world_players")) {
            PopBlockColor color = figure.getFavoriteColor();
            if (color == null) {
                color = PopBlockColor.ORIGINAL;
            }
            boxItem = new ItemStack((ItemLike)ModItems.DEFAULT_BOX_BLOCK_ITEMS.get((Object)color).get());
        } else {
            boxItem = ModItems.BOX_BLOCK_ITEMS.containsKey(collectionId) ? new ItemStack((ItemLike)ModItems.BOX_BLOCK_ITEMS.get(collectionId).get()) : new ItemStack((ItemLike)ModItems.DEFAULT_BOX_BLOCK_ITEMS.get((Object)PopBlockColor.ORIGINAL).get());
        }
        if (boxItem == null) {
            LOGGER.warn("Could not find box item for collection {}", (Object)collectionId);
            return;
        }
        String uniqueFigureId = collectionId + ":" + figure.getId();
        String skinSnapshot = null;
        String quickSkinSnapshot = null;
        if (figure.getType() == FigureType.PLAYER) {
            String qsId;
            GameProfile freshProfile = UnlockCollectionPacket.getFreshGameProfile(player, figure);
            if (freshProfile != null && !freshProfile.getProperties().get((Object)"textures").isEmpty()) {
                skinSnapshot = ((Property)freshProfile.getProperties().get((Object)"textures").iterator().next()).value();
                discovery.saveFigureSkin(uniqueFigureId, skinSnapshot);
                LOGGER.debug("Saved skin snapshot for player figure: {}", (Object)uniqueFigureId);
            }
            if (figure.getPlayerUUID() != null && (qsId = UnlockCollectionPacket.getQuickSkinIdFromServer(figure.getPlayerUUID())) != null && !qsId.isEmpty()) {
                quickSkinSnapshot = qsId;
                discovery.saveFigureQuickSkin(uniqueFigureId, quickSkinSnapshot);
                LOGGER.info("Captured & Saved Quick Skin ID for figure {}: {}", (Object)uniqueFigureId, (Object)qsId);
            }
        }
        if (!discovery.isDiscovered(uniqueFigureId)) {
            discovery.discover(uniqueFigureId);
            UnlockFigurePacket.sendToPlayer(player, uniqueFigureId, figure.getName(), skinSnapshot, quickSkinSnapshot);
            LOGGER.debug("Unlocked new figure: {} ({})", (Object)figure.getName(), (Object)uniqueFigureId);
        }
        CompoundTag blockEntityTag = new CompoundTag();
        blockEntityTag.putString("FigureId", figure.getId());
        blockEntityTag.putString("CollectionId", collectionId);
        if (collectionId.equals("world_players")) {
            PopBlockColor color = figure.getFavoriteColor();
            if (color == null) {
                color = PopBlockColor.ORIGINAL;
            }
            blockEntityTag.putString("Color", color.name());
        }
        if (skinSnapshot != null && !skinSnapshot.isEmpty()) {
            blockEntityTag.putString("SkinSnapshot", skinSnapshot);
        } else if (figure.getType() == FigureType.PLAYER && (oldSnapshot = discovery.getFigureSkin(uniqueFigureId)) != null && !oldSnapshot.isEmpty()) {
            blockEntityTag.putString("SkinSnapshot", oldSnapshot);
        }
        if (quickSkinSnapshot != null) {
            blockEntityTag.putString("QuickSkinId", quickSkinSnapshot);
        }
        blockEntityTag.putString("id", "blockpops:box_block");
        boxItem.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)blockEntityTag));
        ItemEntity itemEntity = new ItemEntity(player.level(), player.getX(), player.getY() + 1.0, player.getZ(), boxItem);
        itemEntity.setDeltaMovement(0.0, 0.2, 0.0);
        player.level().addFreshEntity((Entity)itemEntity);
    }

    @Nullable
    private static GameProfile getFreshGameProfile(ServerPlayer player, FigureDefinition figure) {
        if (figure.getPlayerUUID() == null) {
            return null;
        }
        try {
            ProfileResult result = player.getServer().getSessionService().fetchProfile(figure.getPlayerUUID(), true);
            return result != null ? result.profile() : null;
        }
        catch (Exception e) {
            LOGGER.error("Failed to fetch fresh GameProfile for {}: {}", (Object)figure.getName(), (Object)e.getMessage());
            return null;
        }
    }

    public void sendToServer() {
        NetworkManager.sendToServer((ResourceLocation)ID, (RegistryFriendlyByteBuf)this.encode());
    }
}

