/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.platform.neoforge;

import com.theplumteam.blockentity.BoxBlockEntity;
import com.theplumteam.blockentity.ClawMachineBlockEntity;
import com.theplumteam.client.ClientHelpers;
import java.nio.file.Path;
import net.minecraft.core.BlockPos;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;

public class PlatformHelperImpl {
    public static String getPlatformName() {
        return "NeoForge";
    }

    public static Path getGameDirectory() {
        return FMLPaths.GAMEDIR.get();
    }

    public static Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static String getModVersion() {
        return ModList.get().getModContainerById("blockpops").map(container -> container.getModInfo().getVersion().toString()).orElse("UNKNOWN");
    }

    public static boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    public static void openBoxFigureScreen(BlockPos pos, BoxBlockEntity boxBlockEntity) {
        if (FMLLoader.getDist().isClient()) {
            ClientHelpers.openBoxFigureScreen(pos, boxBlockEntity);
        }
    }

    public static void openClawMachineScreen(BlockPos pos, ClawMachineBlockEntity clawMachineBlockEntity) {
        if (FMLLoader.getDist().isClient()) {
            ClientHelpers.openClawMachineScreen(pos, clawMachineBlockEntity);
        }
    }
}

