/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.theplumteam.client.config.ClientConfig;
import com.theplumteam.client.discovery.ClientDiscoveryManager;
import com.theplumteam.client.gui.SettingsScreen;
import com.theplumteam.client.gui.StarPatternCache;
import com.theplumteam.client.gui.util.GuiScaleManager;
import com.theplumteam.client.gui.widget.CollectionEntry;
import com.theplumteam.client.gui.widget.CollectionListWidget;
import com.theplumteam.client.gui.widget.FigureListWidget;
import com.theplumteam.client.gui.widget.LinkButton;
import com.theplumteam.client.renderer.FigureWidgetRenderer;
import com.theplumteam.client.token.ClientTokenManager;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureCollection;
import com.theplumteam.figure.FigureDefinition;
import com.theplumteam.network.ClawMachineCollectionPacket;
import com.theplumteam.network.DropBoxPacket;
import com.theplumteam.network.TokenType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionSelectionScreen
extends class_437 {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionSelectionScreen.class);
    private final class_2338 blockPos;
    private String selectedCollectionId;
    private final List<FigureCollection> collections;
    @Nullable
    private CollectionListWidget collectionListWidget;
    @Nullable
    private FigureListWidget figureListWidget;
    private class_4185 useRegularButton;
    private class_4185 useSpecialButton;
    private class_4185 doneButton;
    private int panelX;
    private int panelY;
    private int panelWidth;
    private int panelHeight;
    private static final int MIN_PANEL_WIDTH = 500;
    private static final int MAX_PANEL_WIDTH = 1200;
    private static final int MIN_PANEL_HEIGHT = 400;
    private float currentColorR;
    private float currentColorG;
    private float currentColorB;
    private float targetColorR;
    private float targetColorG;
    private float targetColorB;
    private float colorTransitionProgress = 1.0f;
    private static final float COLOR_TRANSITION_SPEED = 0.05f;
    private static final float COLOR_SNAP_THRESHOLD = 0.95f;
    private boolean guiScaleForced = false;
    private boolean isClosing = false;
    private static final class_2960 DISCORD_ICON = class_2960.method_60655((String)"blockpops", (String)"textures/gui/discord_icon.png");
    private static final class_2960 CURSEFORGE_ICON = class_2960.method_60655((String)"blockpops", (String)"textures/gui/curseforge_icon.png");
    private static final class_2960 MODRINTH_ICON = class_2960.method_60655((String)"blockpops", (String)"textures/gui/modrinth_icon.png");
    private static final class_2960 SETTINGS_ICON = class_2960.method_60655((String)"blockpops", (String)"textures/gui/settings_icon.png");
    private static final String DISCORD_URL = "https://discord.gg/yGxdvA7qej";
    private static final String CURSEFORGE_URL = "https://www.curseforge.com/minecraft/mc-mods/blockpops";
    private static final String MODRINTH_URL = "https://modrinth.com/mod/blockpops";

    public CollectionSelectionScreen(class_2338 blockPos, String currentCollectionId) {
        super((class_2561)class_2561.method_43470((String)"Claw Machine Configuration"));
        this.blockPos = blockPos;
        this.selectedCollectionId = currentCollectionId;
        this.collections = CollectionRegistry.getAllCollections().stream().filter(c -> !"default".equals(c.getId())).collect(Collectors.toCollection(ArrayList::new));
        this.collections.sort((c1, c2) -> {
            boolean c1IsPlayers = "world_players".equals(c1.getId());
            boolean c2IsPlayers = "world_players".equals(c2.getId());
            if (c1IsPlayers && !c2IsPlayers) {
                return -1;
            }
            if (!c1IsPlayers && c2IsPlayers) {
                return 1;
            }
            return 0;
        });
        ClientConfig config = ClientConfig.getInstance();
        this.currentColorR = config.backgroundColorR;
        this.currentColorG = config.backgroundColorG;
        this.currentColorB = config.backgroundColorB;
        this.targetColorR = config.backgroundColorR;
        this.targetColorG = config.backgroundColorG;
        this.targetColorB = config.backgroundColorB;
        this.colorTransitionProgress = 1.0f;
        LOGGER.info("CollectionSelectionScreen opened at {} with current collection: {}", (Object)blockPos, (Object)currentCollectionId);
    }

    protected void method_25426() {
        FigureWidgetRenderer.ensureInitialized();
        if (!this.guiScaleForced && !this.isClosing) {
            this.guiScaleForced = true;
            int optimalScale = GuiScaleManager.getOptimalMenuScale();
            if (GuiScaleManager.setMenuGuiScale(optimalScale)) {
                return;
            }
        }
        super.method_25426();
        this.method_37067();
        this.calculatePanelDimensions();
        int scaledPadding = 10;
        int scaledSpacing = 6;
        int scaledComponentHeight = 20;
        int leftPanelWidth = (int)((float)this.panelWidth * 0.45f);
        int rightPanelWidth = (int)((float)this.panelWidth * 0.5f);
        int componentX = this.panelX + scaledPadding;
        int yPos = this.panelY + scaledPadding + scaledComponentHeight + scaledPadding;
        int topSectionHeight = scaledPadding + scaledComponentHeight + scaledPadding;
        Objects.requireNonNull(this.field_22793);
        int tokenInfoHeight = 9 + scaledSpacing;
        int extraBottomSpacing = 5;
        int bottomSectionHeight = tokenInfoHeight + scaledComponentHeight * 2 + scaledSpacing + scaledPadding + extraBottomSpacing;
        int listHeight = this.panelHeight - topSectionHeight - bottomSectionHeight;
        int collectionHeaderHeight = 30;
        this.collectionListWidget = new CollectionListWidget(this, this.field_22787, leftPanelWidth, listHeight, yPos, 55);
        this.collectionListWidget.setXPosition(componentX);
        this.method_25429((class_364)this.collectionListWidget);
        this.loadCollections();
        int previewX = this.panelX + this.panelWidth - rightPanelWidth - scaledPadding;
        int headerHeight = 50;
        int figureListY = yPos;
        int figureListHeight = listHeight;
        this.figureListWidget = new FigureListWidget(this.field_22787, rightPanelWidth, figureListHeight, figureListY, 90);
        this.figureListWidget.setXPosition(previewX);
        this.method_25429((class_364)this.figureListWidget);
        if (this.selectedCollectionId != null && !this.selectedCollectionId.isEmpty()) {
            CollectionRegistry.getCollection(this.selectedCollectionId).ifPresent(collection -> {
                if (this.figureListWidget != null) {
                    this.figureListWidget.setCollection((FigureCollection)collection);
                }
            });
        }
        int bottomY = this.panelY + this.panelHeight - scaledPadding;
        int fullWidthX = this.panelX + scaledPadding;
        int fullComponentWidth = this.panelWidth - scaledPadding * 2;
        this.doneButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), button -> this.method_25419()).method_46434(fullWidthX, bottomY -= scaledComponentHeight, fullComponentWidth, scaledComponentHeight).method_46431();
        this.method_37063((class_364)this.doneButton);
        int buttonWidth = (fullComponentWidth - scaledSpacing) / 2;
        this.useRegularButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Use Regular Token"), button -> {
            if (this.selectedCollectionId != null && !this.selectedCollectionId.isEmpty()) {
                LOGGER.info("Using regular token for collection: {}", (Object)this.selectedCollectionId);
                DropBoxPacket packet = new DropBoxPacket(this.blockPos, this.selectedCollectionId, TokenType.REGULAR);
                packet.sendToServer();
                this.method_25419();
            }
        }).method_46434(fullWidthX, bottomY -= scaledComponentHeight + scaledSpacing, buttonWidth, scaledComponentHeight).method_46431();
        this.method_37063((class_364)this.useRegularButton);
        this.useSpecialButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Use Guaranteed Token"), button -> {
            if (this.selectedCollectionId != null && !this.selectedCollectionId.isEmpty()) {
                LOGGER.info("Using guaranteed token for collection: {}", (Object)this.selectedCollectionId);
                DropBoxPacket packet = new DropBoxPacket(this.blockPos, this.selectedCollectionId, TokenType.GUARANTEED);
                packet.sendToServer();
                this.method_25419();
            }
        }).method_46434(fullWidthX + buttonWidth + scaledSpacing, bottomY, buttonWidth, scaledComponentHeight).method_46431();
        this.method_37063((class_364)this.useSpecialButton);
        this.updateTokenButtonStates();
        int buttonSize = 24;
        int linkButtonY = this.panelY + scaledPadding;
        int settingsButtonX = this.panelX + this.panelWidth - buttonSize - scaledPadding;
        this.method_37063((class_364)new LinkButton(settingsButtonX, linkButtonY, buttonSize, buttonSize, SETTINGS_ICON, null, (class_2561)class_2561.method_43470((String)"Settings")){

            public void method_25306() {
                CollectionSelectionScreen.this.openSettingsScreen();
            }
        });
        int discordButtonX = settingsButtonX - buttonSize - scaledSpacing;
        this.method_37063((class_364)new LinkButton(discordButtonX, linkButtonY, buttonSize, buttonSize, DISCORD_ICON, DISCORD_URL, (class_2561)class_2561.method_43470((String)"Join our Discord!")));
        int curseforgeButtonX = discordButtonX - buttonSize - scaledSpacing;
        this.method_37063((class_364)new LinkButton(curseforgeButtonX, linkButtonY, buttonSize, buttonSize, CURSEFORGE_ICON, CURSEFORGE_URL, (class_2561)class_2561.method_43470((String)"Visit our CurseForge page")));
        int modrinthButtonX = curseforgeButtonX - buttonSize - scaledSpacing;
        this.method_37063((class_364)new LinkButton(modrinthButtonX, linkButtonY, buttonSize, buttonSize, MODRINTH_ICON, MODRINTH_URL, (class_2561)class_2561.method_43470((String)"Visit our Modrinth page")));
    }

    private void calculatePanelDimensions() {
        int screenWidth = GuiScaleManager.isUsingInverseScale() ? GuiScaleManager.getVirtualWidth() : this.field_22789;
        int screenHeight = GuiScaleManager.isUsingInverseScale() ? GuiScaleManager.getVirtualHeight() : this.field_22790;
        int desiredWidth = (int)((float)screenWidth * 0.8f);
        int desiredHeight = (int)((float)screenHeight * 0.85f);
        this.panelWidth = class_3532.method_15340((int)desiredWidth, (int)500, (int)Math.min(1200, screenWidth - 60));
        this.panelHeight = class_3532.method_15340((int)desiredHeight, (int)400, (int)(screenHeight - 60));
        this.panelX = (screenWidth - this.panelWidth) / 2;
        this.panelY = (screenHeight - this.panelHeight) / 2;
    }

    public void method_25432() {
        super.method_25432();
        if (this.isClosing) {
            this.restoreGuiScaleIfNeeded();
        }
    }

    public void method_25419() {
        this.isClosing = true;
        this.restoreGuiScaleIfNeeded();
        super.method_25419();
    }

    private void restoreGuiScaleIfNeeded() {
        if (this.guiScaleForced) {
            this.guiScaleForced = false;
            GuiScaleManager.restoreOriginalGuiScale();
        }
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
        int adjustedMouseX = mouseX;
        int adjustedMouseY = mouseY;
        if (GuiScaleManager.isUsingInverseScale()) {
            adjustedMouseX = (int)GuiScaleManager.transformMouseX(mouseX);
            adjustedMouseY = (int)GuiScaleManager.transformMouseY(mouseY);
        }
        if (GuiScaleManager.isUsingInverseScale()) {
            graphics.method_51448().method_22903();
            float scale = GuiScaleManager.getRenderScaleFactor();
            graphics.method_51448().method_22905(scale, scale, 1.0f);
        }
        this.renderBackgroundEffects(graphics, partialTick);
        this.renderPanel(graphics);
        super.method_25394(graphics, adjustedMouseX, adjustedMouseY, partialTick);
        this.renderTokenInfo(graphics);
        this.renderCollectionListHeader(graphics);
        this.renderFigurePanelHeader(graphics);
        if (GuiScaleManager.isUsingInverseScale()) {
            graphics.method_51448().method_22909();
        }
        if (this.collectionListWidget != null) {
            this.collectionListWidget.method_25394(graphics, adjustedMouseX, adjustedMouseY, partialTick);
        }
        if (this.figureListWidget != null) {
            this.figureListWidget.method_25394(graphics, adjustedMouseX, adjustedMouseY, partialTick);
        }
    }

    private void renderCollectionListHeader(class_332 graphics) {
        if (this.collectionListWidget == null) {
            return;
        }
        int scaledPadding = 10;
        int scaledComponentHeight = 20;
        int leftPanelWidth = (int)((float)this.panelWidth * 0.45f);
        int componentX = this.panelX + scaledPadding;
        int headerStartY = this.panelY + scaledPadding;
        int headerHeight = scaledComponentHeight + scaledPadding;
        int currentY = headerStartY + 4;
        graphics.method_51433(this.field_22793, "Collections", componentX + 8, currentY, 0xFFFFFF, false);
        Objects.requireNonNull(this.field_22793);
        String collectionCount = this.collections.size() + " collections available";
        graphics.method_51433(this.field_22793, collectionCount, componentX + 8, currentY += 9 + 4, 0xAAAAAA, false);
        Objects.requireNonNull(this.field_22793);
        graphics.method_25294(componentX + 8, currentY += 9 + 4, componentX + leftPanelWidth - 8, currentY + 1, 0x40FFFFFF);
    }

    private void renderFigurePanelHeader(class_332 graphics) {
        if (this.figureListWidget == null) {
            return;
        }
        FigureCollection collection = this.figureListWidget.getCurrentCollection();
        if (collection == null) {
            return;
        }
        int scaledPadding = 10;
        int scaledComponentHeight = 20;
        int rightPanelWidth = (int)((float)this.panelWidth * 0.5f);
        int previewX = this.panelX + this.panelWidth - rightPanelWidth - scaledPadding;
        int headerStartY = this.panelY + scaledPadding;
        int currentY = headerStartY + 4;
        graphics.method_51433(this.field_22793, collection.getName(), previewX + 8, currentY, 0xFFFFFF, false);
        Objects.requireNonNull(this.field_22793);
        String figureCount = collection.getFigures().size() + " figures in this collection";
        graphics.method_51433(this.field_22793, figureCount, previewX + 8, currentY += 9 + 4, 0xAAAAAA, false);
        Objects.requireNonNull(this.field_22793);
        graphics.method_25294(previewX + 8, currentY += 9 + 4, previewX + rightPanelWidth - 8, currentY + 1, 0x40FFFFFF);
    }

    private void renderBackgroundEffects(class_332 graphics, float partialTick) {
        float lerpedB;
        float lerpedG;
        float lerpedR;
        ClientConfig config = ClientConfig.getInstance();
        if (this.colorTransitionProgress < 1.0f) {
            this.colorTransitionProgress = Math.min(1.0f, this.colorTransitionProgress + 0.05f);
            if (this.colorTransitionProgress >= 0.95f) {
                this.colorTransitionProgress = 1.0f;
            }
            if (this.colorTransitionProgress >= 1.0f) {
                config.backgroundColorR = this.targetColorR;
                config.backgroundColorG = this.targetColorG;
                config.backgroundColorB = this.targetColorB;
            }
        }
        if (this.colorTransitionProgress >= 1.0f) {
            lerpedR = config.backgroundColorR;
            lerpedG = config.backgroundColorG;
            lerpedB = config.backgroundColorB;
        } else {
            lerpedR = class_3532.method_16439((float)this.colorTransitionProgress, (float)this.currentColorR, (float)this.targetColorR);
            lerpedG = class_3532.method_16439((float)this.colorTransitionProgress, (float)this.currentColorG, (float)this.targetColorG);
            lerpedB = class_3532.method_16439((float)this.colorTransitionProgress, (float)this.currentColorB, (float)this.targetColorB);
        }
        int bgRed = (int)(lerpedR * 255.0f);
        int bgGreen = (int)(lerpedG * 255.0f);
        int bgBlue = (int)(lerpedB * 255.0f);
        int bgColor = 0xFF000000 | bgRed << 16 | bgGreen << 8 | bgBlue;
        int bgWidth = GuiScaleManager.isUsingInverseScale() ? GuiScaleManager.getVirtualWidth() : this.field_22789;
        int bgHeight = GuiScaleManager.isUsingInverseScale() ? GuiScaleManager.getVirtualHeight() : this.field_22790;
        graphics.method_25294(0, 0, bgWidth, bgHeight, bgColor);
        this.renderStarPattern(graphics, partialTick);
    }

    private void renderStarPattern(class_332 graphics, float partialTick) {
        double pixelsPerSecond = 5.0;
        int tileSize = StarPatternCache.getTileSize();
        int tickCount = this.field_22787 != null ? this.field_22787.field_1705.method_1738() : 0;
        double smoothTime = (double)((float)tickCount + partialTick) / 20.0;
        double offsetX = smoothTime * pixelsPerSecond % (double)tileSize;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        ClientConfig config = ClientConfig.getInstance();
        RenderSystem.setShaderColor((float)config.starColorR, (float)config.starColorG, (float)config.starColorB, (float)config.starOpacity);
        class_2960 cacheTexture = StarPatternCache.getTextureLocation();
        int cacheWidth = StarPatternCache.getTextureWidth();
        int cacheHeight = StarPatternCache.getTextureHeight();
        float u0 = (float)offsetX / (float)cacheWidth;
        float v0 = 0.0f;
        float u1 = u0 + (float)(GuiScaleManager.isUsingInverseScale() ? GuiScaleManager.getVirtualWidth() : this.field_22789) / (float)cacheWidth;
        float v1 = (float)(GuiScaleManager.isUsingInverseScale() ? GuiScaleManager.getVirtualHeight() : this.field_22790) / (float)cacheHeight;
        class_4587 pose = graphics.method_51448();
        pose.method_22903();
        RenderSystem.setShaderTexture((int)0, (class_2960)cacheTexture);
        RenderSystem.setShader(class_757::method_34542);
        int starHeight = GuiScaleManager.isUsingInverseScale() ? GuiScaleManager.getVirtualHeight() : this.field_22790;
        int starWidth = GuiScaleManager.isUsingInverseScale() ? GuiScaleManager.getVirtualWidth() : this.field_22789;
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(pose.method_23760().method_23761(), 0.0f, (float)starHeight, 0.0f).method_22913(u0, v1);
        bufferBuilder.method_22918(pose.method_23760().method_23761(), (float)starWidth, (float)starHeight, 0.0f).method_22913(u1, v1);
        bufferBuilder.method_22918(pose.method_23760().method_23761(), (float)starWidth, 0.0f, 0.0f).method_22913(u1, v0);
        bufferBuilder.method_22918(pose.method_23760().method_23761(), 0.0f, 0.0f, 0.0f).method_22913(u0, v0);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        pose.method_22909();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderPanel(class_332 graphics) {
        ClientConfig config = ClientConfig.getInstance();
        int alpha = (int)(config.panelOpacity * 255.0f);
        int panelBgColor = alpha << 24 | 0;
        graphics.method_25294(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + this.panelHeight, panelBgColor);
        graphics.method_25294(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + 1, 0x60FFFFFF);
        graphics.method_25294(this.panelX, this.panelY + this.panelHeight - 1, this.panelX + this.panelWidth, this.panelY + this.panelHeight, 0x60FFFFFF);
        graphics.method_25294(this.panelX, this.panelY + 1, this.panelX + 1, this.panelY + this.panelHeight - 1, 0x60FFFFFF);
        graphics.method_25294(this.panelX + this.panelWidth - 1, this.panelY + 1, this.panelX + this.panelWidth, this.panelY + this.panelHeight - 1, 0x60FFFFFF);
    }

    private void loadCollections() {
        if (this.collectionListWidget == null) {
            return;
        }
        for (FigureCollection collection : this.collections) {
            this.collectionListWidget.addCollectionEntry(collection);
        }
        if (this.selectedCollectionId != null && !this.selectedCollectionId.isEmpty()) {
            this.collectionListWidget.selectByCollectionId(this.selectedCollectionId);
        }
    }

    public void onCollectionSelected(CollectionEntry entry) {
        if (entry != null) {
            FigureCollection collection = entry.getCollection();
            this.selectedCollectionId = collection.getId();
            if (collection.hasBackgroundColor()) {
                int[] bgColor = collection.getBackgroundColor();
                ClientConfig config = ClientConfig.getInstance();
                this.currentColorR = config.backgroundColorR;
                this.currentColorG = config.backgroundColorG;
                this.currentColorB = config.backgroundColorB;
                this.targetColorR = (float)bgColor[0] / 255.0f;
                this.targetColorG = (float)bgColor[1] / 255.0f;
                this.targetColorB = (float)bgColor[2] / 255.0f;
                if (config.enableColorTransition) {
                    this.colorTransitionProgress = 0.0f;
                } else {
                    this.colorTransitionProgress = 1.0f;
                    config.backgroundColorR = this.targetColorR;
                    config.backgroundColorG = this.targetColorG;
                    config.backgroundColorB = this.targetColorB;
                }
            }
            if (this.figureListWidget != null) {
                this.figureListWidget.setCollection(collection);
            }
            this.sendUpdate();
            this.updateTokenButtonStates();
        }
    }

    private void updateTokenButtonStates() {
        boolean hasSelection;
        boolean bl = hasSelection = this.selectedCollectionId != null && !this.selectedCollectionId.isEmpty();
        if (this.useRegularButton != null) {
            boolean bl2 = this.useRegularButton.field_22763 = hasSelection && ClientTokenManager.getRegularTokens() > 0;
        }
        if (this.useSpecialButton != null) {
            boolean collectionComplete = hasSelection && this.isCollectionComplete();
            this.useSpecialButton.field_22763 = hasSelection && ClientTokenManager.hasSpecialToken() && !collectionComplete;
        }
    }

    private boolean isCollectionComplete() {
        if (this.selectedCollectionId == null || this.selectedCollectionId.isEmpty()) {
            return false;
        }
        return CollectionRegistry.getCollection(this.selectedCollectionId).map(collection -> {
            for (FigureDefinition figure : collection.getFigures()) {
                String figureId = collection.getId() + ":" + figure.getId();
                if (ClientDiscoveryManager.isDiscovered(figureId)) continue;
                return false;
            }
            return true;
        }).orElse(false);
    }

    private void renderTokenInfo(class_332 graphics) {
        int scaledPadding = 10;
        int scaledSpacing = 6;
        int scaledComponentHeight = 20;
        int bottomY = this.panelY + this.panelHeight - scaledPadding;
        bottomY -= scaledComponentHeight;
        Objects.requireNonNull(this.field_22793);
        int tokenInfoY = (bottomY -= scaledComponentHeight + scaledSpacing) - 9 - scaledSpacing;
        int blueColor = 0x5599FF;
        int goldColor = 16766720;
        int fullWidthX = this.panelX + scaledPadding;
        int fullComponentWidth = this.panelWidth - scaledPadding * 2;
        int buttonWidth = (fullComponentWidth - scaledSpacing) / 2;
        int regularTokens = ClientTokenManager.getRegularTokens();
        String regularText = "Regular Tokens: " + regularTokens + "/3";
        if (regularTokens < 3) {
            String nextRegularTime = ClientTokenManager.formatNextRegularTime();
            regularText = regularText + " - Next: " + nextRegularTime;
        }
        int regularButtonCenterX = fullWidthX + buttonWidth / 2;
        int regularTextWidth = this.field_22793.method_1727(regularText);
        int regularTextX = regularButtonCenterX - regularTextWidth / 2;
        graphics.method_51433(this.field_22793, regularText, regularTextX, tokenInfoY, blueColor, false);
        boolean hasSpecial = ClientTokenManager.hasSpecialToken();
        String specialText = "Guaranteed Token: " + (hasSpecial ? "Available" : "Used");
        if (!hasSpecial) {
            String nextSpecialTime = ClientTokenManager.formatNextSpecialResetTime();
            specialText = specialText + " - Resets: " + nextSpecialTime;
        }
        int specialButtonCenterX = fullWidthX + buttonWidth + scaledSpacing + buttonWidth / 2;
        int specialTextWidth = this.field_22793.method_1727(specialText);
        int specialTextX = specialButtonCenterX - specialTextWidth / 2;
        graphics.method_51433(this.field_22793, specialText, specialTextX, tokenInfoY, goldColor, false);
    }

    public void method_25393() {
        super.method_25393();
        this.updateTokenButtonStates();
    }

    private void sendUpdate() {
        LOGGER.info("Sending collection update - Position: {}, Collection ID: {}", (Object)this.blockPos, (Object)this.selectedCollectionId);
        ClawMachineCollectionPacket packet = new ClawMachineCollectionPacket(this.blockPos, this.selectedCollectionId);
        packet.sendToServer();
    }

    private void openSettingsScreen() {
        this.field_22787.method_1507((class_437)new SettingsScreen(this));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (GuiScaleManager.isUsingInverseScale()) {
            mouseX = GuiScaleManager.transformMouseX(mouseX);
            mouseY = GuiScaleManager.transformMouseY(mouseY);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (GuiScaleManager.isUsingInverseScale()) {
            mouseX = GuiScaleManager.transformMouseX(mouseX);
            mouseY = GuiScaleManager.transformMouseY(mouseY);
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (GuiScaleManager.isUsingInverseScale()) {
            mouseX = GuiScaleManager.transformMouseX(mouseX);
            mouseY = GuiScaleManager.transformMouseY(mouseY);
            float scale = GuiScaleManager.getMouseScaleFactor();
            dragX *= (double)scale;
            dragY *= (double)scale;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (GuiScaleManager.isUsingInverseScale()) {
            mouseX = GuiScaleManager.transformMouseX(mouseX);
            mouseY = GuiScaleManager.transformMouseY(mouseY);
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public void method_16014(double mouseX, double mouseY) {
        if (GuiScaleManager.isUsingInverseScale()) {
            mouseX = GuiScaleManager.transformMouseX(mouseX);
            mouseY = GuiScaleManager.transformMouseY(mouseY);
        }
        super.method_16014(mouseX, mouseY);
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_57734(float partialTick) {
    }
}

