/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.figure;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.theplumteam.BlockPopsMod;
import com.theplumteam.figure.FigureCollection;
import com.theplumteam.figure.FigureDefinition;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class CollectionRegistry {
    private static final Gson GSON = new Gson();
    private static final Map<String, FigureCollection> collections = new LinkedHashMap<String, FigureCollection>();
    private static final Map<String, FigureDefinition> figuresById = new HashMap<String, FigureDefinition>();
    private static final Map<String, FigureCollection> dynamicCollections = new LinkedHashMap<String, FigureCollection>();
    private static boolean initialized = false;

    public static void loadCollections(class_3300 resourceManager) {
        collections.clear();
        figuresById.clear();
        for (Map.Entry<String, FigureCollection> entry : dynamicCollections.entrySet()) {
            CollectionRegistry.registerCollectionInternal(entry.getValue(), false);
        }
        try {
            Map resources = resourceManager.method_14488("collections", location -> location.method_12832().endsWith(".json"));
            BlockPopsMod.LOGGER.info("Loading figure collections...");
            for (Map.Entry entry : resources.entrySet()) {
                class_2960 location2 = (class_2960)entry.getKey();
                try {
                    InputStream stream = ((class_3298)entry.getValue()).method_14482();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                        JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                        FigureCollection collection = FigureCollection.fromJson(json);
                        collections.put(collection.getId(), collection);
                        for (FigureDefinition figure : collection.getFigures()) {
                            String fullId = collection.getId() + ":" + figure.getId();
                            figuresById.put(fullId, figure);
                        }
                        BlockPopsMod.LOGGER.info("Loaded collection '{}' with {} figures from {}", new Object[]{collection.getName(), collection.getFigures().size(), location2});
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception e) {
                    BlockPopsMod.LOGGER.error("Failed to load collection from {}: {}", (Object)location2, (Object)e.getMessage());
                }
            }
            initialized = true;
            BlockPopsMod.LOGGER.info("Loaded {} collections with {} total figures", (Object)collections.size(), (Object)figuresById.size());
        }
        catch (Exception e) {
            BlockPopsMod.LOGGER.error("Failed to load collections: {}", (Object)e.getMessage());
        }
    }

    public static Optional<FigureCollection> getCollection(String collectionId) {
        return Optional.ofNullable(collections.get(collectionId));
    }

    public static Optional<FigureDefinition> getFigure(String collectionId, String figureId) {
        String fullId = collectionId + ":" + figureId;
        return Optional.ofNullable(figuresById.get(fullId));
    }

    public static Collection<FigureCollection> getAllCollections() {
        return Collections.unmodifiableCollection(collections.values());
    }

    public static Set<String> getCollectionIds() {
        return Collections.unmodifiableSet(collections.keySet());
    }

    public static boolean hasCollection(String collectionId) {
        return collections.containsKey(collectionId);
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static Optional<FigureCollection> getDefaultCollection() {
        if (collections.containsKey("default")) {
            return Optional.of(collections.get("default"));
        }
        return collections.values().stream().findFirst();
    }

    public static void registerDynamicCollection(FigureCollection collection) {
        dynamicCollections.put(collection.getId(), collection);
        CollectionRegistry.registerCollectionInternal(collection, true);
    }

    private static void registerCollectionInternal(FigureCollection collection, boolean isDynamic) {
        collections.put(collection.getId(), collection);
        for (FigureDefinition figure : collection.getFigures()) {
            String fullId = collection.getId() + ":" + figure.getId();
            figuresById.put(fullId, figure);
        }
        if (isDynamic) {
            BlockPopsMod.LOGGER.info("Registered dynamic collection '{}' with {} figures", (Object)collection.getName(), (Object)collection.getFigures().size());
        }
    }
}

