/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.server;

import com.theplumteam.BlockPopsMod;
import com.theplumteam.data.IPlayerDiscovery;
import com.theplumteam.data.PlayerDataManager;
import com.theplumteam.network.SyncTokenDataPacket;
import com.theplumteam.server.config.ServerConfig;
import dev.architectury.event.events.common.TickEvent;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ServerTickHandler {
    private static final long REGULAR_TOKEN_COOLDOWN_TICKS = 216000L;
    private static final int MAX_REGULAR_TOKENS = 3;
    private static long lastCheckTick = 0L;
    private static final int CHECK_INTERVAL = 20;

    public static void init() {
        TickEvent.SERVER_POST.register(ServerTickHandler::onServerTick);
        BlockPopsMod.LOGGER.info("Server tick handler initialized");
    }

    private static void onServerTick(MinecraftServer server) {
        if ((long)server.method_3780() - lastCheckTick < 20L) {
            return;
        }
        lastCheckTick = server.method_3780();
        for (class_3222 player : server.method_3760().method_14571()) {
            IPlayerDiscovery discovery = PlayerDataManager.getDiscovery((class_1657)player);
            boolean needsSync = false;
            needsSync |= ServerTickHandler.processRegularTokens(player, discovery);
            if (!(needsSync |= ServerTickHandler.processSpecialTokenReset(discovery))) continue;
            PlayerDataManager.markDirty((class_1657)player, discovery);
            ServerTickHandler.sendSyncPacket(player, discovery);
        }
    }

    private static boolean processRegularTokens(class_3222 player, IPlayerDiscovery discovery) {
        class_3218 world = player.method_51469();
        long gameTime = world.method_8510();
        if (discovery.getRegularTokens() < 3 && gameTime >= discovery.getNextRegularTokenTime()) {
            discovery.setRegularTokens(discovery.getRegularTokens() + 1);
            discovery.setNextRegularTokenTime(gameTime + 216000L);
            BlockPopsMod.LOGGER.debug("Granted regular token to {}. Total: {}/{}", new Object[]{player.method_5477().getString(), discovery.getRegularTokens(), 3});
            return true;
        }
        return false;
    }

    private static boolean processSpecialTokenReset(IPlayerDiscovery discovery) {
        int resetHour;
        ZonedDateTime todayReset;
        long lastUpdateMillis = discovery.getLastSpecialTokenResetTimestamp();
        if (lastUpdateMillis == 0L) {
            discovery.setLastSpecialTokenResetTimestamp(System.currentTimeMillis());
            return false;
        }
        ZonedDateTime now = ZonedDateTime.now(ZoneId.of("UTC"));
        ZonedDateTime mostRecentReset = now.isBefore(todayReset = now.withHour(resetHour = ServerConfig.getInstance().getGuaranteedTokenResetHour()).withMinute(0).withSecond(0).withNano(0)) ? todayReset.minusDays(1L) : todayReset;
        if (lastUpdateMillis < mostRecentReset.toInstant().toEpochMilli()) {
            discovery.setLastSpecialTokenResetTimestamp(System.currentTimeMillis());
            if (discovery.hasUsedTodaySpecialToken()) {
                discovery.setUsedTodaySpecialToken(false);
                BlockPopsMod.LOGGER.debug("Daily token reset for player (Reset point was: {})", (Object)mostRecentReset);
            }
            return true;
        }
        return false;
    }

    private static void sendSyncPacket(class_3222 player, IPlayerDiscovery discovery) {
        class_3218 world = player.method_51469();
        long gameTime = world.method_8510();
        long nextRegularTime = discovery.getNextRegularTokenTime();
        long ticksUntilNext = Math.max(0L, nextRegularTime - gameTime);
        long millisUntilReset = ServerTickHandler.calculateMillisUntilNextReset();
        SyncTokenDataPacket.sendToPlayer(player, discovery.getRegularTokens(), ticksUntilNext, !discovery.hasUsedTodaySpecialToken(), millisUntilReset);
    }

    public static long calculateMillisUntilNextReset() {
        int resetHour = ServerConfig.getInstance().getGuaranteedTokenResetHour();
        ZonedDateTime now = ZonedDateTime.now(ZoneId.of("UTC"));
        ZonedDateTime nextReset = now.withHour(resetHour).withMinute(0).withSecond(0).withNano(0);
        if (now.getHour() >= resetHour) {
            nextReset = nextReset.plusDays(1L);
        }
        return nextReset.toInstant().toEpochMilli() - now.toInstant().toEpochMilli();
    }
}

