/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.capability;

import com.theplumteam.capability.PlayerDiscovery;
import com.theplumteam.capability.PlayerDiscoveryProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(modid="blockpops", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CapabilityEvents {
    private static final Logger LOGGER = LoggerFactory.getLogger(CapabilityEvents.class);
    private static final ResourceLocation PLAYER_DISCOVERY_CAP = new ResourceLocation("blockpops", "player_discovery");
    private static final String MIGRATION_MARKER = "blockpops_cap_migrated";

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            PlayerDiscoveryProvider provider = new PlayerDiscoveryProvider();
            event.addCapability(PLAYER_DISCOVERY_CAP, (ICapabilityProvider)provider);
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(PlayerDiscoveryProvider.PLAYER_DISCOVERY).ifPresent(oldDiscovery -> event.getEntity().getCapability(PlayerDiscoveryProvider.PLAYER_DISCOVERY).ifPresent(newDiscovery -> newDiscovery.syncFrom(oldDiscovery.getDiscoveredSet())));
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        CompoundTag existingData;
        Player player = event.getEntity();
        CompoundTag persistentData = player.getPersistentData();
        if (persistentData.m_128471_(MIGRATION_MARKER)) {
            return;
        }
        if (persistentData.m_128425_("blockpops_discovery", 10) && (existingData = persistentData.m_128469_("blockpops_discovery")).m_128425_("FigureSkins", 10)) {
            persistentData.m_128379_(MIGRATION_MARKER, true);
            return;
        }
        player.getCapability(PlayerDiscoveryProvider.PLAYER_DISCOVERY).ifPresent(oldDiscovery -> {
            if (oldDiscovery instanceof PlayerDiscovery) {
                boolean hasData;
                PlayerDiscovery capDiscovery = (PlayerDiscovery)oldDiscovery;
                CompoundTag capData = capDiscovery.serializeNBT();
                boolean bl = hasData = !capDiscovery.getDiscoveredSet().isEmpty() || !capDiscovery.getAllFigureSkins().isEmpty() || capDiscovery.hasChosenFavoriteColor() || capDiscovery.getRegularTokens() > 0;
                if (hasData) {
                    persistentData.m_128365_("blockpops_discovery", (Tag)capData);
                    LOGGER.info("Migrated discovery data for player {} - {} discovered figures, {} skin snapshots", new Object[]{player.m_7755_().getString(), capDiscovery.getDiscoveredSet().size(), capDiscovery.getAllFigureSkins().size()});
                }
            }
        });
        persistentData.m_128379_(MIGRATION_MARKER, true);
    }
}

