/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.gui.widget;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.theplumteam.blockentity.BoxBlockEntity;
import com.theplumteam.client.discovery.ClientDiscoveryManager;
import com.theplumteam.client.gui.util.GuiScaleManager;
import com.theplumteam.client.model.FigureModel;
import com.theplumteam.client.renderer.FigureWidgetRenderer;
import com.theplumteam.figure.FigureDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public class FigureEntry
extends ObjectSelectionList.Entry<FigureEntry> {
    private final Minecraft mc = Minecraft.m_91087_();
    private final List<FigureDefinition> figures;
    private final String collectionId;
    private float modelScale = 1.0f;
    private float xRotation = 0.0f;
    private float yRotation = 70.0f;
    private float zRotation = 0.0f;
    private float xOffset = -60.0f;
    private float yOffset = 15.0f;
    private float zOffset = 0.0f;
    private static final int FIGURE_SIZE = 80;
    private static final int GRID_SPACING = 4;

    public FigureEntry(List<FigureDefinition> figures, String collectionId) {
        this.figures = new ArrayList<FigureDefinition>(figures);
        this.collectionId = collectionId;
    }

    public void setConfiguration(float modelScale, float xRotation, float yRotation, float zRotation, float xOffset, float yOffset, float zOffset) {
        this.modelScale = modelScale;
        this.xRotation = xRotation;
        this.yRotation = yRotation;
        this.zRotation = zRotation;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
    }

    public void m_6311_(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
        int effectiveFigureSize = 80;
        int effectiveSpacing = 4;
        if (GuiScaleManager.isUsingInverseScale()) {
            float scale = GuiScaleManager.getRenderScaleFactor();
            effectiveFigureSize = (int)(80.0f * scale);
            effectiveSpacing = (int)(4.0f * scale);
        }
        int totalFiguresWidth = this.figures.size() * effectiveFigureSize + (this.figures.size() - 1) * effectiveSpacing;
        int startX = x + (entryWidth - totalFiguresWidth) / 2;
        for (int i = 0; i < this.figures.size(); ++i) {
            boolean isFigureHovered;
            FigureDefinition figure = this.figures.get(i);
            int figureX = startX + i * (effectiveFigureSize + effectiveSpacing);
            String uniqueFigureId = this.collectionId + ":" + figure.getId();
            boolean isDiscovered = ClientDiscoveryManager.isDiscovered(uniqueFigureId);
            if (isDiscovered) {
                graphics.m_280509_(figureX, y, figureX + effectiveFigureSize, y + effectiveFigureSize, 0x30FFFFFF);
            } else {
                graphics.m_280509_(figureX, y, figureX + effectiveFigureSize, y + effectiveFigureSize, 0x50000000);
            }
            boolean bl = isFigureHovered = mouseX >= figureX && mouseX < figureX + effectiveFigureSize && mouseY >= y && mouseY < y + effectiveFigureSize;
            if (isFigureHovered) {
                if (isDiscovered) {
                    graphics.m_280509_(figureX, y, figureX + effectiveFigureSize, y + effectiveFigureSize, 0x40FFFFFF);
                } else {
                    graphics.m_280509_(figureX, y, figureX + effectiveFigureSize, y + effectiveFigureSize, 0x60000000);
                }
            }
            int borderColor = isDiscovered ? -2130706433 : 0x60808080;
            graphics.m_280509_(figureX, y, figureX + effectiveFigureSize, y + 1, borderColor);
            graphics.m_280509_(figureX, y + effectiveFigureSize - 1, figureX + effectiveFigureSize, y + effectiveFigureSize, borderColor);
            graphics.m_280509_(figureX, y, figureX + 1, y + effectiveFigureSize, borderColor);
            graphics.m_280509_(figureX + effectiveFigureSize - 1, y, figureX + effectiveFigureSize, y + effectiveFigureSize, borderColor);
            if (isDiscovered) {
                this.render3DFigure(graphics, figure, figureX, y, effectiveFigureSize, partialTick);
                int guiScale = (Integer)this.mc.f_91066_.m_231928_().m_231551_();
                if (guiScale >= 3) continue;
                MutableComponent figureName = Component.m_237113_((String)figure.getName());
                int nameWidth = this.mc.f_91062_.m_92852_((FormattedText)figureName);
                if (nameWidth > effectiveFigureSize - 4) {
                    String truncated = figure.getName();
                    while (this.mc.f_91062_.m_92895_(truncated + "...") > effectiveFigureSize - 4 && truncated.length() > 0) {
                        truncated = truncated.substring(0, truncated.length() - 1);
                    }
                    figureName = Component.m_237113_((String)(truncated + "..."));
                }
                int nameX = figureX + (effectiveFigureSize - this.mc.f_91062_.m_92852_((FormattedText)figureName)) / 2;
                Objects.requireNonNull(this.mc.f_91062_);
                int nameY = y + effectiveFigureSize - 9 - 2;
                graphics.m_280614_(this.mc.f_91062_, (Component)figureName, nameX, nameY, 0xFFFFFF, true);
                continue;
            }
            MutableComponent questionMark = Component.m_237113_((String)"?");
            int qmWidth = this.mc.f_91062_.m_92852_((FormattedText)questionMark);
            int qmX = figureX + (effectiveFigureSize - qmWidth) / 2;
            Objects.requireNonNull(this.mc.f_91062_);
            int qmY = y + (effectiveFigureSize - 9) / 2;
            graphics.m_280614_(this.mc.f_91062_, (Component)questionMark, qmX, qmY, 0x808080, false);
        }
    }

    private void render3DFigure(GuiGraphics graphics, FigureDefinition figure, int x, int y, int size, float partialTick) {
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        BoxBlockEntity renderEntity = FigureWidgetRenderer.getOrCreateRenderEntity(figure, this.collectionId);
        if (renderEntity == null) {
            poseStack.m_85849_();
            return;
        }
        graphics.m_280588_(x, y, x + size, y + size);
        RenderSystem.disableDepthTest();
        float centerX = (float)x + (float)size / 2.0f + this.xOffset;
        float centerY = (float)y + (float)size * 0.6f + this.yOffset;
        float baseZ = 100.0f + this.zOffset;
        float centerZ = baseZ * ((float)size / 80.0f);
        Lighting.m_84930_();
        poseStack.m_252880_(centerX, centerY, centerZ);
        float scale = (float)size * this.modelScale;
        poseStack.m_85841_(scale, -scale, scale);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(this.yRotation));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(this.xRotation));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(this.zRotation));
        MultiBufferSource.BufferSource bufferSource = this.mc.m_91269_().m_110104_();
        FigureModel figureModel = FigureWidgetRenderer.getModel();
        GeoBlockRenderer<BoxBlockEntity> figureRenderer = FigureWidgetRenderer.getRenderer();
        try {
            ResourceLocation modelResource = figureModel.getModelResource(renderEntity);
            if (modelResource == null) {
                RenderSystem.enableDepthTest();
                graphics.m_280618_();
                poseStack.m_85849_();
                return;
            }
            BakedGeoModel bakedModel = figureModel.getBakedModel(modelResource);
            ResourceLocation textureResource = figureModel.getTextureResource(renderEntity);
            if (textureResource == null) {
                RenderSystem.enableDepthTest();
                graphics.m_280618_();
                poseStack.m_85849_();
                return;
            }
            RenderType renderType = figureModel.getRenderType(renderEntity, textureResource);
            VertexConsumer buffer = bufferSource.m_6299_(renderType);
            figureRenderer.actuallyRender(poseStack, (BlockEntity)renderEntity, bakedModel, renderType, (MultiBufferSource)bufferSource, buffer, false, partialTick, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            bufferSource.m_109911_();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RenderSystem.enableDepthTest();
        graphics.m_280618_();
        Lighting.m_84931_();
        poseStack.m_85849_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return false;
    }

    public Component m_142172_() {
        if (this.figures.isEmpty()) {
            return Component.m_237113_((String)"Empty row");
        }
        if (this.figures.size() == 1) {
            FigureDefinition figure = this.figures.get(0);
            String uniqueFigureId = this.collectionId + ":" + figure.getId();
            boolean isDiscovered = ClientDiscoveryManager.isDiscovered(uniqueFigureId);
            return Component.m_237113_((String)(isDiscovered ? figure.getName() : "Undiscovered Figure"));
        }
        int discoveredCount = 0;
        for (FigureDefinition figure : this.figures) {
            String uniqueFigureId = this.collectionId + ":" + figure.getId();
            if (!ClientDiscoveryManager.isDiscovered(uniqueFigureId)) continue;
            ++discoveredCount;
        }
        return Component.m_237113_((String)(discoveredCount + " of " + this.figures.size() + " figures discovered"));
    }

    public List<FigureDefinition> getFigures() {
        return this.figures;
    }
}

