/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.gui.widget;

import com.theplumteam.client.gui.util.GuiScaleManager;
import com.theplumteam.client.gui.widget.FigureEntry;
import com.theplumteam.figure.FigureCollection;
import com.theplumteam.figure.FigureDefinition;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import org.jetbrains.annotations.Nullable;

public class FigureListWidget
extends ObjectSelectionList<FigureEntry> {
    @Nullable
    private FigureCollection currentCollection;
    private float modelScale = 1.0f;
    private float xRotation = 0.0f;
    private float yRotation = 150.0f;
    private float zRotation = 0.0f;
    private float xOffset = 14.0f;
    private float yOffset = 15.0f;
    private float zOffset = 0.0f;

    public FigureListWidget(Minecraft mc, int width, int height, int y, int entryHeight) {
        super(mc, width, height, y, y + height, entryHeight);
    }

    public void setCollection(@Nullable FigureCollection collection) {
        this.currentCollection = collection;
        this.m_6702_().clear();
        if (collection != null) {
            List<FigureDefinition> figures = collection.getFigures();
            ArrayList<FigureDefinition> currentRow = new ArrayList<FigureDefinition>();
            for (int i = 0; i < figures.size(); ++i) {
                currentRow.add(figures.get(i));
                if (currentRow.size() != 4 && i != figures.size() - 1) continue;
                FigureEntry entry = new FigureEntry(currentRow, collection.getId());
                entry.setConfiguration(this.modelScale, this.xRotation, this.yRotation, this.zRotation, this.xOffset, this.yOffset, this.zOffset);
                this.m_7085_((AbstractSelectionList.Entry)entry);
                currentRow = new ArrayList();
            }
        }
        this.m_93410_(0.0);
    }

    public void updateConfiguration(float modelScale, float xRotation, float yRotation, float zRotation, float xOffset, float yOffset, float zOffset) {
        this.modelScale = modelScale;
        this.xRotation = xRotation;
        this.yRotation = yRotation;
        this.zRotation = zRotation;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
        for (FigureEntry entry : this.m_6702_()) {
            entry.setConfiguration(modelScale, xRotation, yRotation, zRotation, xOffset, yOffset, zOffset);
        }
    }

    public float getModelScale() {
        return this.modelScale;
    }

    public float getXRotation() {
        return this.xRotation;
    }

    public float getYRotation() {
        return this.yRotation;
    }

    public float getZRotation() {
        return this.zRotation;
    }

    public float getXOffset() {
        return this.xOffset;
    }

    public float getYOffset() {
        return this.yOffset;
    }

    public float getZOffset() {
        return this.zOffset;
    }

    @Nullable
    public FigureCollection getCurrentCollection() {
        return this.currentCollection;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (GuiScaleManager.isUsingInverseScale()) {
            float scale = GuiScaleManager.getRenderScaleFactor();
            int origX0 = this.f_93393_;
            int origX1 = this.f_93392_;
            int origY0 = this.f_93390_;
            int origY1 = this.f_93391_;
            int origWidth = this.f_93388_;
            int origHeight = this.f_93389_;
            this.f_93393_ = (int)((float)origX0 * scale);
            this.f_93392_ = (int)((float)origX1 * scale);
            this.f_93390_ = (int)((float)origY0 * scale);
            this.f_93391_ = (int)((float)origY1 * scale);
            this.f_93388_ = (int)((float)origWidth * scale);
            this.f_93389_ = (int)((float)origHeight * scale);
            int scaledMouseX = (int)((float)mouseX * scale);
            int scaledMouseY = (int)((float)mouseY * scale);
            double origScroll = this.m_93517_();
            this.m_93410_(origScroll * (double)scale);
            super.m_88315_(graphics, scaledMouseX, scaledMouseY, partialTick);
            this.f_93393_ = origX0;
            this.f_93392_ = origX1;
            this.f_93390_ = origY0;
            this.f_93391_ = origY1;
            this.f_93388_ = origWidth;
            this.f_93389_ = origHeight;
            this.m_93410_(origScroll);
        } else {
            super.m_88315_(graphics, mouseX, mouseY, partialTick);
        }
    }

    public int m_5759_() {
        return this.f_93388_ - 8;
    }

    private int getScaledItemHeight() {
        if (GuiScaleManager.isUsingInverseScale()) {
            return (int)((float)this.f_93387_ * GuiScaleManager.getRenderScaleFactor());
        }
        return this.f_93387_;
    }

    protected int m_7610_(int index) {
        return this.f_93390_ + 4 - (int)this.m_93517_() + index * this.getScaledItemHeight() + this.f_93395_;
    }

    protected int m_5775_() {
        return this.f_93395_ + this.m_5773_() * this.getScaledItemHeight();
    }

    protected int m_5756_() {
        return this.f_93392_ - 6;
    }

    protected void m_7733_(GuiGraphics graphics) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        this.m_93410_(this.m_93517_() - amount * 20.0);
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }
}

