/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.theplumteam.BlockPopsMod;
import com.theplumteam.block.PopBlockColor;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureCollection;
import com.theplumteam.figure.PlayerCollectionHelper;
import com.theplumteam.network.SyncDynamicCollectionsPacket;
import com.theplumteam.server.config.ServerConfig;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public class SetDefaultColorCommand {
    private static final SuggestionProvider<CommandSourceStack> COLOR_SUGGESTIONS = (context, builder) -> SharedSuggestionProvider.m_82981_(Stream.of(PopBlockColor.values()).map(PopBlockColor::m_7912_), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"blockpops").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"setdefaultcolor").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"color", (ArgumentType)StringArgumentType.word()).suggests(COLOR_SUGGESTIONS).executes(SetDefaultColorCommand::executeCommand))));
    }

    private static int executeCommand(CommandContext<CommandSourceStack> context) {
        String colorName = StringArgumentType.getString(context, (String)"color");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            PopBlockColor color = PopBlockColor.valueOf(colorName.toUpperCase());
            ServerConfig.getInstance().setDefaultPlayerColor(color);
            BlockPopsMod.LOGGER.info("Default player color set to: {}", (Object)color.m_7912_());
            if (source.m_81377_() != null) {
                FigureCollection updatedCollection = PlayerCollectionHelper.generate(source.m_81377_());
                CollectionRegistry.registerDynamicCollection(updatedCollection);
                ArrayList<FigureCollection> dynamicCollections = new ArrayList<FigureCollection>();
                dynamicCollections.add(updatedCollection);
                SyncDynamicCollectionsPacket.sendToAllPlayers(source.m_81377_(), dynamicCollections);
                BlockPopsMod.LOGGER.info("Synced updated World Players collection to all players");
            }
            source.m_288197_(() -> Component.m_237113_((String)("Set default player collection color to: " + color.m_7912_())), true);
            return 1;
        }
        catch (IllegalArgumentException e) {
            source.m_81352_((Component)Component.m_237113_((String)("Invalid color name: " + colorName + ". Valid colors: original, black, blue, brown, cyan, gray, green, light_blue, light_gray, lime, magenta, orange, pink, purple, red, yellow")));
            return 0;
        }
    }
}

