/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.forge;

import com.mojang.brigadier.CommandDispatcher;
import com.theplumteam.BlockPopsMod;
import com.theplumteam.command.ModCommands;
import com.theplumteam.data.IPlayerDiscovery;
import com.theplumteam.data.PlayerDataManager;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureCollection;
import com.theplumteam.figure.PlayerCollectionGenerator;
import com.theplumteam.network.OpenFavoriteColorScreenPacket;
import com.theplumteam.network.SyncDiscoveryDataPacket;
import com.theplumteam.network.SyncDynamicCollectionsPacket;
import com.theplumteam.network.SyncTokenDataPacket;
import com.theplumteam.registry.ModBlockEntities;
import com.theplumteam.registry.ModBlocks;
import com.theplumteam.registry.ModCreativeTabs;
import com.theplumteam.registry.ModItems;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.platform.forge.EventBuses;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="blockpops")
public final class BlockPopsModForge {
    public BlockPopsModForge() {
        EventBuses.registerModEventBus((String)"blockpops", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        ModBlocks.register();
        ModItems.register();
        ModBlockEntities.register();
        ModCreativeTabs.register();
        this.registerServerEvents();
        MinecraftForge.EVENT_BUS.register((Object)this);
        BlockPopsMod.init();
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
        BlockPopsMod.LOGGER.info("Registered BlockPops commands");
    }

    private void registerServerEvents() {
        LifecycleEvent.SERVER_STARTING.register(server -> {
            BlockPopsMod.LOGGER.info("Loading static collections on server...");
            CollectionRegistry.loadCollections(server.m_177941_());
            BlockPopsMod.LOGGER.info("Generating World Players collection...");
            FigureCollection playerCollection = PlayerCollectionGenerator.generate(server);
            CollectionRegistry.registerDynamicCollection(playerCollection);
        });
        PlayerEvent.PLAYER_JOIN.register(player -> {
            if (player.m_20194_() != null) {
                FigureCollection updatedPlayerCollection = PlayerCollectionGenerator.generate(player.m_20194_());
                CollectionRegistry.registerDynamicCollection(updatedPlayerCollection);
                BlockPopsMod.LOGGER.debug("Updated World Players collection after player join: {}", (Object)player.m_7755_().getString());
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = player;
                    ArrayList<FigureCollection> allCollections = new ArrayList<FigureCollection>(CollectionRegistry.getAllCollections());
                    SyncDynamicCollectionsPacket.sendToPlayer(serverPlayer, allCollections);
                    BlockPopsMod.LOGGER.info("Synced {} collections to joining player {}", (Object)allCollections.size(), (Object)player.m_7755_().getString());
                }
                ArrayList<FigureCollection> dynamicUpdate = new ArrayList<FigureCollection>();
                dynamicUpdate.add(updatedPlayerCollection);
                for (ServerPlayer p : player.m_20194_().m_6846_().m_11314_()) {
                    if (p == player) continue;
                    SyncDynamicCollectionsPacket.sendToPlayer(p, dynamicUpdate);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = player;
                    IPlayerDiscovery discovery = PlayerDataManager.getDiscovery((Player)serverPlayer);
                    SyncDiscoveryDataPacket.sendToPlayer(serverPlayer, discovery.getDiscoveredSet(), discovery.getAllFigureSkins(), discovery.getAllFigureQuickSkins());
                    BlockPopsMod.LOGGER.info("Synced {} discovered figures, {} skins, and {} quick skins to {}", new Object[]{discovery.getDiscoveredSet().size(), discovery.getAllFigureSkins().size(), discovery.getAllFigureQuickSkins().size(), serverPlayer.m_7755_().getString()});
                    long gameTime = serverPlayer.m_284548_().m_46467_();
                    long nextRegularTime = discovery.getNextRegularTokenTime();
                    long ticksUntilNext = Math.max(0L, nextRegularTime - gameTime);
                    long millisUntilReset = BlockPopsModForge.calculateMillisUntilNextReset();
                    SyncTokenDataPacket.sendToPlayer(serverPlayer, discovery.getRegularTokens(), ticksUntilNext, !discovery.hasUsedTodaySpecialToken(), millisUntilReset);
                    BlockPopsMod.LOGGER.info("Synced token data to {}: {} regular tokens, special: {}", new Object[]{serverPlayer.m_7755_().getString(), discovery.getRegularTokens(), !discovery.hasUsedTodaySpecialToken() ? "available" : "used"});
                    if (!discovery.hasChosenFavoriteColor()) {
                        BlockPopsMod.LOGGER.info("Player {} has not chosen a favorite color. Sending packet to open selection screen.", (Object)serverPlayer.m_7755_().getString());
                        OpenFavoriteColorScreenPacket.sendToPlayer(serverPlayer);
                    }
                }
            }
        });
    }

    private static long calculateMillisUntilNextReset() {
        ZonedDateTime now = ZonedDateTime.now(ZoneId.of("UTC"));
        ZonedDateTime nextReset = now.withHour(18).withMinute(0).withSecond(0).withNano(0);
        if (now.getHour() >= 18) {
            nextReset = nextReset.plusDays(1L);
        }
        return nextReset.toInstant().toEpochMilli() - now.toInstant().toEpochMilli();
    }
}

