/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.gui.widget;

import com.theplumteam.client.gui.util.GuiScaleManager;
import com.theplumteam.client.gui.widget.FigureEntry;
import com.theplumteam.figure.FigureCollection;
import com.theplumteam.figure.FigureDefinition;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import org.jetbrains.annotations.Nullable;

public class FigureListWidget
extends class_4280<FigureEntry> {
    @Nullable
    private FigureCollection currentCollection;
    private float modelScale = 1.0f;
    private float xRotation = 0.0f;
    private float yRotation = 150.0f;
    private float zRotation = 0.0f;
    private float xOffset = 14.0f;
    private float yOffset = 15.0f;
    private float zOffset = 0.0f;

    public FigureListWidget(class_310 mc, int width, int height, int y, int entryHeight) {
        super(mc, width, height, y, y + height, entryHeight);
    }

    public void setCollection(@Nullable FigureCollection collection) {
        this.currentCollection = collection;
        this.method_25396().clear();
        if (collection != null) {
            List<FigureDefinition> figures = collection.getFigures();
            ArrayList<FigureDefinition> currentRow = new ArrayList<FigureDefinition>();
            for (int i = 0; i < figures.size(); ++i) {
                currentRow.add(figures.get(i));
                if (currentRow.size() != 4 && i != figures.size() - 1) continue;
                FigureEntry entry = new FigureEntry(currentRow, collection.getId());
                entry.setConfiguration(this.modelScale, this.xRotation, this.yRotation, this.zRotation, this.xOffset, this.yOffset, this.zOffset);
                this.method_25321((class_350.class_351)entry);
                currentRow = new ArrayList();
            }
        }
        this.method_25307(0.0);
    }

    public void updateConfiguration(float modelScale, float xRotation, float yRotation, float zRotation, float xOffset, float yOffset, float zOffset) {
        this.modelScale = modelScale;
        this.xRotation = xRotation;
        this.yRotation = yRotation;
        this.zRotation = zRotation;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
        for (FigureEntry entry : this.method_25396()) {
            entry.setConfiguration(modelScale, xRotation, yRotation, zRotation, xOffset, yOffset, zOffset);
        }
    }

    public float getModelScale() {
        return this.modelScale;
    }

    public float getXRotation() {
        return this.xRotation;
    }

    public float getYRotation() {
        return this.yRotation;
    }

    public float getZRotation() {
        return this.zRotation;
    }

    public float getXOffset() {
        return this.xOffset;
    }

    public float getYOffset() {
        return this.yOffset;
    }

    public float getZOffset() {
        return this.zOffset;
    }

    @Nullable
    public FigureCollection getCurrentCollection() {
        return this.currentCollection;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        if (GuiScaleManager.isUsingInverseScale()) {
            float scale = GuiScaleManager.getRenderScaleFactor();
            int origX0 = this.field_19088;
            int origX1 = this.field_19087;
            int origY0 = this.field_19085;
            int origY1 = this.field_19086;
            int origWidth = this.field_22742;
            int origHeight = this.field_22743;
            this.field_19088 = (int)((float)origX0 * scale);
            this.field_19087 = (int)((float)origX1 * scale);
            this.field_19085 = (int)((float)origY0 * scale);
            this.field_19086 = (int)((float)origY1 * scale);
            this.field_22742 = (int)((float)origWidth * scale);
            this.field_22743 = (int)((float)origHeight * scale);
            int scaledMouseX = (int)((float)mouseX * scale);
            int scaledMouseY = (int)((float)mouseY * scale);
            double origScroll = this.method_25341();
            this.method_25307(origScroll * (double)scale);
            super.method_25394(graphics, scaledMouseX, scaledMouseY, partialTick);
            this.field_19088 = origX0;
            this.field_19087 = origX1;
            this.field_19085 = origY0;
            this.field_19086 = origY1;
            this.field_22742 = origWidth;
            this.field_22743 = origHeight;
            this.method_25307(origScroll);
        } else {
            super.method_25394(graphics, mouseX, mouseY, partialTick);
        }
    }

    public int method_25322() {
        return this.field_22742 - 8;
    }

    private int getScaledItemHeight() {
        if (GuiScaleManager.isUsingInverseScale()) {
            return (int)((float)this.field_22741 * GuiScaleManager.getRenderScaleFactor());
        }
        return this.field_22741;
    }

    protected int method_25337(int index) {
        return this.field_19085 + 4 - (int)this.method_25341() + index * this.getScaledItemHeight() + this.field_22748;
    }

    protected int method_25317() {
        return this.field_22748 + this.method_25340() * this.getScaledItemHeight();
    }

    protected int method_25329() {
        return this.field_19087 - 6;
    }

    protected void method_25325(class_332 graphics) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        this.method_25307(this.method_25341() - amount * 20.0);
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }
}

