/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.renderer;

import com.theplumteam.blockentity.BoxBlockEntity;
import com.theplumteam.client.model.BoxBlockModel;
import com.theplumteam.client.model.FigureModel;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureCollection;
import com.theplumteam.figure.FigureDefinition;
import com.theplumteam.util.SkinModelDetector;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public class BoxBlockRenderer
extends GeoBlockRenderer<BoxBlockEntity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoxBlockRenderer.class);
    private final GeoBlockRenderer<BoxBlockEntity> figureRenderer = new GeoBlockRenderer<BoxBlockEntity>((GeoModel)new FigureModel()){

        protected void rotateBlock(class_2350 facing, class_4587 poseStack) {
        }

        public void preRender(class_4587 poseStack, BoxBlockEntity animatable, BakedGeoModel model, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            super.preRender(poseStack, (class_2586)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
            if (animatable.hasFigure()) {
                class_2960 texture = this.getGeoModel().getTextureResource((GeoAnimatable)animatable);
                SkinModelDetector.SkinModel skinModel = SkinModelDetector.detectSkinModel(texture);
                boolean isSlim = skinModel == SkinModelDetector.SkinModel.SLIM;
                GeoBone rightArmSlim = model.getBone("RightArmSlim").orElse(null);
                GeoBone leftArmSlim = model.getBone("LeftArmSlim").orElse(null);
                GeoBone rightArmClassic = model.getBone("RightArmClassic").orElse(null);
                GeoBone leftArmClassic = model.getBone("LeftArmClassic").orElse(null);
                if (rightArmSlim != null) {
                    rightArmSlim.setHidden(!isSlim);
                }
                if (leftArmSlim != null) {
                    leftArmSlim.setHidden(!isSlim);
                }
                if (rightArmClassic != null) {
                    rightArmClassic.setHidden(isSlim);
                }
                if (leftArmClassic != null) {
                    leftArmClassic.setHidden(isSlim);
                }
            }
        }
    };
    private boolean renderingFigure = false;

    public BoxBlockRenderer() {
        super((GeoModel)new BoxBlockModel());
    }

    public void actuallyRender(class_4587 poseStack, BoxBlockEntity animatable, BakedGeoModel model, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.actuallyRender(poseStack, (class_2586)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (animatable.hasFigure()) {
            if (!animatable.isFigureExtracted()) {
                poseStack.method_22903();
                poseStack.method_22904(animatable.getFigureOffsetX(), animatable.getFigureOffsetY(), animatable.getFigureOffsetZ());
                poseStack.method_22905((float)animatable.getFigureScale(), (float)animatable.getFigureScale(), (float)animatable.getFigureScale());
                this.figureRenderer.method_3569((class_2586)animatable, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
                poseStack.method_22909();
            }
            this.renderFigureFace(poseStack, animatable, model, bufferSource, partialTick, packedLight, packedOverlay);
        }
        this.renderLogo(poseStack, animatable, model, bufferSource, partialTick, packedLight, packedOverlay);
    }

    private void renderFigureFace(class_4587 poseStack, BoxBlockEntity animatable, BakedGeoModel model, class_4597 bufferSource, float partialTick, int packedLight, int packedOverlay) {
        FigureDefinition figure = animatable.getFigureDefinition();
        if (figure == null) {
            return;
        }
        class_2960 skinTexture = this.figureRenderer.getGeoModel().getTextureResource((GeoAnimatable)animatable);
        if (skinTexture == null) {
            return;
        }
        class_1921 skinRenderType = class_1921.method_23689((class_2960)skinTexture);
        class_4588 skinBuffer = bufferSource.getBuffer(skinRenderType);
        for (GeoBone bone : model.topLevelBones()) {
            if (bone.getName().equals("figure_face")) {
                poseStack.method_22903();
                this.renderRecursively(poseStack, animatable, bone, skinRenderType, bufferSource, skinBuffer, true, partialTick, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                poseStack.method_22909();
                continue;
            }
            if (!bone.getName().equals("figure_face_3d")) continue;
            poseStack.method_22903();
            this.renderRecursively(poseStack, animatable, bone, skinRenderType, bufferSource, skinBuffer, true, partialTick, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.method_22909();
        }
    }

    private void renderLogo(class_4587 poseStack, BoxBlockEntity animatable, BakedGeoModel model, class_4597 bufferSource, float partialTick, int packedLight, int packedOverlay) {
        if (animatable.isHideLogo()) {
            return;
        }
        String collectionId = animatable.getCollectionId();
        FigureCollection collection = CollectionRegistry.getCollection(collectionId).orElse(null);
        if (collection == null) {
            return;
        }
        FigureCollection.LogoConfig collectionLogoConfig = collection.getLogoConfig();
        if (collectionLogoConfig == null) {
            return;
        }
        float logoPositionX = animatable.getLogoPositionX() != null ? animatable.getLogoPositionX().floatValue() : collectionLogoConfig.getPositionX();
        float logoPositionY = animatable.getLogoPositionY() != null ? animatable.getLogoPositionY().floatValue() : collectionLogoConfig.getPositionY();
        float logoPositionZ = animatable.getLogoPositionZ() != null ? animatable.getLogoPositionZ().floatValue() : collectionLogoConfig.getPositionZ();
        float logoScaleX = animatable.getLogoScaleX() != null ? animatable.getLogoScaleX().floatValue() : collectionLogoConfig.getScaleX();
        float logoScaleY = animatable.getLogoScaleY() != null ? animatable.getLogoScaleY().floatValue() : collectionLogoConfig.getScaleY();
        float logoScaleZ = animatable.getLogoScaleZ() != null ? animatable.getLogoScaleZ().floatValue() : collectionLogoConfig.getScaleZ();
        class_1921 logoRenderType = class_1921.method_23578((class_2960)collectionLogoConfig.getTexture());
        class_4588 logoBuffer = bufferSource.getBuffer(logoRenderType);
        for (GeoBone bone : model.topLevelBones()) {
            if (!bone.getName().equals("logo")) continue;
            poseStack.method_22903();
            poseStack.method_46416(logoPositionX, logoPositionY, logoPositionZ);
            poseStack.method_22905(logoScaleX, logoScaleY, logoScaleZ);
            this.renderRecursively(poseStack, animatable, bone, logoRenderType, bufferSource, logoBuffer, true, partialTick, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.method_22909();
            break;
        }
    }

    public void renderRecursively(class_4587 poseStack, BoxBlockEntity animatable, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        String boneName = bone.getName();
        if ((boneName.equals("figure_face") || boneName.equals("figure_face_3d") || boneName.equals("logo")) && !isReRender) {
            return;
        }
        super.renderRecursively(poseStack, (class_2586)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

