/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.network;

import com.theplumteam.blockentity.ClawMachineBlockEntity;
import com.theplumteam.network.ModNetworking;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClawMachineCollectionPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClawMachineCollectionPacket.class);
    private final class_2338 pos;
    private final String collectionId;

    public ClawMachineCollectionPacket(class_2338 pos, String collectionId) {
        this.pos = pos;
        this.collectionId = collectionId;
    }

    public class_2540 encode() {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.method_10807(this.pos);
        buffer.method_10814(this.collectionId);
        return buffer;
    }

    public static ClawMachineCollectionPacket decode(class_2540 buffer) {
        class_2338 pos = buffer.method_10811();
        String collectionId = buffer.method_19772();
        return new ClawMachineCollectionPacket(pos, collectionId);
    }

    public static void handleServer(class_2540 buf, NetworkManager.PacketContext context) {
        ClawMachineCollectionPacket packet = ClawMachineCollectionPacket.decode(buf);
        LOGGER.info("Received ClawMachineCollectionPacket on server - Position: {}, Collection ID: {}", (Object)packet.pos, (Object)packet.collectionId);
        context.queue(() -> {
            class_1657 patt0$temp = context.getPlayer();
            if (patt0$temp instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                class_2586 blockEntity = player.method_37908().method_8321(packet.pos);
                if (blockEntity instanceof ClawMachineBlockEntity) {
                    ClawMachineBlockEntity clawMachineBlockEntity = (ClawMachineBlockEntity)blockEntity;
                    LOGGER.info("Setting collection ID on ClawMachineBlockEntity");
                    clawMachineBlockEntity.setCollectionId(packet.collectionId);
                    player.method_37908().method_8413(packet.pos, blockEntity.method_11010(), blockEntity.method_11010(), 3);
                    LOGGER.info("Collection ID updated successfully");
                } else {
                    LOGGER.warn("BlockEntity at {} is not a ClawMachineBlockEntity", (Object)packet.pos);
                }
            }
        });
    }

    public void sendToServer() {
        NetworkManager.sendToServer((class_2960)ModNetworking.CLAW_MACHINE_COLLECTION, (class_2540)this.encode());
    }
}

