/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.network;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.theplumteam.block.PopBlockColor;
import com.theplumteam.data.IPlayerDiscovery;
import com.theplumteam.data.PlayerDataManager;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureDefinition;
import com.theplumteam.figure.FigureType;
import com.theplumteam.network.SyncTokenDataPacket;
import com.theplumteam.network.TokenType;
import com.theplumteam.network.UnlockFigurePacket;
import com.theplumteam.registry.ModItems;
import com.theplumteam.server.ServerTickHandler;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropBoxPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropBoxPacket.class);
    public static final class_2960 ID = new class_2960("blockpops", "drop_box");
    private final class_2338 pos;
    private final String collectionId;
    private final TokenType tokenType;

    public DropBoxPacket(class_2338 pos, String collectionId, TokenType tokenType) {
        this.pos = pos;
        this.collectionId = collectionId;
        this.tokenType = tokenType;
    }

    public class_2540 encode() {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.method_10807(this.pos);
        buffer.method_10814(this.collectionId);
        buffer.method_10817((Enum)this.tokenType);
        return buffer;
    }

    public static DropBoxPacket decode(class_2540 buffer) {
        class_2338 pos = buffer.method_10811();
        String collectionId = buffer.method_19772();
        TokenType tokenType = (TokenType)buffer.method_10818(TokenType.class);
        return new DropBoxPacket(pos, collectionId, tokenType);
    }

    public static void handleServer(class_2540 buf, NetworkManager.PacketContext context) {
        DropBoxPacket packet = DropBoxPacket.decode(buf);
        LOGGER.info("Received drop box packet on server - Position: {}, Collection ID: {}, Token Type: {}", new Object[]{packet.pos, packet.collectionId, packet.tokenType});
        context.queue(() -> {
            class_1657 patt0$temp = context.getPlayer();
            if (patt0$temp instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                LOGGER.info("Player: {} - Processing {} token request", (Object)player.method_5477().getString(), (Object)packet.tokenType);
                if (player.method_31548().method_7376() == -1) {
                    player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7cInventory is full! Cannot receive figure box."));
                    LOGGER.info("Player {} inventory is full, token not consumed", (Object)player.method_5477().getString());
                    return;
                }
                IPlayerDiscovery discovery = PlayerDataManager.getDiscovery((class_1657)player);
                if (!DropBoxPacket.verifyAndConsumeToken(player, discovery, packet.tokenType)) {
                    LOGGER.warn("Player {} tried to use unavailable {} token", (Object)player.method_5477().getString(), (Object)packet.tokenType);
                    DropBoxPacket.syncTokenDataToClient(player, discovery);
                    return;
                }
                PlayerDataManager.markDirty((class_1657)player, discovery);
                DropBoxPacket.processBoxDrop(player, packet, discovery);
            }
        });
    }

    @Nullable
    private static GameProfile getFreshGameProfile(class_3222 player, FigureDefinition figure) {
        if (figure.getPlayerUUID() == null) {
            return null;
        }
        try {
            GameProfile freshProfile = new GameProfile(figure.getPlayerUUID(), figure.getName());
            return player.method_5682().method_3844().fillProfileProperties(freshProfile, true);
        }
        catch (Exception e) {
            LOGGER.error("Failed to fetch fresh GameProfile for {}: {}", (Object)figure.getName(), (Object)e.getMessage());
            return null;
        }
    }

    @Nullable
    private static String getQuickSkinIdFromServer(UUID playerId) {
        try {
            Class<?> repoClass = Class.forName("com.quickskin.mod.server.data.ServerPlayerAppearanceRepository");
            Method getInstanceMethod = repoClass.getMethod("getInstance", new Class[0]);
            Object repoInstance = getInstanceMethod.invoke(null, new Object[0]);
            Method getAppearanceMethod = repoClass.getMethod("getAppearance", UUID.class);
            Object appearance = getAppearanceMethod.invoke(repoInstance, playerId);
            if (appearance != null) {
                Class<?> appearanceClass = appearance.getClass();
                Method getSkinIdMethod = appearanceClass.getMethod("getSkinId", new Class[0]);
                return (String)getSkinIdMethod.invoke(appearance, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static void processBoxDrop(class_3222 player, DropBoxPacket packet, IPlayerDiscovery discovery) {
        CollectionRegistry.getCollection(packet.collectionId).ifPresent(collection -> {
            List<FigureDefinition> figures = collection.getFigures();
            if (!figures.isEmpty()) {
                FigureDefinition selectedFigure = DropBoxPacket.selectFigure(figures, packet.tokenType, discovery, packet.collectionId);
                class_1799 boxItem = null;
                if (packet.collectionId.equals("world_players")) {
                    PopBlockColor color = selectedFigure.getFavoriteColor();
                    if (color == null) {
                        color = PopBlockColor.ORIGINAL;
                    }
                    boxItem = new class_1799((class_1935)ModItems.DEFAULT_BOX_BLOCK_ITEMS.get((Object)color).get());
                } else {
                    boxItem = ModItems.BOX_BLOCK_ITEMS.containsKey(packet.collectionId) ? new class_1799((class_1935)ModItems.BOX_BLOCK_ITEMS.get(packet.collectionId).get()) : new class_1799((class_1935)ModItems.DEFAULT_BOX_BLOCK_ITEMS.get((Object)PopBlockColor.ORIGINAL).get());
                }
                if (boxItem != null) {
                    String oldSnapshot;
                    String uniqueFigureId = packet.collectionId + ":" + selectedFigure.getId();
                    String skinSnapshot = null;
                    String quickSkinSnapshot = null;
                    if (selectedFigure.getType() == FigureType.PLAYER) {
                        String qsId;
                        GameProfile freshProfile = DropBoxPacket.getFreshGameProfile(player, selectedFigure);
                        if (freshProfile != null && !freshProfile.getProperties().get((Object)"textures").isEmpty()) {
                            skinSnapshot = ((Property)freshProfile.getProperties().get((Object)"textures").iterator().next()).getValue();
                            discovery.saveFigureSkin(uniqueFigureId, skinSnapshot);
                            LOGGER.info("Saved/updated fresh skin snapshot for {}.", (Object)uniqueFigureId);
                        }
                        if (selectedFigure.getPlayerUUID() != null && (qsId = DropBoxPacket.getQuickSkinIdFromServer(selectedFigure.getPlayerUUID())) != null && !qsId.isEmpty()) {
                            quickSkinSnapshot = qsId;
                            discovery.saveFigureQuickSkin(uniqueFigureId, quickSkinSnapshot);
                            LOGGER.info("Captured & Saved Quick Skin ID for figure {}: {}", (Object)uniqueFigureId, (Object)qsId);
                        }
                    }
                    if (!discovery.isDiscovered(uniqueFigureId)) {
                        discovery.discover(uniqueFigureId);
                        UnlockFigurePacket.sendToPlayer(player, uniqueFigureId, selectedFigure.getName(), skinSnapshot, quickSkinSnapshot);
                        LOGGER.info("Player {} discovered new figure: {} ({})", new Object[]{player.method_5477().getString(), selectedFigure.getName(), uniqueFigureId});
                        player.method_17356(class_3417.field_14709, class_3419.field_15248, 1.0f, 1.0f);
                    } else {
                        player.method_17356(class_3417.field_14627, class_3419.field_15248, 1.0f, 1.0f);
                    }
                    class_2487 blockEntityTag = new class_2487();
                    blockEntityTag.method_10582("FigureId", selectedFigure.getId());
                    blockEntityTag.method_10582("CollectionId", packet.collectionId);
                    if (packet.collectionId.equals("world_players")) {
                        PopBlockColor color = selectedFigure.getFavoriteColor();
                        if (color == null) {
                            color = PopBlockColor.ORIGINAL;
                        }
                        blockEntityTag.method_10582("Color", color.name());
                    }
                    if (skinSnapshot != null && !skinSnapshot.isEmpty()) {
                        blockEntityTag.method_10582("SkinSnapshot", skinSnapshot);
                    } else if (selectedFigure.getType() == FigureType.PLAYER && (oldSnapshot = discovery.getFigureSkin(uniqueFigureId)) != null && !oldSnapshot.isEmpty()) {
                        blockEntityTag.method_10582("SkinSnapshot", oldSnapshot);
                    }
                    if (quickSkinSnapshot != null) {
                        blockEntityTag.method_10582("QuickSkinId", quickSkinSnapshot);
                    }
                    boxItem.method_7948().method_10566("BlockEntityTag", (class_2520)blockEntityTag);
                    player.method_31548().method_7394(boxItem);
                    PlayerDataManager.markDirty((class_1657)player, discovery);
                }
            }
        });
    }

    private static boolean verifyAndConsumeToken(class_3222 player, IPlayerDiscovery discovery, TokenType tokenType) {
        if (tokenType == TokenType.REGULAR) {
            if (discovery.getRegularTokens() > 0) {
                discovery.setRegularTokens(discovery.getRegularTokens() - 1);
                LOGGER.info("Player {} used a regular token. Remaining: {}", (Object)player.method_5477().getString(), (Object)discovery.getRegularTokens());
                DropBoxPacket.syncTokenDataToClient(player, discovery);
                return true;
            }
        } else if (tokenType == TokenType.GUARANTEED && !discovery.hasUsedTodaySpecialToken()) {
            discovery.setUsedTodaySpecialToken(true);
            LOGGER.info("Player {} used their guaranteed token", (Object)player.method_5477().getString());
            DropBoxPacket.syncTokenDataToClient(player, discovery);
            return true;
        }
        return false;
    }

    private static void syncTokenDataToClient(class_3222 player, IPlayerDiscovery discovery) {
        long gameTime = player.method_51469().method_8510();
        long nextRegularTime = discovery.getNextRegularTokenTime();
        long ticksUntilNext = Math.max(0L, nextRegularTime - gameTime);
        long millisUntilReset = ServerTickHandler.calculateMillisUntilNextReset();
        SyncTokenDataPacket.sendToPlayer(player, discovery.getRegularTokens(), ticksUntilNext, !discovery.hasUsedTodaySpecialToken(), millisUntilReset);
    }

    private static FigureDefinition selectFigure(List<FigureDefinition> figures, TokenType tokenType, IPlayerDiscovery discovery, String collectionId) {
        Random random = new Random();
        if (tokenType == TokenType.GUARANTEED) {
            Set<String> discoveredSet = discovery.getDiscoveredSet();
            ArrayList<FigureDefinition> undiscoveredFigures = new ArrayList<FigureDefinition>();
            for (FigureDefinition figure : figures) {
                String figureId = collectionId + ":" + figure.getId();
                if (discoveredSet.contains(figureId)) continue;
                undiscoveredFigures.add(figure);
            }
            if (!undiscoveredFigures.isEmpty()) {
                FigureDefinition selected = (FigureDefinition)undiscoveredFigures.get(random.nextInt(undiscoveredFigures.size()));
                LOGGER.info("Guaranteed token logic: Selected undiscovered figure '{}'", (Object)selected.getId());
                return selected;
            }
            LOGGER.info("Guaranteed token logic: Collection complete, giving random duplicate");
            return figures.get(random.nextInt(figures.size()));
        }
        return figures.get(random.nextInt(figures.size()));
    }

    public void sendToServer() {
        NetworkManager.sendToServer((class_2960)ID, (class_2540)this.encode());
    }
}

