/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.network;

import com.theplumteam.client.discovery.ClientDiscoveryManager;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnlockFigurePacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnlockFigurePacket.class);
    public static final class_2960 ID = new class_2960("blockpops", "unlock_figure");
    private final String figureId;
    private final String figureName;
    @Nullable
    private final String skinSnapshot;
    @Nullable
    private final String quickSkinId;

    public UnlockFigurePacket(String figureId, String figureName) {
        this(figureId, figureName, null, null);
    }

    public UnlockFigurePacket(String figureId, String figureName, @Nullable String skinSnapshot) {
        this(figureId, figureName, skinSnapshot, null);
    }

    public UnlockFigurePacket(String figureId, String figureName, @Nullable String skinSnapshot, @Nullable String quickSkinId) {
        this.figureId = figureId;
        this.figureName = figureName;
        this.skinSnapshot = skinSnapshot;
        this.quickSkinId = quickSkinId;
    }

    public class_2540 encode() {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.method_10814(this.figureId);
        buffer.method_10814(this.figureName);
        buffer.writeBoolean(this.skinSnapshot != null);
        if (this.skinSnapshot != null) {
            buffer.method_10814(this.skinSnapshot);
        }
        buffer.writeBoolean(this.quickSkinId != null);
        if (this.quickSkinId != null) {
            buffer.method_10814(this.quickSkinId);
        }
        return buffer;
    }

    public static UnlockFigurePacket decode(class_2540 buffer) {
        String figureId = buffer.method_19772();
        String figureName = buffer.method_19772();
        String skinSnapshot = null;
        if (buffer.readBoolean()) {
            skinSnapshot = buffer.method_19772();
        }
        String quickSkinId = null;
        if (buffer.readBoolean()) {
            quickSkinId = buffer.method_19772();
        }
        return new UnlockFigurePacket(figureId, figureName, skinSnapshot, quickSkinId);
    }

    public static void handleClient(class_2540 buf, NetworkManager.PacketContext context) {
        UnlockFigurePacket packet = UnlockFigurePacket.decode(buf);
        context.queue(() -> {
            LOGGER.info("Unlocked new figure: {} ({})", (Object)packet.figureName, (Object)packet.figureId);
            ClientDiscoveryManager.unlock(packet.figureId);
            if (packet.skinSnapshot != null) {
                ClientDiscoveryManager.saveFigureSkin(packet.figureId, packet.skinSnapshot);
                LOGGER.info("Saved skin snapshot for unlocked figure: {}", (Object)packet.figureId);
            }
            if (packet.quickSkinId != null) {
                ClientDiscoveryManager.saveFigureQuickSkin(packet.figureId, packet.quickSkinId);
                LOGGER.info("Saved Quick Skin ID for unlocked figure: {}", (Object)packet.figureId);
            }
        });
    }

    public static void sendToPlayer(class_3222 player, String figureId, String figureName, @Nullable String skinSnapshot) {
        UnlockFigurePacket.sendToPlayer(player, figureId, figureName, skinSnapshot, null);
    }

    public static void sendToPlayer(class_3222 player, String figureId, String figureName, @Nullable String skinSnapshot, @Nullable String quickSkinId) {
        UnlockFigurePacket packet = new UnlockFigurePacket(figureId, figureName, skinSnapshot, quickSkinId);
        NetworkManager.sendToPlayer((class_3222)player, (class_2960)ID, (class_2540)packet.encode());
    }

    public String getFigureId() {
        return this.figureId;
    }

    public String getFigureName() {
        return this.figureName;
    }

    @Nullable
    public String getSkinSnapshot() {
        return this.skinSnapshot;
    }

    @Nullable
    public String getQuickSkinId() {
        return this.quickSkinId;
    }
}

