/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.platform.fabric;

import com.theplumteam.block.PopBlockColor;
import com.theplumteam.blockentity.BoxBlockEntity;
import com.theplumteam.blockentity.ClawMachineBlockEntity;
import com.theplumteam.item.BoxBlockItem;
import com.theplumteam.item.GeoBlockItem;
import com.theplumteam.platform.fabric.ClientPlatformHelperImpl;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2338;

public class PlatformHelperImpl {
    public static String getPlatformName() {
        return "Fabric";
    }

    public static Path getGameDirectory() {
        return FabricLoader.getInstance().getGameDir();
    }

    public static Path getConfigDirectory() {
        return FabricLoader.getInstance().getConfigDir();
    }

    public static boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    public static String getModVersion() {
        return FabricLoader.getInstance().getModContainer("blockpops").map(container -> container.getMetadata().getVersion().getFriendlyString()).orElse("UNKNOWN");
    }

    public static boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static void openBoxFigureScreen(class_2338 pos, BoxBlockEntity boxBlockEntity) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientPlatformHelperImpl.openBoxFigureScreen(pos, boxBlockEntity);
        }
    }

    public static void openClawMachineScreen(class_2338 pos, ClawMachineBlockEntity clawMachineBlockEntity) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientPlatformHelperImpl.openClawMachineScreen(pos, clawMachineBlockEntity);
        }
    }

    public static class_1792 createGeoBlockItem(class_2248 block, class_1792.class_1793 properties) {
        return new GeoBlockItem(block, properties);
    }

    public static class_1792 createBoxBlockItem(class_2248 block, class_1792.class_1793 properties, String collectionId) {
        return new BoxBlockItem(block, properties, collectionId);
    }

    public static class_1792 createBoxBlockItemForColor(class_2248 block, class_1792.class_1793 properties, PopBlockColor color) {
        return new BoxBlockItem(block, properties, color);
    }
}

