/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.blocks;

import com.mojang.serialization.MapCodec;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.ParticleRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class DangoBlossomBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final MapCodec<DangoBlossomBlock> CODEC = DangoBlossomBlock.simpleCodec(DangoBlossomBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0), (VoxelShape[])new VoxelShape[0]).optimize();

    public MapCodec<DangoBlossomBlock> codec() {
        return CODEC;
    }

    public DangoBlossomBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{WATERLOGGED});
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor worldAccessor, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldAccessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldAccessor));
        }
        return super.updateShape(state, direction, neighborState, worldAccessor, pos, neighborPos);
    }

    protected boolean canSurvive(BlockState state, LevelReader worldReader, BlockPos pos) {
        return Block.canSupportCenter((LevelReader)worldReader, (BlockPos)pos.below(), (Direction)Direction.UP) || worldReader.getBlockState(pos.below()).getBlock() instanceof CactusBlock || worldReader.getBlockState(pos.below()).getBlock() instanceof LeavesBlock;
    }

    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        BlockPos pos = placeContext.getClickedPos();
        FluidState fluidState = placeContext.getLevel().getFluidState(pos);
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return true;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 60;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 100;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        if (((Boolean)ConfigRegistry.DANGO_BLOSSOM_PARTICLES.get()).booleanValue()) {
            world.addParticle((ParticleOptions)ParticleRegistry.GOLD_POLLEN.get(), (double)x + random.nextDouble(), (double)y + 0.25, (double)z + random.nextDouble(), 0.0, 0.0, 0.0);
            for (int amt = 0; amt < 14; ++amt) {
                posMutable.set(x + Mth.nextInt((RandomSource)random, (int)-10, (int)10), y + random.nextInt(10), z + Mth.nextInt((RandomSource)random, (int)-10, (int)10));
                BlockState stateMutable = world.getBlockState((BlockPos)posMutable);
                if (stateMutable.isCollisionShapeFullBlock((BlockGetter)world, (BlockPos)posMutable)) continue;
                world.addParticle((ParticleOptions)ParticleRegistry.GOLD_POLLEN.get(), (double)posMutable.getX() + random.nextDouble(), (double)posMutable.getY() + random.nextDouble(), (double)posMutable.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
    }
}

