/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.blocks;

import com.wenxin2.marioverse.blocks.CoinBlock;
import com.wenxin2.marioverse.blocks.entities.StarCoinBlockEntity;
import com.wenxin2.marioverse.blocks.states.QuadrantBlockStates;
import com.wenxin2.marioverse.entities.KoopaShellEntity;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.ParticleRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StarCoinBlock
extends CoinBlock
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final EnumProperty<QuadrantBlockStates> QUADRANT = EnumProperty.create((String)"quadrant", QuadrantBlockStates.class);
    protected static final VoxelShape LOWER_NORTH_WEST = Block.box((double)5.0, (double)3.5, (double)5.0, (double)27.0, (double)25.5, (double)27.0).optimize();
    protected static final VoxelShape LOWER_NORTH_EAST = Block.box((double)-11.0, (double)3.5, (double)5.0, (double)11.0, (double)25.5, (double)27.0).optimize();
    protected static final VoxelShape LOWER_SOUTH_WEST = Block.box((double)5.0, (double)3.5, (double)-11.0, (double)27.0, (double)25.5, (double)11.0).optimize();
    protected static final VoxelShape LOWER_SOUTH_EAST = Block.box((double)-11.0, (double)3.5, (double)-11.0, (double)11.0, (double)25.5, (double)11.0).optimize();
    protected static final VoxelShape UPPER_NORTH_WEST = Block.box((double)5.0, (double)-12.0, (double)5.0, (double)27.0, (double)10.0, (double)27.0).optimize();
    protected static final VoxelShape UPPER_NORTH_EAST = Block.box((double)-11.0, (double)-12.0, (double)5.0, (double)11.0, (double)10.0, (double)27.0).optimize();
    protected static final VoxelShape UPPER_SOUTH_WEST = Block.box((double)5.0, (double)-12.0, (double)-11.0, (double)27.0, (double)10.0, (double)11.0).optimize();
    protected static final VoxelShape UPPER_SOUTH_EAST = Block.box((double)-11.0, (double)-12.0, (double)-11.0, (double)11.0, (double)10.0, (double)11.0).optimize();

    public StarCoinBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue(QUADRANT, (Comparable)((Object)QuadrantBlockStates.NORTH_WEST))).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{FACING, HALF, QUADRANT, WATERLOGGED});
    }

    @Override
    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        VoxelShape baseShape;
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        QuadrantBlockStates quadrant = (QuadrantBlockStates)((Object)state.getValue(QUADRANT));
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (half == DoubleBlockHalf.LOWER) {
            baseShape = switch (quadrant) {
                case QuadrantBlockStates.NORTH_EAST -> LOWER_NORTH_EAST;
                case QuadrantBlockStates.SOUTH_WEST -> LOWER_SOUTH_WEST;
                case QuadrantBlockStates.SOUTH_EAST -> LOWER_SOUTH_EAST;
                default -> LOWER_NORTH_WEST;
            };
        } else {
            switch (quadrant) {
                case NORTH_EAST: {
                    VoxelShape voxelShape = UPPER_NORTH_EAST;
                    break;
                }
                case SOUTH_WEST: {
                    VoxelShape voxelShape = UPPER_SOUTH_WEST;
                    break;
                }
                case SOUTH_EAST: {
                    VoxelShape voxelShape = UPPER_SOUTH_EAST;
                    break;
                }
                default: {
                    VoxelShape voxelShape = baseShape = UPPER_NORTH_WEST;
                }
            }
        }
        if (facing == Direction.NORTH) {
            return baseShape;
        }
        VoxelShape rotated = Shapes.empty();
        for (AABB box : baseShape.toAabbs()) {
            AABB rotatedBox = switch (facing) {
                case Direction.EAST -> new AABB(1.0 - box.maxZ, box.minY, box.minX, 1.0 - box.minZ, box.maxY, box.maxX);
                case Direction.SOUTH -> new AABB(1.0 - box.maxX, box.minY, 1.0 - box.maxZ, 1.0 - box.minX, box.maxY, 1.0 - box.minZ);
                case Direction.WEST -> new AABB(box.minZ, box.minY, 1.0 - box.maxX, box.maxZ, box.maxY, 1.0 - box.minX);
                default -> box;
            };
            rotated = Shapes.or((VoxelShape)rotated, (VoxelShape)Shapes.create((AABB)rotatedBox));
        }
        return rotated;
    }

    @Override
    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new StarCoinBlockEntity(pos, state);
    }

    @Override
    protected void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        Projectile projectile;
        KoopaShellEntity koopaShell;
        ItemStack coinItem = new ItemStack((ItemLike)this.asItem());
        if (entity instanceof KoopaShellEntity && (koopaShell = (KoopaShellEntity)entity).getOwner() != null && koopaShell.getOwner().getType().is(TagRegistry.CAN_COLLECT_COINS)) {
            StarCoinBlock.collectCoin(this, world, state, pos, koopaShell.getOwner(), coinItem);
        } else if (entity instanceof Projectile && (projectile = (Projectile)entity).getOwner() != null) {
            StarCoinBlock.collectCoin(this, world, state, pos, projectile.getOwner(), coinItem);
        } else if (entity.getType().is(TagRegistry.CAN_COLLECT_COINS) && ((Boolean)ConfigRegistry.STAR_COINS_COLLECTED_ON_COLLISION.get()).booleanValue()) {
            Player player;
            if (entity instanceof Player && (player = (Player)entity).isCreative() && !((Boolean)ConfigRegistry.STAR_COINS_COLLECTED_IN_CREATIVE.get()).booleanValue()) {
                return;
            }
            StarCoinBlock.collectCoin(this, world, state, pos, entity, coinItem);
        }
    }

    public static void collectCoin(StarCoinBlock starCoinBlock, Level world, BlockState state, BlockPos pos, Entity entity, ItemStack coinItem) {
        LivingEntity livingEntity;
        LivingEntity livingEntity2;
        QuadrantBlockStates quadrant = (QuadrantBlockStates)((Object)state.getValue(QUADRANT));
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean itemAdded = false;
        starCoinBlock.removeCoinParts(world, pos, half, quadrant, facing, true, false, false);
        world.playSound(null, pos, (SoundEvent)SoundRegistry.STAR_COIN_PICKUP.get(), SoundSource.BLOCKS);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            itemAdded = player.addItem(coinItem);
            if (!itemAdded) {
                player.drop(coinItem, false);
            }
            if (state.is(BlockTags.GUARDED_BY_PIGLINS)) {
                PiglinAi.angerNearbyPiglins((Player)player, (boolean)false);
            }
        } else if (entity instanceof LivingEntity && (livingEntity2 = (LivingEntity)entity).getMainHandItem().isEmpty()) {
            livingEntity2.setItemInHand(InteractionHand.MAIN_HAND, coinItem);
            livingEntity2.swing(InteractionHand.MAIN_HAND);
            itemAdded = true;
        } else if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).getOffhandItem().isEmpty()) {
            livingEntity.setItemInHand(InteractionHand.OFF_HAND, coinItem);
            livingEntity.swing(InteractionHand.OFF_HAND);
            itemAdded = true;
        } else if (entity instanceof InventoryCarrier) {
            InventoryCarrier carrier = (InventoryCarrier)entity;
            SimpleContainer inventory = carrier.getInventory();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity3 = (LivingEntity)entity;
                livingEntity3.swing(InteractionHand.MAIN_HAND);
            }
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                if (!inventory.getItem(i).isEmpty()) continue;
                inventory.setItem(i, coinItem);
                itemAdded = true;
                break;
            }
        } else if (entity instanceof Container) {
            Container container = (Container)entity;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity4 = (LivingEntity)entity;
                livingEntity4.swing(InteractionHand.MAIN_HAND);
            }
            for (int i = 0; i < container.getContainerSize(); ++i) {
                if (!container.getItem(i).isEmpty()) continue;
                container.setItem(i, coinItem);
                itemAdded = true;
                break;
            }
        }
        if (!itemAdded) {
            entity.spawnAtLocation(coinItem);
        }
    }

    public boolean canSurvive(BlockState state, @NotNull LevelReader world, BlockPos pos) {
        QuadrantBlockStates quadrant = (QuadrantBlockStates)((Object)state.getValue(QUADRANT));
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos partPos = this.getPartPos(pos.above(), quadrant, half, facing);
        return this.canCoinPartsPlace(world, partPos, facing) || this.areCoinPartsValid(world, partPos, facing);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level world = context.getLevel();
        FluidState fluidState = world.getFluidState(pos);
        boolean waterlogged = fluidState.getType() == Fluids.WATER;
        Direction facing = context.getHorizontalDirection().getOpposite();
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue(QUADRANT, (Comparable)((Object)QuadrantBlockStates.NORTH_WEST))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor worldAccessor, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldAccessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldAccessor));
        }
        return super.updateShape(state, direction, neighborState, worldAccessor, pos, neighborPos);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return this.rotate(state, mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            Direction facing = entity.getDirection().getOpposite();
            BlockState baseState = (BlockState)state.setValue((Property)FACING, (Comparable)facing);
            world.setBlock(pos, (BlockState)((BlockState)((BlockState)baseState.setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue(QUADRANT, (Comparable)((Object)QuadrantBlockStates.NORTH_WEST))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos).getType() == Fluids.WATER)), 3);
            world.setBlock(pos.relative(facing.getClockWise()), (BlockState)((BlockState)((BlockState)baseState.setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue(QUADRANT, (Comparable)((Object)QuadrantBlockStates.NORTH_EAST))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos.relative(facing.getClockWise())).getType() == Fluids.WATER)), 3);
            world.setBlock(pos.relative(facing.getOpposite()), (BlockState)((BlockState)((BlockState)baseState.setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue(QUADRANT, (Comparable)((Object)QuadrantBlockStates.SOUTH_WEST))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos.relative(facing.getOpposite())).getType() == Fluids.WATER)), 3);
            world.setBlock(pos.relative(facing.getOpposite()).relative(facing.getClockWise()), (BlockState)((BlockState)((BlockState)baseState.setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue(QUADRANT, (Comparable)((Object)QuadrantBlockStates.SOUTH_EAST))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos.relative(facing.getOpposite()).relative(facing.getClockWise())).getType() == Fluids.WATER)), 3);
            world.setBlock(pos.above(), (BlockState)((BlockState)((BlockState)baseState.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue(QUADRANT, (Comparable)((Object)QuadrantBlockStates.NORTH_WEST))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos.above()).getType() == Fluids.WATER)), 3);
            world.setBlock(pos.relative(facing.getClockWise()).above(), (BlockState)((BlockState)((BlockState)baseState.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue(QUADRANT, (Comparable)((Object)QuadrantBlockStates.NORTH_EAST))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos.relative(facing.getClockWise()).above()).getType() == Fluids.WATER)), 3);
            world.setBlock(pos.relative(facing.getOpposite()).above(), (BlockState)((BlockState)((BlockState)baseState.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue(QUADRANT, (Comparable)((Object)QuadrantBlockStates.SOUTH_WEST))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos.relative(facing.getOpposite()).above()).getType() == Fluids.WATER)), 3);
            world.setBlock(pos.relative(facing.getOpposite()).relative(facing.getClockWise()).above(), (BlockState)((BlockState)((BlockState)baseState.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue(QUADRANT, (Comparable)((Object)QuadrantBlockStates.SOUTH_EAST))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos.relative(facing.getOpposite()).relative(facing.getClockWise()).above()).getType() == Fluids.WATER)), 3);
        }
    }

    public void destroy(LevelAccessor worldAccessor, BlockPos pos, BlockState state) {
        QuadrantBlockStates quadrant = (QuadrantBlockStates)((Object)state.getValue(QUADRANT));
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (!worldAccessor.isClientSide() && worldAccessor instanceof Level) {
            Level world = (Level)worldAccessor;
            this.removeCoinParts(world, pos, half, quadrant, facing, true, true, true);
        }
        super.destroy(worldAccessor, pos, state);
    }

    @NotNull
    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        QuadrantBlockStates quadrant = (QuadrantBlockStates)((Object)state.getValue(QUADRANT));
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (!world.isClientSide) {
            if (player.isCreative() || !player.hasCorrectToolForDrops(state, world, pos)) {
                this.removeCoinParts(world, pos, half, quadrant, facing, false, false, true);
            } else {
                this.removeCoinParts(world, pos, half, quadrant, facing, true, true, true);
            }
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public BlockPos getPartPos(BlockPos pos, QuadrantBlockStates quadrant, DoubleBlockHalf half, Direction direction) {
        BlockPos base = switch (quadrant) {
            default -> throw new MatchException(null, null);
            case QuadrantBlockStates.NORTH_WEST -> pos;
            case QuadrantBlockStates.NORTH_EAST -> pos.relative(direction.getClockWise());
            case QuadrantBlockStates.SOUTH_WEST -> pos.relative(direction.getOpposite());
            case QuadrantBlockStates.SOUTH_EAST -> pos.relative(direction.getClockWise()).relative(direction.getOpposite());
        };
        return half == DoubleBlockHalf.UPPER ? base.below() : base;
    }

    private boolean areCoinPartsValid(LevelReader world, BlockPos pos, Direction facing) {
        return world.getBlockState(this.getPartPos(pos, QuadrantBlockStates.NORTH_WEST, DoubleBlockHalf.LOWER, facing)).is((Block)this) && world.getBlockState(this.getPartPos(pos, QuadrantBlockStates.NORTH_EAST, DoubleBlockHalf.LOWER, facing)).is((Block)this) && world.getBlockState(this.getPartPos(pos, QuadrantBlockStates.SOUTH_WEST, DoubleBlockHalf.LOWER, facing)).is((Block)this) && world.getBlockState(this.getPartPos(pos, QuadrantBlockStates.SOUTH_EAST, DoubleBlockHalf.LOWER, facing)).is((Block)this) && world.getBlockState(this.getPartPos(pos, QuadrantBlockStates.NORTH_WEST, DoubleBlockHalf.UPPER, facing)).is((Block)this) && world.getBlockState(this.getPartPos(pos, QuadrantBlockStates.NORTH_EAST, DoubleBlockHalf.UPPER, facing)).is((Block)this) && world.getBlockState(this.getPartPos(pos, QuadrantBlockStates.SOUTH_WEST, DoubleBlockHalf.UPPER, facing)).is((Block)this) && world.getBlockState(this.getPartPos(pos, QuadrantBlockStates.SOUTH_EAST, DoubleBlockHalf.UPPER, facing)).is((Block)this);
    }

    private boolean canCoinPartsPlace(LevelReader world, BlockPos pos, Direction facing) {
        return world.getBlockState(this.getPartPos(pos, QuadrantBlockStates.NORTH_WEST, DoubleBlockHalf.LOWER, facing)).canBeReplaced() && world.getBlockState(this.getPartPos(pos, QuadrantBlockStates.NORTH_EAST, DoubleBlockHalf.LOWER, facing)).canBeReplaced() && world.getBlockState(this.getPartPos(pos, QuadrantBlockStates.SOUTH_WEST, DoubleBlockHalf.LOWER, facing)).canBeReplaced() && world.getBlockState(this.getPartPos(pos, QuadrantBlockStates.SOUTH_EAST, DoubleBlockHalf.LOWER, facing)).canBeReplaced() && world.getBlockState(this.getPartPos(pos, QuadrantBlockStates.NORTH_WEST, DoubleBlockHalf.UPPER, facing)).canBeReplaced() && world.getBlockState(this.getPartPos(pos, QuadrantBlockStates.NORTH_EAST, DoubleBlockHalf.UPPER, facing)).canBeReplaced() && world.getBlockState(this.getPartPos(pos, QuadrantBlockStates.SOUTH_WEST, DoubleBlockHalf.UPPER, facing)).canBeReplaced() && world.getBlockState(this.getPartPos(pos, QuadrantBlockStates.SOUTH_EAST, DoubleBlockHalf.UPPER, facing)).canBeReplaced();
    }

    public void removeCoinParts(Level world, BlockPos pos, DoubleBlockHalf half, QuadrantBlockStates quadrant, Direction facing, boolean spawnParticles, boolean dropResources, boolean destroyBlock) {
        BlockPos basePos = half == DoubleBlockHalf.UPPER ? pos.below() : pos;
        for (QuadrantBlockStates quadrants : QuadrantBlockStates.values()) {
            for (Direction directions : Direction.Plane.HORIZONTAL) {
                for (DoubleBlockHalf halves : DoubleBlockHalf.values()) {
                    if (quadrant != quadrants || facing != directions || half != halves) continue;
                    Direction right = directions.getClockWise();
                    Direction left = directions.getCounterClockWise();
                    Direction back = directions.getOpposite();
                    Direction axis1 = switch (quadrants) {
                        default -> throw new MatchException(null, null);
                        case QuadrantBlockStates.NORTH_EAST, QuadrantBlockStates.NORTH_WEST -> back;
                        case QuadrantBlockStates.SOUTH_WEST, QuadrantBlockStates.SOUTH_EAST -> directions;
                    };
                    Direction axis2 = switch (quadrants) {
                        default -> throw new MatchException(null, null);
                        case QuadrantBlockStates.SOUTH_WEST, QuadrantBlockStates.NORTH_WEST -> right;
                        case QuadrantBlockStates.NORTH_EAST, QuadrantBlockStates.SOUTH_EAST -> left;
                    };
                    for (int x = 0; x <= 1; ++x) {
                        for (int z = 0; z <= 1; ++z) {
                            BlockPos targetPos = basePos.relative(axis1, x).relative(axis2, z);
                            if (destroyBlock) {
                                world.destroyBlock(targetPos, dropResources);
                                world.destroyBlock(targetPos.above(), dropResources);
                            } else {
                                world.removeBlock(targetPos, false);
                                world.removeBlock(targetPos.above(), false);
                            }
                            if (world instanceof ServerLevel) {
                                ServerLevel serverWorld = (ServerLevel)world;
                                if (spawnParticles) {
                                    ServerParticleUtils.spawnParticlesOnBlockFaces((ParticleOptions)ParticleRegistry.COIN_GLINT.get(), serverWorld, targetPos, (IntProvider)UniformInt.of((int)1, (int)1));
                                    ServerParticleUtils.spawnParticlesOnBlockFaces((ParticleOptions)ParticleRegistry.COIN_GLINT.get(), serverWorld, targetPos.above(), (IntProvider)UniformInt.of((int)1, (int)1));
                                    continue;
                                }
                            }
                            world.levelEvent(2001, targetPos, Block.getId((BlockState)world.getBlockState(targetPos)));
                            world.levelEvent(2001, targetPos.above(), Block.getId((BlockState)world.getBlockState(targetPos.above())));
                        }
                    }
                }
            }
        }
    }
}

