/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wenxin2.marioverse.blocks.BaseEntityDirectionalBlock;
import com.wenxin2.marioverse.blocks.PipeBubblesBlock;
import com.wenxin2.marioverse.blocks.WaterSpoutBlock;
import com.wenxin2.marioverse.blocks.entities.BaseWarpBlockEntity;
import com.wenxin2.marioverse.blocks.entities.PipeText;
import com.wenxin2.marioverse.blocks.entities.WarpPipeBlockEntity;
import com.wenxin2.marioverse.integration.CompatRegistry;
import com.wenxin2.marioverse.inventory.WarpPipeMenu;
import com.wenxin2.marioverse.registries.BlockEntityRegistry;
import com.wenxin2.marioverse.registries.BlockRegistry;
import com.wenxin2.marioverse.registries.DataComponentRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.LavaFluid;
import net.minecraft.world.level.material.WaterFluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class WarpPipeBlock
extends BaseEntityDirectionalBlock {
    public static final MapCodec<WarpPipeBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DyeColor.CODEC.optionalFieldOf("color").forGetter(flagBlock -> Optional.ofNullable(flagBlock.color)), (App)WarpPipeBlock.propertiesCodec()).apply((Applicative)instance, (dyeColor, properties) -> new WarpPipeBlock(dyeColor.orElse(null), (BlockBehaviour.Properties)properties)));
    public static final BooleanProperty BUBBLES = BooleanProperty.create((String)"bubbles");
    public static final BooleanProperty CLOSED = BooleanProperty.create((String)"closed");
    public static final BooleanProperty ENTRANCE = BooleanProperty.create((String)"entrance");
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty WATER_SPOUT = BooleanProperty.create((String)"water_spout");
    @Nullable
    private final DyeColor color;

    public WarpPipeBlock(@Nullable DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)BUBBLES, (Comparable)Boolean.TRUE)).setValue((Property)CLOSED, (Comparable)Boolean.FALSE)).setValue((Property)ENTRANCE, (Comparable)Boolean.TRUE)).setValue((Property)POWERED, (Comparable)Boolean.FALSE)).setValue((Property)WATER_SPOUT, (Comparable)Boolean.FALSE));
        this.color = color;
    }

    public MapCodec<WarpPipeBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{BUBBLES, CLOSED, ENTRANCE, FACING, POWERED, WATER_SPOUT});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WarpPipeBlockEntity(pos, state);
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof WarpPipeBlockEntity) {
            WarpPipeBlockEntity warpPipeBE = (WarpPipeBlockEntity)blockEntity;
            if (((Boolean)state.getValue((Property)WATER_SPOUT)).booleanValue()) {
                return Math.min(warpPipeBE.getSpoutHeight(), 15);
            }
            if (((Boolean)state.getValue((Property)BUBBLES)).booleanValue()) {
                return Math.min(warpPipeBE.getBubblesDistance(), 15);
            }
        }
        return 0;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return WarpPipeBlock.createTickerHelper(type, (BlockEntityType)BlockEntityRegistry.WARP_PIPE_BLOCK_ENTITY.get(), world.isClientSide ? WarpPipeBlockEntity::clientTick : WarpPipeBlockEntity::serverTick);
    }

    @Override
    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag options) {
        super.appendHoverText(stack, context, list, options);
        Spawner.appendHoverText((ItemStack)stack, list, (String)"SpawnData");
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public static ItemStack getColoredItemStack(@Nullable DyeColor color) {
        return new ItemStack((ItemLike)BlockRegistry.WARP_PIPES.get(color));
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hitResult) {
        WarpPipeBlockEntity pipeBE;
        ItemStack heldItem = player.getItemInHand(player.getUsedItemHand());
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (((Boolean)state.getValue((Property)ENTRANCE)).booleanValue() && player.isCreative() && blockEntity instanceof WarpPipeBlockEntity && !(pipeBE = (WarpPipeBlockEntity)blockEntity).getTheItem().isEmpty() && heldItem.isEmpty()) {
            world.sendBlockUpdated(pos, state, state, 3);
            world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            world.playSound(null, pos, (SoundEvent)SoundRegistry.ITEM_SPAWNS.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            pipeBE.splitTheItem(1);
            pipeBE.markUpdated();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        WarpPipeBlockEntity pipeBE;
        ItemStack heldItem = player.getItemInHand(hand);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        Item item = stack.getItem();
        if (((Boolean)state.getValue((Property)ENTRANCE)).booleanValue() && player.getItemInHand(hand).is(TagRegistry.WRENCHES)) {
            if (blockEntity instanceof WarpPipeBlockEntity) {
                player.openMenu((MenuProvider)new SimpleMenuProvider((id, playerInventory, playerIn) -> new WarpPipeMenu(id, playerInventory, ContainerLevelAccess.create((Level)world, (BlockPos)pos), pos), ((WarpPipeBlockEntity)blockEntity).getDisplayName()));
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pos, stack);
                    player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (((Boolean)state.getValue((Property)ENTRANCE)).booleanValue() && player.isCreative() && !heldItem.is(TagRegistry.WARP_PIPE_CANNOT_SPAWN_ITEMS) && !(heldItem.getItem() instanceof SpawnEggItem) && blockEntity instanceof WarpPipeBlockEntity && !ItemStack.isSameItemSameComponents((ItemStack)heldItem, (ItemStack)(pipeBE = (WarpPipeBlockEntity)blockEntity).getTheItem()) && !pipeBE.isWaxed()) {
            if (!heldItem.isEmpty()) {
                pipeBE.setTheItem(player.getItemInHand(hand).copyWithCount(1));
            } else if (!pipeBE.getTheItem().isEmpty()) {
                pipeBE.splitTheItem(1);
            }
            pipeBE.markUpdated();
            world.sendBlockUpdated(pos, state, state, 3);
            world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            if (!heldItem.isEmpty()) {
                player.getItemInHand(hand).consume(1, (LivingEntity)player);
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (blockEntity instanceof BaseWarpBlockEntity) {
            ServerPlayer serverPlayer;
            BaseWarpBlockEntity warpBlockEntity = (BaseWarpBlockEntity)blockEntity;
            boolean isSuccesful = false;
            boolean isSuccesfulTool = false;
            if (blockEntity instanceof WarpPipeBlockEntity) {
                WarpPipeBlockEntity pipeBE2 = (WarpPipeBlockEntity)blockEntity;
                if (!warpBlockEntity.isWaxed()) {
                    DyeItem dyeItem;
                    if (item == Items.INK_SAC) {
                        if (pipeBE2.updateText(pipeText -> pipeText.setHasGlowingText(Boolean.FALSE))) {
                            world.playSound(player, pos, SoundEvents.INK_SAC_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                            this.coloredDustParticles(world, pos, new Vector3f(0.0f, 0.0f, 0.0f), UniformInt.of((int)8, (int)12));
                            warpBlockEntity.markUpdated();
                            isSuccesful = true;
                        }
                    } else if (item == Items.GLOW_INK_SAC) {
                        if (pipeBE2.updateText(pipeText -> pipeText.setHasGlowingText(Boolean.TRUE))) {
                            world.playSound(player, pos, SoundEvents.GLOW_INK_SAC_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                            WarpPipeBlock.spawnParticlesOnBlockFaces(world, pos, (ParticleOptions)ParticleTypes.GLOW, new Vec3(0.0, 0.0, 0.0), (IntProvider)UniformInt.of((int)3, (int)5));
                            warpBlockEntity.markUpdated();
                            isSuccesful = true;
                        }
                    } else if (stack.is(Items.BRUSH)) {
                        if (hit.getDirection() == Direction.NORTH) {
                            pipeBE2.setTextNorth(!pipeBE2.hasTextNorth());
                            this.dyedDustParticles(pipeBE2, world, pos, Direction.NORTH);
                        } else if (hit.getDirection() == Direction.SOUTH) {
                            pipeBE2.setTextSouth(!pipeBE2.hasTextSouth());
                            this.dyedDustParticles(pipeBE2, world, pos, Direction.SOUTH);
                        } else if (hit.getDirection() == Direction.EAST) {
                            pipeBE2.setTextEast(!pipeBE2.hasTextEast());
                            this.dyedDustParticles(pipeBE2, world, pos, Direction.EAST);
                        } else if (hit.getDirection() == Direction.WEST) {
                            pipeBE2.setTextWest(!pipeBE2.hasTextWest());
                            this.dyedDustParticles(pipeBE2, world, pos, Direction.WEST);
                        } else if (hit.getDirection() == Direction.UP) {
                            pipeBE2.setTextAbove(!pipeBE2.hasTextAbove());
                            this.dyedDustParticles(pipeBE2, world, pos, Direction.UP);
                        } else if (hit.getDirection() == Direction.DOWN) {
                            pipeBE2.setTextBelow(!pipeBE2.hasTextBelow());
                            this.dyedDustParticles(pipeBE2, world, pos, Direction.DOWN);
                        }
                        world.playSound(player, pos, SoundEvents.BRUSH_SAND_COMPLETED, SoundSource.BLOCKS, 1.0f, 1.0f);
                        warpBlockEntity.markUpdated();
                        isSuccesfulTool = true;
                    } else if (stack.is(CompatRegistry.BUBBLE_BLOWER.get()) || stack.is(CompatRegistry.SOAP.get())) {
                        if (hit.getDirection() == Direction.NORTH && pipeBE2.hasTextNorth()) {
                            pipeBE2.setTextNorth(Boolean.FALSE);
                            world.playSound(player, pos, CompatRegistry.BUBBLE_BLOWER_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            this.sudParticles(world, pos, Direction.NORTH);
                            warpBlockEntity.markUpdated();
                            isSuccesfulTool = true;
                        } else if (hit.getDirection() == Direction.SOUTH && pipeBE2.hasTextSouth()) {
                            pipeBE2.setTextSouth(Boolean.FALSE);
                            world.playSound(player, pos, CompatRegistry.BUBBLE_BLOWER_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            this.sudParticles(world, pos, Direction.SOUTH);
                            warpBlockEntity.markUpdated();
                            isSuccesfulTool = true;
                        } else if (hit.getDirection() == Direction.EAST && pipeBE2.hasTextEast()) {
                            pipeBE2.setTextEast(Boolean.FALSE);
                            world.playSound(player, pos, CompatRegistry.BUBBLE_BLOWER_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            this.sudParticles(world, pos, Direction.EAST);
                            warpBlockEntity.markUpdated();
                            isSuccesfulTool = true;
                        } else if (hit.getDirection() == Direction.WEST && pipeBE2.hasTextWest()) {
                            pipeBE2.setTextWest(Boolean.FALSE);
                            world.playSound(player, pos, CompatRegistry.BUBBLE_BLOWER_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            this.sudParticles(world, pos, Direction.WEST);
                            warpBlockEntity.markUpdated();
                            isSuccesfulTool = true;
                        } else if (hit.getDirection() == Direction.UP && pipeBE2.hasTextAbove()) {
                            pipeBE2.setTextAbove(Boolean.FALSE);
                            world.playSound(player, pos, CompatRegistry.BUBBLE_BLOWER_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            this.sudParticles(world, pos, Direction.UP);
                            warpBlockEntity.markUpdated();
                            isSuccesfulTool = true;
                        } else if (hit.getDirection() == Direction.DOWN && pipeBE2.hasTextBelow()) {
                            pipeBE2.setTextBelow(Boolean.FALSE);
                            world.playSound(player, pos, CompatRegistry.BUBBLE_BLOWER_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            this.sudParticles(world, pos, Direction.DOWN);
                            warpBlockEntity.markUpdated();
                            isSuccesfulTool = true;
                        }
                    } else if (item instanceof DyeItem && pipeBE2.updateText(arg_0 -> WarpPipeBlock.lambda$useItemOn$6(dyeItem = (DyeItem)item, arg_0))) {
                        int textColor = dyeItem.getDyeColor().getTextColor();
                        float red = (float)(textColor >> 16 & 0xFF) / 255.0f;
                        float green = (float)(textColor >> 8 & 0xFF) / 255.0f;
                        float blue = (float)(textColor & 0xFF) / 255.0f;
                        Vector3f colorVec = new Vector3f(red, green, blue);
                        world.playSound(null, pos, SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        ParticleUtils.spawnParticlesOnBlockFaces((Level)world, (BlockPos)pos, (ParticleOptions)new DustParticleOptions(colorVec, 1.0f), (IntProvider)UniformInt.of((int)8, (int)12));
                        warpBlockEntity.markUpdated();
                        isSuccesful = true;
                    }
                }
            }
            if (isSuccesfulTool) {
                if (!player.isCreative()) {
                    stack.hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                }
                if (player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pos, stack);
                    player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                }
                return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
            }
            if (isSuccesful) {
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                if (player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pos, stack);
                    player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                }
                return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof WarpPipeBlockEntity) {
            CustomData data;
            WarpPipeBlockEntity pipeBE = (WarpPipeBlockEntity)blockEntity;
            if (stack.has(DataComponents.CUSTOM_NAME) || stack.has(DataComponentRegistry.PIPE_NAME)) {
                pipeBE.setCustomName(stack.getHoverName());
                pipeBE.setPipeName(stack.getHoverName());
                pipeBE.setChanged();
            }
            if ((data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA)) != null && data.copyTag().hasUUID("UUID")) {
                pipeBE.setUUID(data.copyTag().getUUID("UUID"));
                pipeBE.setChanged();
            } else {
                UUID uuid = UUID.randomUUID();
                pipeBE.setUUID(uuid);
                pipeBE.setChanged();
            }
            pipeBE.onLoad();
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        Direction direction = placeContext.getClickedFace();
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)FACING)));
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos posNeighbor, boolean b) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            this.checkAndFlip(state, serverWorld, pos);
        }
        super.neighborChanged(state, world, pos, block, posNeighbor, b);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor worldAccessor, BlockPos pos, BlockPos posNeighbor) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos posRelative = pos.relative(facing);
        return (BlockState)state.setValue((Property)ENTRANCE, (Comparable)Boolean.valueOf(worldAccessor.getBlockState(posRelative).getBlock() != this));
    }

    public void tick(BlockState state, ServerLevel serverWorld, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = serverWorld.getBlockEntity(pos);
        if (blockEntity instanceof WarpPipeBlockEntity) {
            WarpPipeBlockEntity pipeBE = (WarpPipeBlockEntity)blockEntity;
            if (!serverWorld.isClientSide && pipeBE.getUUID() == null) {
                UUID uuid = UUID.randomUUID();
                pipeBE.setUUID(uuid);
                pipeBE.setChanged();
                BaseWarpBlockEntity.WARP_LOCATIONS.put(uuid, pos);
            }
            if (((Boolean)state.getValue((Property)WATER_SPOUT)).booleanValue() && state.getValue((Property)FACING) == Direction.UP && serverWorld.dimension() != Level.NETHER) {
                WaterSpoutBlock.repeatColumnUp((LevelAccessor)serverWorld, pos.above(), state, pipeBE.spoutHeight);
                serverWorld.scheduleTick(pos, (Block)this, 3);
            }
            if (((Boolean)state.getValue((Property)BUBBLES)).booleanValue() && state.getValue((Property)FACING) == Direction.UP) {
                PipeBubblesBlock.repeatColumnUp((LevelAccessor)serverWorld, pos.above(), state, pipeBE.bubblesDistance);
                serverWorld.scheduleTick(pos, (Block)this, 3);
            } else if (((Boolean)state.getValue((Property)BUBBLES)).booleanValue() && state.getValue((Property)FACING) == Direction.DOWN) {
                PipeBubblesBlock.repeatColumnDown((LevelAccessor)serverWorld, pos.below(), state, pipeBE.bubblesDistance);
                serverWorld.scheduleTick(pos, (Block)this, 3);
            } else if (((Boolean)state.getValue((Property)BUBBLES)).booleanValue() && state.getValue((Property)FACING) == Direction.NORTH) {
                PipeBubblesBlock.repeatColumnNorth((LevelAccessor)serverWorld, pos.north(), state, pipeBE.bubblesDistance);
                serverWorld.scheduleTick(pos, (Block)this, 3);
            } else if (((Boolean)state.getValue((Property)BUBBLES)).booleanValue() && state.getValue((Property)FACING) == Direction.SOUTH) {
                PipeBubblesBlock.repeatColumnSouth((LevelAccessor)serverWorld, pos.south(), state, pipeBE.bubblesDistance);
                serverWorld.scheduleTick(pos, (Block)this, 3);
            } else if (((Boolean)state.getValue((Property)BUBBLES)).booleanValue() && state.getValue((Property)FACING) == Direction.EAST) {
                PipeBubblesBlock.repeatColumnEast((LevelAccessor)serverWorld, pos.east(), state, pipeBE.bubblesDistance);
                serverWorld.scheduleTick(pos, (Block)this, 3);
            } else if (((Boolean)state.getValue((Property)BUBBLES)).booleanValue() && state.getValue((Property)FACING) == Direction.WEST) {
                PipeBubblesBlock.repeatColumnWest((LevelAccessor)serverWorld, pos.west(), state, pipeBE.bubblesDistance);
                serverWorld.scheduleTick(pos, (Block)this, 3);
            }
        }
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState neighborState, boolean b) {
        Block blockAbove = world.getBlockState(pos.above()).getBlock();
        Block blockBelow = world.getBlockState(pos.below()).getBlock();
        Block blockNorth = world.getBlockState(pos.north()).getBlock();
        Block blockSouth = world.getBlockState(pos.south()).getBlock();
        Block blockEast = world.getBlockState(pos.east()).getBlock();
        Block blockWest = world.getBlockState(pos.west()).getBlock();
        if (neighborState.getBlock() != state.getBlock() && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            this.checkAndFlip(state, serverWorld, pos);
        }
        if (state.getValue((Property)FACING) == Direction.UP) {
            if (blockAbove == this) {
                world.setBlock(pos, (BlockState)state.setValue((Property)ENTRANCE, (Comparable)Boolean.FALSE), 3);
            } else {
                world.setBlock(pos, (BlockState)state.setValue((Property)ENTRANCE, (Comparable)Boolean.TRUE), 3);
            }
            if (blockAbove == Blocks.WATER) {
                world.scheduleTick(pos, (Block)this, 3);
            }
        }
        if (state.getValue((Property)FACING) == Direction.DOWN) {
            if (blockBelow == this) {
                world.setBlock(pos, (BlockState)state.setValue((Property)ENTRANCE, (Comparable)Boolean.FALSE), 3);
            } else {
                world.setBlock(pos, (BlockState)state.setValue((Property)ENTRANCE, (Comparable)Boolean.TRUE), 3);
            }
            if (blockBelow == Blocks.WATER) {
                world.scheduleTick(pos, (Block)this, 3);
            }
        }
        if (state.getValue((Property)FACING) == Direction.NORTH) {
            if (blockNorth == this) {
                world.setBlock(pos, (BlockState)state.setValue((Property)ENTRANCE, (Comparable)Boolean.FALSE), 3);
            } else {
                world.setBlock(pos, (BlockState)state.setValue((Property)ENTRANCE, (Comparable)Boolean.TRUE), 3);
            }
            if (blockNorth == Blocks.WATER) {
                world.scheduleTick(pos, (Block)this, 3);
            }
        }
        if (state.getValue((Property)FACING) == Direction.SOUTH) {
            if (blockSouth == this) {
                world.setBlock(pos, (BlockState)state.setValue((Property)ENTRANCE, (Comparable)Boolean.FALSE), 3);
            } else {
                world.setBlock(pos, (BlockState)state.setValue((Property)ENTRANCE, (Comparable)Boolean.TRUE), 3);
            }
            if (blockSouth == Blocks.WATER) {
                world.scheduleTick(pos, (Block)this, 3);
            }
        }
        if (state.getValue((Property)FACING) == Direction.EAST) {
            if (blockEast == this) {
                world.setBlock(pos, (BlockState)state.setValue((Property)ENTRANCE, (Comparable)Boolean.FALSE), 3);
            } else {
                world.setBlock(pos, (BlockState)state.setValue((Property)ENTRANCE, (Comparable)Boolean.TRUE), 3);
            }
            if (blockEast == Blocks.WATER) {
                world.scheduleTick(pos, (Block)this, 3);
            }
        }
        if (state.getValue((Property)FACING) == Direction.WEST) {
            if (blockWest == this) {
                world.setBlock(pos, (BlockState)state.setValue((Property)ENTRANCE, (Comparable)Boolean.FALSE), 3);
            } else {
                world.setBlock(pos, (BlockState)state.setValue((Property)ENTRANCE, (Comparable)Boolean.TRUE), 3);
            }
            if (blockWest == Blocks.WATER) {
                world.scheduleTick(pos, (Block)this, 3);
            }
        }
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        WarpPipeBlockEntity warpPipeBE;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        double dx = pos.getX();
        double dy = pos.getY();
        double dz = pos.getZ();
        Fluid fluidAbove = world.getFluidState(pos.above()).getType();
        Fluid fluidBelow = world.getFluidState(pos.below()).getType();
        Fluid fluidNorth = world.getFluidState(pos.north()).getType();
        Fluid fluidSouth = world.getFluidState(pos.south()).getType();
        Fluid fluidEast = world.getFluidState(pos.east()).getType();
        Fluid fluidWest = world.getFluidState(pos.west()).getType();
        Block blockAbove = world.getBlockState(pos.above()).getBlock();
        Block blockBelow = world.getBlockState(pos.below()).getBlock();
        Block blockNorth = world.getBlockState(pos.north()).getBlock();
        Block blockSouth = world.getBlockState(pos.south()).getBlock();
        Block blockEast = world.getBlockState(pos.east()).getBlock();
        Block blockWest = world.getBlockState(pos.west()).getBlock();
        if (!((Boolean)state.getValue((Property)CLOSED)).booleanValue() && (((Boolean)state.getValue((Property)BUBBLES)).booleanValue() || ((Boolean)state.getValue((Property)WATER_SPOUT)).booleanValue()) && ((Boolean)state.getValue((Property)ENTRANCE)).booleanValue() && blockEntity instanceof WarpPipeBlockEntity && (warpPipeBE = (WarpPipeBlockEntity)blockEntity).getPersistentData().isEmpty()) {
            if (state.getValue((Property)FACING) == Direction.UP) {
                if (fluidAbove instanceof LavaFluid) {
                    if (random.nextInt(10) == 0) {
                        world.addParticle((ParticleOptions)ParticleTypes.LAVA, dx + 0.5, dy + 1.0, dz + 0.5, 0.0, 0.0, 0.0);
                    }
                } else if (fluidAbove instanceof WaterFluid || blockAbove instanceof PipeBubblesBlock) {
                    world.addParticle((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, dx + 0.5, dy + 1.15, dz + 0.5, 0.0, 0.4, 0.0);
                    world.addParticle((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, dx + (double)random.nextFloat(), dy + (double)random.nextFloat() + 1.15, dz + (double)random.nextFloat(), 0.0, 0.4, 0.0);
                }
            }
            if (state.getValue((Property)FACING) == Direction.DOWN) {
                if (fluidBelow instanceof LavaFluid) {
                    if (random.nextInt(10) == 0) {
                        world.addParticle((ParticleOptions)ParticleTypes.LAVA, dx + 0.5, dy - 0.5, dz + 0.05, 0.0, 0.0, 0.0);
                    }
                } else if (fluidBelow instanceof WaterFluid || blockBelow instanceof PipeBubblesBlock) {
                    world.addParticle((ParticleOptions)ParticleTypes.BUBBLE, dx + 0.5, dy - 1.15, dz + 0.5, 0.0, -0.4, 0.0);
                    world.addParticle((ParticleOptions)ParticleTypes.BUBBLE, dx + (double)random.nextFloat(), dy - (double)random.nextFloat() - 1.15, dz + (double)random.nextFloat(), 0.0, -0.4, 0.0);
                }
            }
            if (state.getValue((Property)FACING) == Direction.NORTH) {
                if (fluidNorth instanceof LavaFluid) {
                    if (random.nextInt(10) == 0) {
                        world.addParticle((ParticleOptions)ParticleTypes.LAVA, dx + 0.5, dy + 0.5, dz - 0.05, 0.0, 0.0, 0.0);
                    }
                } else if (fluidNorth instanceof WaterFluid || blockNorth instanceof PipeBubblesBlock) {
                    world.addParticle((ParticleOptions)ParticleTypes.BUBBLE, dx + 0.5, dy + 0.5, dz - 1.15, 0.0, 0.4, -1.5);
                    world.addParticle((ParticleOptions)ParticleTypes.BUBBLE, dx + (double)random.nextFloat(), dy + (double)random.nextFloat(), dz + (double)random.nextFloat() - 1.15, 0.0, 0.4, -1.5);
                }
            }
            if (state.getValue((Property)FACING) == Direction.SOUTH) {
                if (fluidSouth instanceof LavaFluid) {
                    if (random.nextInt(10) == 0) {
                        world.addParticle((ParticleOptions)ParticleTypes.LAVA, dx + 0.5, dy + 0.5, dz + 1.05, 0.0, 0.0, 0.0);
                    }
                } else if (fluidSouth instanceof WaterFluid || blockSouth instanceof PipeBubblesBlock) {
                    world.addParticle((ParticleOptions)ParticleTypes.BUBBLE, dx + 0.5, dy + 0.5, dz + 1.15, 0.0, 0.4, 0.0);
                    world.addParticle((ParticleOptions)ParticleTypes.BUBBLE, dx + (double)random.nextFloat(), dy + (double)random.nextFloat(), dz + (double)random.nextFloat() + 1.15, 0.0, 0.4, 0.0);
                }
            }
            if (state.getValue((Property)FACING) == Direction.EAST) {
                if (fluidEast instanceof LavaFluid) {
                    if (random.nextInt(10) == 0) {
                        world.addParticle((ParticleOptions)ParticleTypes.LAVA, dx + 1.05, dy + 0.5, dz + 0.5, 0.0, 0.0, 0.0);
                    }
                } else if (fluidEast instanceof WaterFluid || blockEast instanceof PipeBubblesBlock) {
                    world.addParticle((ParticleOptions)ParticleTypes.BUBBLE, dx + 1.15, dy + 0.5, dz + 0.5, 0.0, 0.4, 0.0);
                    world.addParticle((ParticleOptions)ParticleTypes.BUBBLE, dx + (double)random.nextFloat() + 1.15, dy + (double)random.nextFloat(), dz + (double)random.nextFloat(), 0.0, 0.4, 0.0);
                }
            }
            if (state.getValue((Property)FACING) == Direction.WEST) {
                if (fluidWest instanceof LavaFluid) {
                    if (random.nextInt(10) == 0) {
                        world.addParticle((ParticleOptions)ParticleTypes.LAVA, dx - 0.05, dy + 0.5, dz + 0.5, 0.0, 0.0, 0.0);
                    }
                } else if (fluidWest instanceof WaterFluid || blockWest instanceof PipeBubblesBlock) {
                    world.addParticle((ParticleOptions)ParticleTypes.BUBBLE, dx - 1.15, dy + 0.5, dz + 0.5, 0.0, 0.4, 0.0);
                    world.addParticle((ParticleOptions)ParticleTypes.BUBBLE, dx + (double)random.nextFloat() - 1.15, dy + (double)random.nextFloat(), dz + (double)random.nextFloat(), 0.0, 0.4, 0.0);
                }
            }
        }
        super.animateTick(state, world, pos, random);
    }

    public void checkAndFlip(BlockState state, ServerLevel serverWorld, BlockPos pos) {
        boolean hasNeighborSignal = serverWorld.hasNeighborSignal(pos);
        BlockState newState = state;
        if (hasNeighborSignal != (Boolean)state.getValue((Property)POWERED)) {
            if (!((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
                newState = (BlockState)state.cycle((Property)CLOSED);
                serverWorld.playSound(null, pos, (Boolean)newState.getValue((Property)CLOSED) != false ? (SoundEvent)SoundRegistry.PIPE_OPENS.get() : (SoundEvent)SoundRegistry.PIPE_CLOSES.get(), SoundSource.BLOCKS);
            }
            serverWorld.setBlock(pos, (BlockState)newState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(hasNeighborSignal)), 3);
        }
    }

    private void flipNeighborPipeState(ServerLevel world, BlockState state, BlockPos pos, BlockState stateNeighbor) {
        Direction facing = (Direction)stateNeighbor.getValue((Property)FACING);
        BlockPos checkPos = pos.relative(facing);
        if (state.getBlock() == this && ((Boolean)state.getValue((Property)ENTRANCE)).booleanValue() && state.getValue((Property)FACING) == stateNeighbor.getValue((Property)FACING)) {
            world.setBlock(pos, (BlockState)state.setValue((Property)CLOSED, (Comparable)((Boolean)stateNeighbor.getValue((Property)CLOSED))), 3);
        }
    }

    public void playSound(Level world, BlockPos pos, SoundEvent soundEvent, SoundSource source, float volume, float pitch) {
        world.playSound(null, pos, soundEvent, source, volume, pitch);
    }

    public void dyedDustParticles(WarpPipeBlockEntity pipeBlockEntity, Level world, BlockPos pos, Direction direction) {
        RandomSource random = world.getRandom();
        int textColor = pipeBlockEntity.getPipeText().getColor().getTextColor();
        float red = (float)(textColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(textColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(textColor & 0xFF) / 255.0f;
        Vector3f colorVec = new Vector3f(red, green, blue);
        ParticleUtils.spawnParticlesOnBlockFace((Level)world, (BlockPos)pos, (ParticleOptions)new DustParticleOptions(colorVec, 0.5f), (IntProvider)UniformInt.of((int)8, (int)12), (Direction)direction, () -> new Vec3(Mth.nextDouble((RandomSource)random, (double)-0.005f, (double)0.005f), Mth.nextDouble((RandomSource)random, (double)-0.005f, (double)0.005f), Mth.nextDouble((RandomSource)random, (double)-0.005f, (double)0.005f)), (double)0.55);
    }

    public void coloredDustParticles(Level world, BlockPos pos, Vector3f colorVec, UniformInt amount) {
        ParticleUtils.spawnParticlesOnBlockFaces((Level)world, (BlockPos)pos, (ParticleOptions)new DustParticleOptions(colorVec, 0.5f), (IntProvider)amount);
    }

    public void sudParticles(Level world, BlockPos pos, Direction direction) {
        RandomSource random = world.getRandom();
        ParticleUtils.spawnParticlesOnBlockFace((Level)world, (BlockPos)pos, (ParticleOptions)((ParticleOptions)CompatRegistry.SUDS_PARTICLE.get()), (IntProvider)UniformInt.of((int)5, (int)8), (Direction)direction, () -> new Vec3(Mth.nextDouble((RandomSource)random, (double)-0.005f, (double)0.005f), Mth.nextDouble((RandomSource)random, (double)-0.005f, (double)0.005f), Mth.nextDouble((RandomSource)random, (double)-0.005f, (double)0.005f)), (double)0.55);
    }

    public static void spawnParticlesOnBlockFaces(Level world, BlockPos pos, ParticleOptions particles, Vec3 speedRange, IntProvider amountRange) {
        for (Direction direction : Direction.values()) {
            ParticleUtils.spawnParticlesOnBlockFace((Level)world, (BlockPos)pos, (ParticleOptions)particles, (IntProvider)amountRange, (Direction)direction, () -> speedRange, (double)0.55);
        }
    }

    private static /* synthetic */ PipeText lambda$useItemOn$6(DyeItem dyeItem, PipeText pipeText) {
        return pipeText.setColor(dyeItem.getDyeColor());
    }
}

