/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.client.renderers.entities.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.wenxin2.marioverse.entities.CrackableEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.Color;

public class CrackedGeoLayer<T extends GeoAnimatable>
extends GeoRenderLayer<T> {
    private final ResourceLocation textureLowCracks;
    private final ResourceLocation textureMediumCracks;
    private final ResourceLocation textureHighCracks;

    public CrackedGeoLayer(GeoRenderer<T> renderer, ResourceLocation textureLowCracks, ResourceLocation textureMediumCracks, ResourceLocation textureHighCracks) {
        super(renderer);
        this.textureLowCracks = textureLowCracks;
        this.textureMediumCracks = textureMediumCracks;
        this.textureHighCracks = textureHighCracks;
    }

    public void render(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        Entity entity;
        BakedGeoModel overlayModel = this.getRenderer().getGeoModel().getBakedModel(this.getRenderer().getGeoModel().getModelResource(animatable));
        poseStack.pushPose();
        poseStack.scale(1.01f, 1.01f, 1.01f);
        if (animatable instanceof Entity && !(entity = (Entity)animatable).isInvisible() && entity instanceof CrackableEntity) {
            CrackableEntity crackableEntity = (CrackableEntity)entity;
            Crackiness.Level crackinessLevel = crackableEntity.getCrackiness();
            ResourceLocation crackTexture = switch (crackinessLevel) {
                default -> throw new MatchException(null, null);
                case Crackiness.Level.NONE -> this.getTextureResource((GeoAnimatable)animatable);
                case Crackiness.Level.LOW -> this.textureLowCracks;
                case Crackiness.Level.MEDIUM -> this.textureMediumCracks;
                case Crackiness.Level.HIGH -> this.textureHighCracks;
            };
            RenderType armorRenderType = RenderType.armorCutoutNoCull((ResourceLocation)crackTexture);
            if (crackinessLevel == Crackiness.Level.LOW) {
                this.getRenderer().reRender(overlayModel, poseStack, bufferSource, animatable, armorRenderType, bufferSource.getBuffer(armorRenderType), partialTick, packedLight, OverlayTexture.NO_OVERLAY, Color.WHITE.argbInt());
            } else if (crackinessLevel == Crackiness.Level.MEDIUM) {
                armorRenderType = RenderType.armorCutoutNoCull((ResourceLocation)crackTexture);
                this.getRenderer().reRender(overlayModel, poseStack, bufferSource, animatable, armorRenderType, bufferSource.getBuffer(armorRenderType), partialTick, packedLight, OverlayTexture.NO_OVERLAY, Color.WHITE.argbInt());
            } else if (crackinessLevel == Crackiness.Level.HIGH) {
                armorRenderType = RenderType.armorCutoutNoCull((ResourceLocation)crackTexture);
                this.getRenderer().reRender(overlayModel, poseStack, bufferSource, animatable, armorRenderType, bufferSource.getBuffer(armorRenderType), partialTick, packedLight, OverlayTexture.NO_OVERLAY, Color.WHITE.argbInt());
            }
        }
        poseStack.popPose();
    }
}

