/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.data;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.block.Block;

public class BlockFamilyExtended {
    private final Block baseBlock;
    final Map<Variant, Block> variants = Maps.newHashMap();
    boolean generateModel = true;
    boolean generateRecipe = true;
    @Nullable
    String recipeGroupPrefix;
    @Nullable
    String recipeUnlockedBy;

    BlockFamilyExtended(Block block) {
        this.baseBlock = block;
    }

    public Block getBaseBlock() {
        return this.baseBlock;
    }

    public Map<Variant, Block> getVariants() {
        return this.variants;
    }

    public Block get(Variant variant) {
        return this.variants.get((Object)variant);
    }

    public boolean shouldGenerateModel() {
        return this.generateModel;
    }

    public boolean shouldGenerateRecipe() {
        return this.generateRecipe;
    }

    public Optional<String> getRecipeGroupPrefix() {
        return StringUtil.isBlank((String)this.recipeGroupPrefix) ? Optional.empty() : Optional.of(this.recipeGroupPrefix);
    }

    public Optional<String> getRecipeUnlockedBy() {
        return StringUtil.isBlank((String)this.recipeUnlockedBy) ? Optional.empty() : Optional.of(this.recipeUnlockedBy);
    }

    public static enum Variant {
        BUTTON("button"),
        BRICKS("bricks"),
        BRIDGE("bridge"),
        BRIDGE_STAIRS("bridge_stairs"),
        CHISELED("chiseled"),
        CRACKED("cracked"),
        CUSTOM_FENCE("fence"),
        CUSTOM_FENCE_GATE("fence_gate"),
        CUT("cut"),
        DOOR("door"),
        FENCE("fence"),
        FENCE_GATE("fence_gate"),
        INVISIBLE_QUESTION_BLOCK("invisible_question_block"),
        MOSAIC("mosaic"),
        PEDESTAL("pedestal"),
        POLISHED("polished"),
        PRESSURE_PLATE("pressure_plate"),
        QUESTION_BLOCK("question_block"),
        QUESTION_BLOCK_TAG("question_block_tag"),
        QUESTION_PANEL("question_panel"),
        QUICKSAND("quicksand"),
        SIGN("sign"),
        SLAB("slab"),
        SMASHABLE_BLOCKS("smashable_blocks"),
        STAIRS("stairs"),
        STORAGE_BRICKS("storage_bricks"),
        TRAPDOOR("trapdoor"),
        WALL("wall"),
        WALL_SIGN("wall_sign");

        private final String recipeGroup;

        private Variant(String groupName) {
            this.recipeGroup = groupName;
        }

        public String getRecipeGroup() {
            return this.recipeGroup;
        }
    }

    public static class Builder {
        private final BlockFamilyExtended family;

        public Builder(Block block) {
            this.family = new BlockFamilyExtended(block);
        }

        public BlockFamilyExtended getFamily() {
            return this.family;
        }

        public Builder button(Block block) {
            this.family.variants.put(Variant.BUTTON, block);
            return this;
        }

        public Builder bricks(Block block) {
            this.family.variants.put(Variant.BRICKS, block);
            return this;
        }

        public Builder bridge(Block block) {
            this.family.variants.put(Variant.BRIDGE, block);
            return this;
        }

        public Builder bridgeStairs(Block block) {
            this.family.variants.put(Variant.BRIDGE_STAIRS, block);
            return this;
        }

        public Builder chiseled(Block block) {
            this.family.variants.put(Variant.CHISELED, block);
            return this;
        }

        public Builder cracked(Block block) {
            this.family.variants.put(Variant.CRACKED, block);
            return this;
        }

        public Builder customFence(Block block) {
            this.family.variants.put(Variant.CUSTOM_FENCE, block);
            return this;
        }

        public Builder customFenceGate(Block block) {
            this.family.variants.put(Variant.CUSTOM_FENCE_GATE, block);
            return this;
        }

        public Builder cut(Block block) {
            this.family.variants.put(Variant.CUT, block);
            return this;
        }

        public Builder door(Block block) {
            this.family.variants.put(Variant.DOOR, block);
            return this;
        }

        public Builder fence(Block block) {
            this.family.variants.put(Variant.FENCE, block);
            return this;
        }

        public Builder fenceGate(Block block) {
            this.family.variants.put(Variant.FENCE_GATE, block);
            return this;
        }

        public Builder invisibleQuestionBlock(Block block) {
            this.family.variants.put(Variant.INVISIBLE_QUESTION_BLOCK, block);
            return this;
        }

        public Builder mosaic(Block block) {
            this.family.variants.put(Variant.MOSAIC, block);
            return this;
        }

        public Builder pedestal(Block block) {
            this.family.variants.put(Variant.PEDESTAL, block);
            return this;
        }

        public Builder polished(Block block) {
            this.family.variants.put(Variant.POLISHED, block);
            return this;
        }

        public Builder pressurePlate(Block block) {
            this.family.variants.put(Variant.PRESSURE_PLATE, block);
            return this;
        }

        public Builder questionBlock(Block block) {
            this.family.variants.put(Variant.QUESTION_BLOCK, block);
            return this;
        }

        public Builder questionBlockTag(Block block) {
            this.family.variants.put(Variant.QUESTION_BLOCK_TAG, block);
            return this;
        }

        public Builder questionPanel(Block block) {
            this.family.variants.put(Variant.QUESTION_PANEL, block);
            return this;
        }

        public Builder quicksand(Block block) {
            this.family.variants.put(Variant.QUICKSAND, block);
            return this;
        }

        public Builder sign(Block block, Block blockWall) {
            this.family.variants.put(Variant.SIGN, block);
            this.family.variants.put(Variant.WALL_SIGN, blockWall);
            return this;
        }

        public Builder slab(Block block) {
            this.family.variants.put(Variant.SLAB, block);
            return this;
        }

        public Builder smashableBlock(Block block) {
            this.family.variants.put(Variant.SMASHABLE_BLOCKS, block);
            return this;
        }

        public Builder stairs(Block block) {
            this.family.variants.put(Variant.STAIRS, block);
            return this;
        }

        public Builder storageBricks(Block block) {
            this.family.variants.put(Variant.STORAGE_BRICKS, block);
            return this;
        }

        public Builder trapdoor(Block block) {
            this.family.variants.put(Variant.TRAPDOOR, block);
            return this;
        }

        public Builder wall(Block block) {
            this.family.variants.put(Variant.WALL, block);
            return this;
        }

        public Builder dontGenerateModel() {
            this.family.generateModel = false;
            return this;
        }

        public Builder dontGenerateRecipe() {
            this.family.generateRecipe = false;
            return this;
        }

        public Builder recipeGroupPrefix(String groupName) {
            this.family.recipeGroupPrefix = groupName;
            return this;
        }

        public Builder recipeUnlockedBy(String recipeUnlockedBy) {
            this.family.recipeUnlockedBy = recipeUnlockedBy;
            return this;
        }
    }
}

