/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities;

import com.mojang.authlib.GameProfile;
import com.wenxin2.marioverse.entities.ai.controls.FloatMoveControl;
import com.wenxin2.marioverse.entities.ai.goals.ChargeAttackGoal;
import com.wenxin2.marioverse.entities.ai.goals.FreezeWhenLookedAt;
import com.wenxin2.marioverse.entities.ai.goals.LookAtTagGoal;
import com.wenxin2.marioverse.entities.ai.goals.NearestAttackableTagGoal;
import com.wenxin2.marioverse.entities.ai.goals.RandomMoveGoal;
import com.wenxin2.marioverse.integration.CompatRegistry;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.ItemRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BooEntity
extends Monster
implements GeoEntity {
    public static final RawAnimation ATTACK_SWING_LEFT = RawAnimation.begin().thenPlay("attack.swing.left");
    public static final RawAnimation ATTACK_SWING_RIGHT = RawAnimation.begin().thenPlay("attack.swing.right");
    public static final RawAnimation CHARGE = RawAnimation.begin().thenLoop("boo.charge");
    public static final RawAnimation HIDE = RawAnimation.begin().thenLoop("boo.hide");
    public static final RawAnimation IDLE = RawAnimation.begin().thenLoop("boo.idle");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @Nullable
    private BlockPos boundOrigin;

    public BooEntity(EntityType<? extends BooEntity> type, Level world) {
        super(type, world);
        this.setPathfindingMalus(PathType.DOOR_OPEN, 1.0f);
        this.moveControl = new FloatMoveControl((Mob)this);
        this.xpReward = 10;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.BOO_LAUGH.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.BOO_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.BOO_DEATH.get();
    }

    public int getAmbientSoundInterval() {
        return 360;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FreezeWhenLookedAt((Mob)this, TagRegistry.BOO_CAN_ATTACK));
        this.goalSelector.addGoal(1, (Goal)new ChargeAttackGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(3, (Goal)new RandomMoveGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new LookAtTagGoal((Mob)this, TagRegistry.BOO_CAN_ATTACK, 16.0f, 1.0f));
        this.targetSelector.addGoal(0, (Goal)new NearestAttackableTagGoal((Mob)this, TagRegistry.BOO_CAN_ATTACK, false));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Idle", 5, this::animController));
        controllers.add(new AnimationController((GeoAnimatable)this, "Run", 5, this::animController));
        controllers.add(new AnimationController((GeoAnimatable)this, "Swim", 15, this::animController));
        controllers.add(new AnimationController((GeoAnimatable)this, "Walk", 5, this::animController));
        controllers.add(DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)((double)this.getRandom().nextFloat() < 0.25 ? DefaultAnimations.ATTACK_BITE : (this.isLeftHanded() ? ATTACK_SWING_LEFT : ATTACK_SWING_RIGHT))).transitionLength(1));
        controllers.add(DefaultAnimations.genericWalkController((GeoAnimatable)this));
    }

    protected <E extends GeoAnimatable> PlayState animController(AnimationState<E> event) {
        if (((Boolean)this.getData(DataAttachmentRegistry.IS_HIDING.get())).booleanValue()) {
            event.setAndContinue(HIDE);
            return PlayState.CONTINUE;
        }
        if (((Boolean)this.getData(DataAttachmentRegistry.IS_ATTACKING.get())).booleanValue() || ((Boolean)this.getData(DataAttachmentRegistry.IS_CHARGING.get())).booleanValue()) {
            event.setAndContinue(CHARGE);
            return PlayState.CONTINUE;
        }
        event.setAndContinue(IDLE);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("BoundX")) {
            this.boundOrigin = new BlockPos(tag.getInt("BoundX"), tag.getInt("BoundY"), tag.getInt("BoundZ"));
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.boundOrigin != null) {
            tag.putInt("BoundX", this.boundOrigin.getX());
            tag.putInt("BoundY", this.boundOrigin.getY());
            tag.putInt("BoundZ", this.boundOrigin.getZ());
        }
    }

    public void tick() {
        this.noPhysics = true;
        super.tick();
        this.noPhysics = false;
        this.setNoGravity(true);
        if (this.isInWaterOrBubble()) {
            this.ejectPassengers();
        }
        if (!(this.level().isClientSide || this.isNoAi() || ((Boolean)this.getData(DataAttachmentRegistry.HAS_SUPER_STAR.get())).booleanValue())) {
            BlockPos posEye = BlockPos.containing((double)this.getX(), (double)this.getEyeY(), (double)this.getZ());
            if (this.level().getBrightness(LightLayer.SKY, this.blockPosition()) >= (Integer)ConfigRegistry.BOO_SUN_EXPOSURE_LIMIT.get() && this.level().canSeeSky(posEye) && this.getItemBySlot(EquipmentSlot.HEAD).isEmpty() && this.level().isDay() && this.isAlive() && this.random.nextFloat() < 0.01f) {
                this.playDeathAnimation((Entity)this);
                this.playSound((SoundEvent)SoundRegistry.BOO_POOF.get(), 1.0f, 1.0f);
                this.discard();
            }
        }
    }

    public void baseTick() {
        int i = this.getAirSupply();
        super.baseTick();
        this.handleAirSupply(i);
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void travel(Vec3 travelVector) {
        if (this.isControlledByLocalInstance() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(travelVector);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        LivingEntity entity;
        ItemStack weapon;
        ItemEnchantments enchantments;
        Entity attacker = source.getEntity();
        if (source.is(TagRegistry.BYPASSES_BOO_INVULNERABILITY)) {
            return super.hurt(source, amount);
        }
        if (source.getDirectEntity() instanceof SpectralArrow) {
            return super.hurt(source, amount);
        }
        if (this.level().getBrightness(LightLayer.BLOCK, this.blockPosition()) >= (Integer)ConfigRegistry.BOO_LIGHT_SENSITIVITY.get()) {
            return super.hurt(source, amount);
        }
        if (attacker instanceof LivingEntity && (enchantments = (ItemEnchantments)(weapon = (entity = (LivingEntity)attacker).getMainHandItem()).get(DataComponents.ENCHANTMENTS)) != null) {
            for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                int level;
                Holder holder = (Holder)entry.getKey();
                if (!holder.is(TagRegistry.BYPASSES_BOO_INVULNERABILITY_ENCHANTS) || (level = entry.getIntValue()) <= 0) continue;
                return super.hurt(source, amount);
            }
        }
        return false;
    }

    public void die(DamageSource source) {
        this.playDeathAnimation((Entity)this);
        super.die(source);
    }

    public boolean canTakeItem(ItemStack stack) {
        EquipmentSlot equipmentslot = this.getEquipmentSlotForItem(stack);
        return this.getItemBySlot(equipmentslot).isEmpty();
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(random, difficulty);
        float f = random.nextFloat();
        float f2 = this.level().getDifficulty() == Difficulty.HARD ? 0.05f : 0.01f;
        if (f < f2) {
            int i = random.nextInt(3);
            if (i == 0) {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_SWORD));
            } else {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.STONE_SWORD));
            }
        }
        if (random.nextFloat() < 0.05f && this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.DIAMOND_HELMET));
        } else if (random.nextFloat() < 0.15f && this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.IRON_HELMET));
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverWorld, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        int month;
        int day;
        LocalDate localDate;
        RandomSource random = serverWorld.getRandom();
        this.populateDefaultEquipmentSlots(random, difficulty);
        this.populateDefaultEquipmentEnchantments(serverWorld, random, difficulty);
        if (this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            localDate = LocalDate.now();
            day = localDate.getDayOfMonth();
            month = localDate.getMonth().getValue();
            boolean isChristmas = (month == 12 && day >= 24 || month == 1 && day <= 6) && (Boolean)ConfigRegistry.DISABLE_CHRISTMAS_HATS.get() == false;
            boolean forceHats = (Boolean)ConfigRegistry.FORCE_CHRISTMAS_HATS.get();
            if (isChristmas || forceHats) {
                boolean appliedHat = false;
                if (random.nextFloat() < 0.4f) {
                    ItemStack hat = new ItemStack((ItemLike)ItemRegistry.CHRISTMAS_HAT.get());
                    this.setItemSlot(EquipmentSlot.HEAD, hat);
                    appliedHat = true;
                }
                if (appliedHat) {
                    this.armorDropChances[EquipmentSlot.HEAD.getIndex()] = 0.25f;
                }
            }
        }
        if (this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            localDate = LocalDate.now();
            day = localDate.getDayOfMonth();
            month = localDate.getMonth().getValue();
            List players = serverWorld.getLevel().players();
            boolean isHalloween = month == 10 && day >= 30 && (Boolean)ConfigRegistry.DISABLE_MOB_MASKS.get() == false;
            boolean forceMasks = (Boolean)ConfigRegistry.FORCE_MOB_MASKS.get();
            Optional<Item> randomMask = BuiltInRegistries.ITEM.getTag(TagRegistry.HALLOWEEN_MASKS).flatMap(tag -> tag.getRandomElement(random)).map(Holder::value);
            if (isHalloween || forceMasks) {
                ArrayList skulls;
                boolean appliedMask = false;
                if (random.nextFloat() < 0.25f) {
                    randomMask.ifPresent(item -> this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)item)));
                    appliedMask = this.getItemBySlot(EquipmentSlot.HEAD).is(TagRegistry.HALLOWEEN_MASKS);
                }
                if (random.nextFloat() < 0.15f) {
                    skulls = new ArrayList();
                    serverWorld.registryAccess().registryOrThrow(Registries.ITEM).getTagOrEmpty(ItemTags.SKULLS).forEach(holder -> {
                        Item item = (Item)holder.value();
                        skulls.add(new ItemStack((ItemLike)item));
                    });
                    if (!skulls.isEmpty()) {
                        ItemStack randomSkull = (ItemStack)skulls.get(random.nextInt(skulls.size()));
                        if (randomSkull.getItem() instanceof PlayerHeadItem && !players.isEmpty()) {
                            ServerPlayer randomPlayer = (ServerPlayer)players.get(random.nextInt(players.size()));
                            GameProfile playerProfile = randomPlayer.getGameProfile();
                            ItemStack playerHead = new ItemStack((ItemLike)Items.PLAYER_HEAD);
                            playerHead.set(DataComponents.PROFILE, (Object)new ResolvableProfile(playerProfile));
                            this.setItemSlot(EquipmentSlot.HEAD, playerHead);
                        } else {
                            this.setItemSlot(EquipmentSlot.HEAD, randomSkull);
                        }
                        appliedMask = true;
                    }
                }
                if (random.nextFloat() < 0.1f && !players.isEmpty()) {
                    ServerPlayer randomPlayer = (ServerPlayer)players.get(random.nextInt(players.size()));
                    GameProfile playerProfile = randomPlayer.getGameProfile();
                    SkullBlockEntity.fetchGameProfile((UUID)randomPlayer.getUUID());
                    ItemStack playerHeadItem = new ItemStack((ItemLike)Items.PLAYER_HEAD);
                    playerHeadItem.set(DataComponents.PROFILE, (Object)new ResolvableProfile(playerProfile));
                    this.setItemSlot(EquipmentSlot.HEAD, playerHeadItem);
                    appliedMask = true;
                }
                if (random.nextFloat() < 0.05f) {
                    skulls = new ArrayList();
                    serverWorld.registryAccess().registryOrThrow(Registries.BLOCK).getTagOrEmpty(CompatRegistry.TF_TROPHIES).forEach(holder -> skulls.add(new ItemStack((ItemLike)holder.value())));
                    if (!skulls.isEmpty()) {
                        ItemStack randomTrophy = (ItemStack)skulls.get(random.nextInt(skulls.size()));
                        this.setItemSlot(EquipmentSlot.HEAD, randomTrophy);
                        appliedMask = true;
                    }
                }
                if (appliedMask) {
                    this.armorDropChances[EquipmentSlot.HEAD.getIndex()] = 0.0f;
                }
            }
        }
        return super.finalizeSpawn(serverWorld, difficulty, spawnType, groupData);
    }

    public static boolean checkBooSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor serverWorld, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return serverWorld.getDifficulty() != Difficulty.PEACEFUL && (MobSpawnType.ignoresLightRequirements((MobSpawnType)spawnType) || BooEntity.isDarkEnoughToSpawn((ServerLevelAccessor)serverWorld, (BlockPos)pos, (RandomSource)random)) && BooEntity.checkMobSpawnRules(entityType, (LevelAccessor)serverWorld, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPos pos) {
        this.boundOrigin = pos;
    }

    protected void handleAirSupply(int airSupplyAmount) {
        if (this.isAlive() && this.isInWaterOrBubble()) {
            this.setAirSupply(airSupplyAmount);
        }
    }

    @NotNull
    public ParticleOptions getDeathParticle() {
        return ParticleTypes.POOF;
    }

    public void playDeathAnimation(Entity entity) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            ServerParticleUtils.spawnParticlesOnEntityRandomly(this.getDeathParticle(), serverWorld, entity, 0.0, 15);
        }
    }
}

