/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities;

import com.mojang.authlib.GameProfile;
import com.wenxin2.marioverse.entities.ai.controls.AmphibiousMoveControl;
import com.wenxin2.marioverse.entities.ai.goals.GoombaRideGoal;
import com.wenxin2.marioverse.entities.ai.goals.GoombaSitGoal;
import com.wenxin2.marioverse.entities.ai.goals.GoombaSleepGoal;
import com.wenxin2.marioverse.entities.ai.goals.LookAtTagGoal;
import com.wenxin2.marioverse.entities.ai.goals.NearestAttackableTagGoal;
import com.wenxin2.marioverse.integration.CompatRegistry;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DamageTypeRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.ItemRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.EquipableCarvedPumpkinBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GoombaEntity
extends Monster
implements GeoEntity {
    private static final EntityDataAccessor<Byte> DATA_ID_RIDE_FLAGS = SynchedEntityData.defineId(GoombaEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> DATA_ID_SCARE_FLAGS = SynchedEntityData.defineId(GoombaEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> DATA_ID_SIT_FLAGS = SynchedEntityData.defineId(GoombaEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> DATA_ID_SLEEP_FLAGS = SynchedEntityData.defineId(GoombaEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final RawAnimation DEATH_ANIM = RawAnimation.begin().thenPlayAndHold("goomba.death");
    public static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("goomba.idle");
    public static final RawAnimation IDLE_SWIM_ANIM = RawAnimation.begin().thenLoop("goomba.idle_swim");
    public static final RawAnimation RUN_ANIM = RawAnimation.begin().thenLoop("goomba.run");
    public static final RawAnimation SCARE_ANIM = RawAnimation.begin().thenLoop("goomba.scared");
    public static final RawAnimation SIT_ANIM = RawAnimation.begin().thenLoop("goomba.sit");
    public static final RawAnimation SLEEP_ANIM = RawAnimation.begin().thenLoop("goomba.sleep");
    public static final RawAnimation SQUASH_ANIM = RawAnimation.begin().thenPlayAndHold("goomba.squash");
    public static final RawAnimation SWIM_ANIM = RawAnimation.begin().thenLoop("goomba.swim");
    public static final RawAnimation SWIM_SQUASH_ANIM = RawAnimation.begin().thenPlayAndHold("goomba.swim_squash");
    public static final RawAnimation WALK_ANIM = RawAnimation.begin().thenLoop("goomba.walk");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public boolean wasSleeping;
    private int scareDuration = 0;
    private int scareTime = 0;

    public GoombaEntity(EntityType<? extends GoombaEntity> type, Level world) {
        super(type, world);
        this.setPathfindingMalus(PathType.DOOR_OPEN, 1.0f);
        this.setPathfindingMalus(PathType.WATER, 2.0f);
        this.moveControl = new AmphibiousMoveControl((PathfinderMob)this, 85, 10, 0.6f, 1.0f, true);
        this.xpReward = 3;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.GOOMBA_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return null;
    }

    public void die(DamageSource source) {
        if (source.is(DamageTypeRegistry.STOMP) || source.is(DamageTypeRegistry.PLAYER_STOMP)) {
            this.playSound(this.getStompSound());
        } else if (source.is(DamageTypeRegistry.MINI_GOOMBA_DEFEATED) || source.is(DamageTypeRegistry.PLAYER_MINI_GOOMBA_DEFEATED)) {
            this.playSound((SoundEvent)SoundRegistry.MINI_GOOMBA_DEFEATED.get());
        } else {
            this.playSound((SoundEvent)SoundRegistry.GOOMBA_DEATH.get());
        }
        super.die(source);
    }

    @NotNull
    public SoundEvent getStompSound() {
        return (SoundEvent)SoundRegistry.GOOMBA_STOMP.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound((SoundEvent)SoundRegistry.GOOMBA_STEP.get(), 1.0f, 1.0f);
        super.playStepSound(pos, state);
    }

    protected SoundEvent getBumpSound() {
        return (SoundEvent)SoundRegistry.GOOMBA_BUMP.get();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.GOOMBA_AMBIENT.get();
    }

    public int getAmbientSoundInterval() {
        return 360;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_RIDE_FLAGS, (Object)0);
        builder.define(DATA_ID_SCARE_FLAGS, (Object)0);
        builder.define(DATA_ID_SIT_FLAGS, (Object)0);
        builder.define(DATA_ID_SLEEP_FLAGS, (Object)0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.6, false));
        this.goalSelector.addGoal(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.4));
        this.goalSelector.addGoal(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new LookAtTagGoal((Mob)this, TagRegistry.GOOMBA_CAN_ATTACK, 8.0f, 1.0f));
        this.goalSelector.addGoal(4, (Goal)new GoombaSitGoal(this, 0.25f, 1200, 3000, 300));
        this.goalSelector.addGoal(5, (Goal)new GoombaSleepGoal(this, 0.1f, 2400, 6000));
        this.goalSelector.addGoal(6, (Goal)new GoombaRideGoal(this, 0.01f));
        this.targetSelector.addGoal(0, (Goal)new NearestAttackableTagGoal((Mob)this, TagRegistry.GOOMBA_CAN_ATTACK, true));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Death", 5, this::squashAnimController));
        controllers.add(new AnimationController((GeoAnimatable)this, "Idle", 5, this::walkAnimController));
        controllers.add(new AnimationController((GeoAnimatable)this, "Run", 5, this::walkAnimController));
        controllers.add(new AnimationController((GeoAnimatable)this, "Scare", 5, this::scareAnimController));
        controllers.add(new AnimationController((GeoAnimatable)this, "Squash", 5, this::squashAnimController));
        controllers.add(new AnimationController((GeoAnimatable)this, "Swim", 15, this::walkAnimController));
        controllers.add(new AnimationController((GeoAnimatable)this, "Walk", 5, this::walkAnimController));
        controllers.add(DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)DefaultAnimations.ATTACK_BITE).transitionLength(1));
        controllers.add(DefaultAnimations.genericWalkController((GeoAnimatable)this));
    }

    protected <E extends GeoAnimatable> PlayState walkAnimController(AnimationState<E> event) {
        if ((this.isSitting() || this.isPassenger() && !(this.getVehicle() instanceof LivingEntity)) && !this.isScared()) {
            event.setAndContinue(SIT_ANIM);
            return PlayState.CONTINUE;
        }
        if (this.isSleeping() && !this.isScared()) {
            event.setAndContinue(SLEEP_ANIM);
            return PlayState.CONTINUE;
        }
        if (this.isInWaterOrBubble()) {
            if (!this.isRunning() && !this.isWalking()) {
                event.setAndContinue(IDLE_SWIM_ANIM);
            } else {
                event.setAndContinue(SWIM_ANIM);
            }
            return PlayState.CONTINUE;
        }
        if (this.isRunning() && !this.isScared()) {
            event.setAndContinue(RUN_ANIM);
            return PlayState.CONTINUE;
        }
        if (event.isMoving() && !this.isScared()) {
            event.setAndContinue(WALK_ANIM);
            return PlayState.CONTINUE;
        }
        if (this.isScared()) {
            event.setAndContinue(SCARE_ANIM);
            return PlayState.CONTINUE;
        }
        event.setAndContinue(IDLE_ANIM);
        return PlayState.CONTINUE;
    }

    protected <E extends GeoAnimatable> PlayState squashAnimController(AnimationState<E> event) {
        if (this.dead) {
            if (this.getLastDamageSource() != null && (this.getLastDamageSource().is(DamageTypeRegistry.STOMP) || this.getLastDamageSource().is(DamageTypeRegistry.PLAYER_STOMP))) {
                if (this.isInWaterOrBubble()) {
                    if (!this.isRunning() && !this.isWalking()) {
                        event.setAndContinue(SQUASH_ANIM);
                    } else {
                        event.setAndContinue(SWIM_SQUASH_ANIM);
                    }
                } else {
                    event.setAndContinue(SQUASH_ANIM);
                }
                return PlayState.CONTINUE;
            }
            event.setAndContinue(DEATH_ANIM);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    protected <E extends GeoAnimatable> PlayState scareAnimController(AnimationState<E> event) {
        if (this.isScared()) {
            event.setAndContinue(SCARE_ANIM);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(DATA_ID_RIDE_FLAGS, (Object)tag.getByte("RideFlags"));
        this.entityData.set(DATA_ID_SCARE_FLAGS, (Object)tag.getByte("ScareFlags"));
        this.entityData.set(DATA_ID_SIT_FLAGS, (Object)tag.getByte("SitFlags"));
        this.entityData.set(DATA_ID_SLEEP_FLAGS, (Object)tag.getByte("SleepFlags"));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putByte("RideFlags", ((Byte)this.entityData.get(DATA_ID_RIDE_FLAGS)).byteValue());
        tag.putByte("ScareFlags", ((Byte)this.entityData.get(DATA_ID_SCARE_FLAGS)).byteValue());
        tag.putByte("SitFlags", ((Byte)this.entityData.get(DATA_ID_SIT_FLAGS)).byteValue());
        tag.putByte("SleepFlags", ((Byte)this.entityData.get(DATA_ID_SLEEP_FLAGS)).byteValue());
    }

    public boolean isSitting() {
        return this.getSitFlag(8);
    }

    public boolean isSleeping() {
        return this.getSleepFlag(12);
    }

    public boolean isScared() {
        return this.getScareFlag(9);
    }

    public boolean isWalking() {
        return this.getDeltaMovement().horizontalDistance() >= 0.01 && this.getDeltaMovement().horizontalDistance() < 0.5 || this.goalSelector.getAvailableGoals().stream().anyMatch(goal -> goal.isRunning() && goal.getGoal() instanceof RandomStrollGoal || this.walkDist > 0.0f);
    }

    private boolean isRunning() {
        return this.isSprinting() || (double)this.getSpeed() >= 0.5 || this.getDeltaMovement().horizontalDistance() >= 0.5 || this.goalSelector.getAvailableGoals().stream().anyMatch(goal -> goal.isRunning() && goal.getGoal() instanceof MeleeAttackGoal) || this.targetSelector.getAvailableGoals().stream().anyMatch(goal -> goal.isRunning() && goal.getGoal() instanceof NearestAttackableTargetGoal);
    }

    public void tick() {
        super.tick();
        if (this.isScared()) {
            float scaleFactor = this.getBbHeight() * this.getBbWidth();
            int numParticles = (int)(scaleFactor * 5.0f);
            double radius = this.getBbWidth() / 2.0f;
            for (int i = 0; i < numParticles; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)numParticles;
                double offsetX = Math.cos(angle) * radius;
                double offsetY = this.getBbHeight();
                double offsetZ = Math.sin(angle) * radius;
                double x = this.getX() + offsetX;
                double y = this.getY();
                double z = this.getZ() + offsetZ;
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, this.getBlockStateOn()), x, y, z, 0.0, 0.0, 0.0);
            }
        }
        if (this.isScared()) {
            if (this.scareTime == 0) {
                this.scareDuration = 25 + this.random.nextInt(50);
            }
            if (this.scareTime > this.scareDuration) {
                this.scare(Boolean.FALSE);
                this.sit(Boolean.FALSE);
                this.sleep(Boolean.FALSE);
                this.scareTime = 0;
            }
            ++this.scareTime;
        }
        if (this.isSleeping() || this.isSitting()) {
            this.checkForCollisionsAndWakeUp();
        }
        if (this.isInWaterOrBubble()) {
            this.ejectPassengers();
        }
    }

    public void baseTick() {
        int i = this.getAirSupply();
        super.baseTick();
        this.handleAirSupply(i);
        if (this.getTarget() != null) {
            this.setSpeed(0.8f);
        }
    }

    public void travel(Vec3 travelVector) {
        if (this.isControlledByLocalInstance() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(travelVector);
        }
    }

    protected PathNavigation createNavigation(Level world) {
        return new AmphibiousPathNavigation((Mob)this, world);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(random, difficulty);
        GoombaEntity goombaEntity = this;
        if (goombaEntity instanceof AbilitiesHandler) {
            AbilitiesHandler handler = (AbilitiesHandler)((Object)goombaEntity);
            float f = random.nextFloat();
            float f2 = this.level().getDifficulty() == Difficulty.HARD ? 0.05f : 0.01f;
            if (f < f2) {
                int i = random.nextInt(6);
                int randomInt = random.nextInt(1);
                if (i == 0) {
                    if (randomInt == 0) {
                        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)ItemRegistry.MARIO_FIRE_HAT.get()));
                    } else {
                        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)ItemRegistry.LUIGI_FIRE_HAT.get()));
                    }
                    handler.mv$setFireFlower(true);
                } else if (i == 1) {
                    if (randomInt == 0) {
                        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)ItemRegistry.MARIO_ICE_HAT.get()));
                    } else {
                        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)ItemRegistry.LUIGI_ICE_HAT.get()));
                    }
                    handler.mv$setIceFlower(true);
                } else {
                    this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.DIAMOND_HELMET));
                }
            }
        }
    }

    public boolean canTakeItem(ItemStack stack) {
        EquipmentSlot equipmentslot = this.getEquipmentSlotForItem(stack);
        return this.getItemBySlot(equipmentslot).isEmpty();
    }

    @NotNull
    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        BlockItem blockItem;
        Item item;
        if (this.getItemBySlot(EquipmentSlot.HEAD).isEmpty() && (player.getItemInHand(hand).getItem() instanceof ArmorItem || (item = player.getItemInHand(hand).getItem()) instanceof BlockItem && ((blockItem = (BlockItem)item).getBlock() instanceof SkullBlock || blockItem.getBlock() instanceof EquipableCarvedPumpkinBlock))) {
            this.equipItemIfPossible(player.getItemInHand(hand));
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverWorld, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        LocalDate localDate;
        RandomSource random = serverWorld.getRandom();
        this.populateDefaultEquipmentSlots(random, difficulty);
        this.populateDefaultEquipmentEnchantments(serverWorld, random, difficulty);
        if (groupData instanceof GoombaGroupData) {
            GoombaGroupData goombaGroupData = (GoombaGroupData)groupData;
            if (goombaGroupData.canSpawnJockey) {
                EntityType entityType;
                Mob mob;
                Optional randomEntityHolder;
                if (random.nextDouble() < 0.05) {
                    List nearbyEntities = serverWorld.getEntitiesOfClass(Mob.class, this.getBoundingBox().inflate(5.0, 3.0, 5.0), entity -> entity.getType().is(TagRegistry.GOOMBA_CAN_RIDE) && !entity.isVehicle());
                    if (!nearbyEntities.isEmpty()) {
                        Mob mob2 = (Mob)nearbyEntities.getFirst();
                        this.startRiding((Entity)mob2);
                    }
                } else if (random.nextDouble() < 0.05 && (randomEntityHolder = serverWorld.registryAccess().registryOrThrow(Registries.ENTITY_TYPE).getTag(TagRegistry.GOOMBA_CAN_RIDE).flatMap(tag -> tag.getRandomElement(random))).isPresent() && (mob = (Mob)(entityType = (EntityType)((Holder)randomEntityHolder.get()).value()).create(this.level())) != null) {
                    mob.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                    mob.finalizeSpawn(serverWorld, difficulty, MobSpawnType.JOCKEY, null);
                    this.startRiding((Entity)mob);
                    serverWorld.addFreshEntity((Entity)mob);
                }
            }
        }
        if (this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            localDate = LocalDate.now();
            int day = localDate.getDayOfMonth();
            int month = localDate.getMonth().getValue();
            boolean isChristmas = (month == 12 && day >= 24 || month == 1 && day <= 6) && (Boolean)ConfigRegistry.DISABLE_CHRISTMAS_HATS.get() == false;
            boolean forceHats = (Boolean)ConfigRegistry.FORCE_CHRISTMAS_HATS.get();
            if (isChristmas || forceHats) {
                boolean appliedHat = false;
                if (random.nextFloat() < 0.4f) {
                    ItemStack hat = new ItemStack((ItemLike)ItemRegistry.CHRISTMAS_HAT.get());
                    this.setItemSlot(EquipmentSlot.HEAD, hat);
                    appliedHat = true;
                }
                if (appliedHat) {
                    this.armorDropChances[EquipmentSlot.HEAD.getIndex()] = 0.25f;
                }
            }
        }
        if (this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            localDate = LocalDate.now();
            int day = localDate.getDayOfMonth();
            int month = localDate.getMonth().getValue();
            List players = serverWorld.getLevel().players();
            boolean isHalloween = month == 10 && day >= 30 && (Boolean)ConfigRegistry.DISABLE_MOB_MASKS.get() == false;
            boolean forceMasks = (Boolean)ConfigRegistry.FORCE_MOB_MASKS.get();
            Optional<Item> randomMask = BuiltInRegistries.ITEM.getTag(TagRegistry.HALLOWEEN_MASKS).flatMap(tag -> tag.getRandomElement(random)).map(Holder::value);
            if (isHalloween || forceMasks) {
                ArrayList skulls;
                boolean appliedMask = false;
                if (random.nextFloat() < 0.25f) {
                    randomMask.ifPresent(item -> this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)item)));
                    appliedMask = this.getItemBySlot(EquipmentSlot.HEAD).is(TagRegistry.HALLOWEEN_MASKS);
                }
                if (random.nextFloat() < 0.15f) {
                    skulls = new ArrayList();
                    serverWorld.registryAccess().registryOrThrow(Registries.ITEM).getTagOrEmpty(ItemTags.SKULLS).forEach(holder -> {
                        Item item = (Item)holder.value();
                        skulls.add(new ItemStack((ItemLike)item));
                    });
                    if (!skulls.isEmpty()) {
                        ItemStack randomSkull = (ItemStack)skulls.get(random.nextInt(skulls.size()));
                        if (randomSkull.getItem() instanceof PlayerHeadItem && !players.isEmpty()) {
                            ServerPlayer randomPlayer = (ServerPlayer)players.get(random.nextInt(players.size()));
                            GameProfile playerProfile = randomPlayer.getGameProfile();
                            ItemStack playerHead = new ItemStack((ItemLike)Items.PLAYER_HEAD);
                            playerHead.set(DataComponents.PROFILE, (Object)new ResolvableProfile(playerProfile));
                            this.setItemSlot(EquipmentSlot.HEAD, playerHead);
                        } else {
                            this.setItemSlot(EquipmentSlot.HEAD, randomSkull);
                        }
                        appliedMask = true;
                    }
                }
                if (random.nextFloat() < 0.1f && !players.isEmpty()) {
                    ServerPlayer randomPlayer = (ServerPlayer)players.get(random.nextInt(players.size()));
                    GameProfile playerProfile = randomPlayer.getGameProfile();
                    SkullBlockEntity.fetchGameProfile((UUID)randomPlayer.getUUID());
                    ItemStack playerHeadItem = new ItemStack((ItemLike)Items.PLAYER_HEAD);
                    playerHeadItem.set(DataComponents.PROFILE, (Object)new ResolvableProfile(playerProfile));
                    this.setItemSlot(EquipmentSlot.HEAD, playerHeadItem);
                    appliedMask = true;
                }
                if (random.nextFloat() < 0.05f) {
                    skulls = new ArrayList();
                    serverWorld.registryAccess().registryOrThrow(Registries.BLOCK).getTagOrEmpty(CompatRegistry.TF_TROPHIES).forEach(holder -> skulls.add(new ItemStack((ItemLike)holder.value())));
                    if (!skulls.isEmpty()) {
                        ItemStack randomTrophy = (ItemStack)skulls.get(random.nextInt(skulls.size()));
                        this.setItemSlot(EquipmentSlot.HEAD, randomTrophy);
                        appliedMask = true;
                    }
                }
                if (appliedMask) {
                    this.armorDropChances[EquipmentSlot.HEAD.getIndex()] = 0.0f;
                }
            }
        }
        return super.finalizeSpawn(serverWorld, difficulty, spawnType, groupData);
    }

    public static boolean checkGoombaSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor serverWorld, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return serverWorld.getDifficulty() != Difficulty.PEACEFUL && (MobSpawnType.ignoresLightRequirements((MobSpawnType)spawnType) || GoombaEntity.isDarkEnoughToSpawn((ServerLevelAccessor)serverWorld, (BlockPos)pos, (RandomSource)random)) && GoombaEntity.checkMobSpawnRules(entityType, (LevelAccessor)serverWorld, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    @NotNull
    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float height) {
        return new Vec3(0.0, (double)this.getBbHeight() - 0.1, 0.0);
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean wasHurt = super.hurt(source, amount);
        if (wasHurt && (this.isSitting() || this.isSleeping())) {
            this.sit(Boolean.FALSE);
            this.sleep(Boolean.FALSE);
            this.scare(Boolean.TRUE);
        }
        return wasHurt;
    }

    public boolean checkSpawnObstruction(LevelReader worldReader) {
        return worldReader.isUnobstructed((Entity)this);
    }

    protected void handleAirSupply(int airSupplyAmount) {
        if (this.isAlive() && this.isInWaterOrBubble()) {
            this.setAirSupply(airSupplyAmount);
        }
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean canBeLeashed() {
        return true;
    }

    public void checkForCollisionsAndWakeUp() {
        block2: {
            Iterator iterator;
            List nearbyEntities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.25, 0.0, 0.25), entity -> !entity.isSpectator() && entity instanceof LivingEntity && !(entity instanceof GoombaEntity));
            if (nearbyEntities.isEmpty() || !(iterator = nearbyEntities.iterator()).hasNext()) break block2;
            Entity collidingEntity = (Entity)iterator.next();
            if (!this.isSleeping() && !this.isSitting() || collidingEntity.getY() >= this.getY() + (double)this.getEyeHeight() || !(collidingEntity.getDeltaMovement().horizontalDistance() > 0.1)) {
                return;
            }
            if (((Boolean)collidingEntity.getData(DataAttachmentRegistry.HAS_SUPER_STAR)).booleanValue()) {
                return;
            }
            Vec3 knockbackDirection = new Vec3(collidingEntity.getX() - this.getX(), 0.4, collidingEntity.getZ() - this.getZ()).normalize();
            double knockbackStrength = 1.0;
            this.setDeltaMovement(-knockbackDirection.x * knockbackStrength, 0.4, -knockbackDirection.z * knockbackStrength);
            this.hurtMarked = true;
            collidingEntity.setDeltaMovement(knockbackDirection.x * knockbackStrength, 0.4, knockbackDirection.z * knockbackStrength);
            collidingEntity.hurtMarked = true;
            this.playSound(this.getBumpSound());
            this.tryToScare();
        }
    }

    public void sit(boolean isSitting) {
        this.setSitFlag(8, isSitting);
    }

    private boolean getSitFlag(int i) {
        return ((Byte)this.entityData.get(DATA_ID_SIT_FLAGS) & i) != 0;
    }

    public void tryToSit() {
        if (!this.isInWaterOrBubble()) {
            this.sit(Boolean.TRUE);
            this.stopInPlace();
        }
    }

    private void setSitFlag(int i, boolean b) {
        byte b0 = (Byte)this.entityData.get(DATA_ID_SIT_FLAGS);
        if (b) {
            this.entityData.set(DATA_ID_SIT_FLAGS, (Object)((byte)(b0 | i)));
        } else {
            this.entityData.set(DATA_ID_SIT_FLAGS, (Object)((byte)(b0 & ~i)));
        }
    }

    public void sleep(boolean isSleeping) {
        this.setSleepFlag(12, isSleeping);
    }

    private boolean getSleepFlag(int i) {
        return ((Byte)this.entityData.get(DATA_ID_SLEEP_FLAGS) & i) != 0;
    }

    public void tryToSleep() {
        if (!this.isInWaterOrBubble()) {
            this.sit(Boolean.FALSE);
            this.sleep(Boolean.TRUE);
            this.stopInPlace();
        }
    }

    private void setSleepFlag(int i, boolean b) {
        byte b1 = (Byte)this.entityData.get(DATA_ID_SLEEP_FLAGS);
        if (b) {
            this.entityData.set(DATA_ID_SLEEP_FLAGS, (Object)((byte)(b1 | i)));
        } else {
            this.entityData.set(DATA_ID_SLEEP_FLAGS, (Object)((byte)(b1 & ~i)));
        }
    }

    public boolean wasSleeping() {
        return this.wasSleeping;
    }

    public void setWasSleeping(boolean wasSleeping) {
        this.wasSleeping = wasSleeping;
    }

    public void scare(boolean isScared) {
        this.setScareFlag(9, isScared);
    }

    private boolean getScareFlag(int i) {
        return ((Byte)this.entityData.get(DATA_ID_SCARE_FLAGS) & i) != 0;
    }

    public void tryToScare() {
        if (!this.isInWaterOrBubble()) {
            this.sit(Boolean.FALSE);
            this.sleep(Boolean.FALSE);
            this.scare(Boolean.TRUE);
            this.stopInPlace();
        }
    }

    private void setScareFlag(int i, boolean b) {
        byte b1 = (Byte)this.entityData.get(DATA_ID_SCARE_FLAGS);
        if (b) {
            this.entityData.set(DATA_ID_SCARE_FLAGS, (Object)((byte)(b1 | i)));
        } else {
            this.entityData.set(DATA_ID_SCARE_FLAGS, (Object)((byte)(b1 & ~i)));
        }
    }

    public void ride(boolean isRiding) {
        this.setRideFlag(10, isRiding);
    }

    public void tryToRide() {
        if (!this.isInWaterOrBubble() && !this.isPassenger()) {
            this.stopInPlace();
        }
    }

    private void setRideFlag(int i, boolean b) {
        byte b1 = (Byte)this.entityData.get(DATA_ID_SCARE_FLAGS);
        if (b) {
            this.entityData.set(DATA_ID_SCARE_FLAGS, (Object)((byte)(b1 | i)));
        } else {
            this.entityData.set(DATA_ID_SCARE_FLAGS, (Object)((byte)(b1 & ~i)));
        }
    }

    public static class GoombaGroupData
    implements SpawnGroupData {
        public final boolean canSpawnJockey;

        public GoombaGroupData(boolean canSpawnJockey) {
            this.canSpawnJockey = canSpawnJockey;
        }
    }
}

