/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities;

import com.wenxin2.marioverse.entities.PokeyBodyEntity;
import com.wenxin2.marioverse.entities.PokeyEntity;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DamageSourceRegistry;
import com.wenxin2.marioverse.registries.EntityRegistry;
import com.wenxin2.marioverse.registries.ItemRegistry;
import com.wenxin2.marioverse.registries.ParticleRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;

public class SnowPokeyBodyEntity
extends PokeyBodyEntity
implements GeoEntity,
NeutralMob {
    public SnowPokeyBodyEntity(EntityType<? extends SnowPokeyBodyEntity> type, Level world) {
        super((EntityType<? extends PokeyBodyEntity>)type, world);
        this.setPathfindingMalus(PathType.DOOR_OPEN, 1.0f);
        this.xpReward = 2;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.SNOW_GOLEM_HURT;
    }

    @Override
    public TagKey<EntityType<?>> getCanAttackTag() {
        return TagRegistry.SNOW_POKEY_CAN_ATTACK;
    }

    @Override
    public PokeyEntity getPokeyHeadEntity() {
        return (PokeyEntity)((EntityType)EntityRegistry.SNOW_POKEY.get()).create(this.level());
    }

    @Override
    public PokeyBodyEntity getPokeyBodyEntity() {
        return (PokeyBodyEntity)((EntityType)EntityRegistry.SNOW_POKEY_BODY.get()).create(this.level());
    }

    @Override
    @NotNull
    public Integer getMaxHeightConfig() {
        return (Integer)ConfigRegistry.MAX_SNOW_POKEY_HEIGHT.get();
    }

    @Override
    @Nullable
    public ItemStack getPickedResult(@NotNull HitResult target) {
        return new ItemStack((ItemLike)ItemRegistry.SNOW_POKEY_SPAWN_EGG.get());
    }

    @Override
    @NotNull
    public DamageSource getDamageSource(Entity collidingEntity) {
        return DamageSourceRegistry.snowPokeyThorns(collidingEntity);
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            if (!EventHooks.canEntityGrief((Level)this.level(), (Entity)this)) {
                return;
            }
            BlockState blockstate = Blocks.SNOW.defaultBlockState();
            for (int i = 0; i < 4; ++i) {
                int j = Mth.floor((double)(this.getX() + (double)((float)(i % 2 * 2 - 1) * 0.25f)));
                int k = Mth.floor((double)this.getY());
                int l = Mth.floor((double)(this.getZ() + (double)((float)(i / 2 % 2 * 2 - 1) * 0.25f)));
                BlockPos blockpos = new BlockPos(j, k, l);
                if (!this.level().getBlockState(blockpos).isAir() || !blockstate.canSurvive((LevelReader)this.level(), blockpos)) continue;
                this.level().setBlockAndUpdate(blockpos, blockstate);
                this.level().gameEvent((Holder)GameEvent.BLOCK_PLACE, blockpos, GameEvent.Context.of((Entity)this, (BlockState)blockstate));
            }
        }
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime >= 20 && !this.level().isClientSide() && !this.isRemoved()) {
            this.remove(Entity.RemovalReason.KILLED);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)level;
                ServerParticleUtils.spawnParticlesOnEntityRandomly((ParticleOptions)ParticleTypes.SNOWFLAKE, serverWorld, (Entity)this, 0.0, 35);
                ServerParticleUtils.spawnParticlesOnEntityRandomly((ParticleOptions)ParticleRegistry.ICE_STAR.get(), serverWorld, (Entity)this, 0.0, 15);
            }
        }
    }
}

