/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities.power_ups;

import com.wenxin2.marioverse.entities.ai.goals.ContinuousStrollGoal;
import com.wenxin2.marioverse.entities.power_ups.BaseMushroomEntity;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MushroomEntity
extends BaseMushroomEntity
implements GeoEntity {
    protected static final RawAnimation WALK_ANIM = RawAnimation.begin().thenLoop("animation.super_mushroom.walk");
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public MushroomEntity(EntityType<? extends MushroomEntity> entityType, Level world) {
        super(entityType, world);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new ContinuousStrollGoal(this, 0.7));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Walk", 0, this::walkAnimController));
    }

    @Override
    protected <E extends GeoAnimatable> PlayState walkAnimController(AnimationState<E> event) {
        if (this.isMoving()) {
            event.setAndContinue(WALK_ANIM);
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    public void tick() {
        super.tick();
        this.checkForCollisions();
    }

    private boolean isMoving() {
        return this.getDeltaMovement().lengthSqr() > 0.01;
    }

    @Override
    public void checkForCollisions() {
        block0: {
            Iterator iterator;
            AABB boundingBox = this.getBoundingBox().inflate(0.1);
            List entities = this.level().getEntities((Entity)this, boundingBox, entity -> entity != this);
            if (entities.isEmpty() || !(iterator = entities.iterator()).hasNext()) break block0;
            Entity entity2 = (Entity)iterator.next();
            this.collideWithEntity(entity2);
        }
    }

    @Override
    public void collideWithEntity(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity instanceof AbilitiesHandler) {
                AbilitiesHandler handler = (AbilitiesHandler)entity;
                handler.applyMushroomPowerUp(this.level(), livingEntity, this, ((Double)ConfigRegistry.SUPER_MUSHROOM_HEALTH_HEALED.get()).floatValue());
            }
        }
    }
}

