/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.event_handlers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.wenxin2.marioverse.blocks.ClearWarpPipeBlock;
import com.wenxin2.marioverse.blocks.QuicksandBlock;
import com.wenxin2.marioverse.client.QuicksandOverlay;
import com.wenxin2.marioverse.client.RedQuicksandOverlay;
import com.wenxin2.marioverse.client.renderers.SuperStarRenderType;
import com.wenxin2.marioverse.registries.BlockRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.sounds.FadeInAndOutSoundInstance;
import com.wenxin2.marioverse.sounds.FadingSoundInstance;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="marioverse", value={Dist.CLIENT})
public class ClientEventHandlers {
    public static final Map<UUID, FadeInAndOutSoundInstance> ACTIVE_PIPE_SOUNDS = new HashMap<UUID, FadeInAndOutSoundInstance>();
    public static final ResourceLocation QUICKSAND_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/misc/quicksand_overlay.png");
    public static final ResourceLocation RED_QUICKSAND_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/misc/red_quicksand_overlay.png");
    public static final ResourceLocation SPLUNKIN_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/misc/splunkin_pumpkin_blur.png");

    @SubscribeEvent
    public static void registerShaders(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"super_star_shader"), DefaultVertexFormat.POSITION_TEX_COLOR), shader -> {
            SuperStarRenderType.SUPER_STAR_SHADER = shader;
        });
    }

    @SubscribeEvent
    public static void onClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            public void renderHelmetOverlay(ItemStack stack, Player player, GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
                ClientEventHandlers.renderCustomOverlay(guiGraphics, SPLUNKIN_OVERLAY, 1.0f);
            }
        }, new Item[]{((Block)BlockRegistry.SPLUNKIN_CARVED_PUMPKIN.get()).asItem()});
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        QuicksandOverlay.clientTick(Minecraft.getInstance());
        RedQuicksandOverlay.clientTick(Minecraft.getInstance());
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiLayerEvent.Pre event) {
        float redAlpha;
        GuiGraphics gui = event.getGuiGraphics();
        int w = gui.guiWidth();
        int h = gui.guiHeight();
        float alpha = QuicksandOverlay.getOverlayProgress();
        if (alpha > 0.001f) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            gui.blit(QUICKSAND_OVERLAY, 0, 0, 0.0f, 0.0f, w, h, w, h);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }
        if ((redAlpha = RedQuicksandOverlay.getOverlayProgress()) > 0.001f) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)redAlpha);
            gui.blit(RED_QUICKSAND_OVERLAY, 0, 0, 0.0f, 0.0f, w, h, w, h);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }
    }

    private static boolean isInQuicksand(Camera camera) {
        BlockPos pos = BlockPos.containing((Position)camera.getPosition());
        return !camera.getEntity().isSpectator() && camera.getEntity().level().getBlockState(pos).getBlock() instanceof QuicksandBlock;
    }

    @SubscribeEvent
    public static void onRenderFog(ViewportEvent.RenderFog event) {
        if (!ClientEventHandlers.isInQuicksand(event.getCamera())) {
            return;
        }
        event.setNearPlaneDistance(0.0f);
        event.setFarPlaneDistance(3.0f);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onFogColor(ViewportEvent.ComputeFogColor event) {
        BlockPos pos;
        Camera camera = event.getCamera();
        Level level = camera.getEntity().level();
        BlockState state = level.getBlockState(pos = BlockPos.containing((Position)camera.getPosition()));
        Block block = state.getBlock();
        if (!(block instanceof QuicksandBlock)) {
            return;
        }
        QuicksandBlock quicksand = (QuicksandBlock)block;
        int rgba = quicksand.getDustColor(state, (BlockGetter)level, pos);
        event.setRed((float)(rgba >> 16 & 0xFF) / 255.0f);
        event.setGreen((float)(rgba >> 8 & 0xFF) / 255.0f);
        event.setBlue((float)(rgba & 0xFF) / 255.0f);
    }

    @SubscribeEvent
    public static void onEntityRemoved(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        UUID uuid = entity.getUUID();
        if (!(event.getLevel() instanceof ClientLevel)) {
            return;
        }
        if (ACTIVE_PIPE_SOUNDS.get(uuid) != null) {
            ACTIVE_PIPE_SOUNDS.get(uuid).startFadeOut();
            entity.setData(DataAttachmentRegistry.PLAYED_INSIDE_PIPE_SOUND, (Object)false);
        }
    }

    @SubscribeEvent
    public static void postEntityTick(EntityTickEvent.Post event) {
        boolean isEntrance;
        Entity entity = event.getEntity();
        UUID uuid = entity.getUUID();
        Level world = entity.level();
        BlockPos pos = entity.blockPosition();
        BlockState state = world.getBlockState(pos);
        boolean inClearPipe = state.getBlock() instanceof ClearWarpPipeBlock;
        boolean bl = isEntrance = state.hasProperty((Property)ClearWarpPipeBlock.ENTRANCE) && (Boolean)state.getValue((Property)ClearWarpPipeBlock.ENTRANCE) != false;
        if (!(entity.level() instanceof ClientLevel)) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (((Boolean)entity.getData(DataAttachmentRegistry.HAS_SUPER_STAR)).booleanValue() && !((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_SUPER_STAR_THEME)).booleanValue()) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)new FadingSoundInstance(livingEntity, (SoundEvent)SoundRegistry.SUPER_STAR_THEME.get(), SoundSource.AMBIENT, entity.getRandom(), ((Integer)entity.getData(DataAttachmentRegistry.SUPER_STAR_COOLDOWN)).intValue(), 100.0f));
                entity.setData(DataAttachmentRegistry.PLAYED_SUPER_STAR_THEME, (Object)true);
            }
        }
        if (((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_EXIT_PIPE_SOUND)).booleanValue() && !((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_ENTER_PIPE_SOUND)).booleanValue() && inClearPipe && isEntrance) {
            entity.playSound((SoundEvent)SoundRegistry.CLEAR_PIPE_ENTER.get(), 1.0f, 1.0f);
            entity.setData(DataAttachmentRegistry.PLAYED_ENTER_PIPE_SOUND, (Object)true);
            entity.setData(DataAttachmentRegistry.PLAYED_EXIT_PIPE_SOUND, (Object)false);
        }
        if (((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_ENTER_PIPE_SOUND)).booleanValue() && !((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_EXIT_PIPE_SOUND)).booleanValue() && !inClearPipe) {
            entity.playSound((SoundEvent)SoundRegistry.CLEAR_PIPE_EXIT.get(), 1.0f, 1.0f);
            entity.setData(DataAttachmentRegistry.PLAYED_EXIT_PIPE_SOUND, (Object)true);
            entity.setData(DataAttachmentRegistry.PLAYED_ENTER_PIPE_SOUND, (Object)false);
        }
        if (((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_ENTER_PIPE_SOUND)).booleanValue() && !((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_EXIT_PIPE_SOUND)).booleanValue() && !((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_INSIDE_PIPE_SOUND)).booleanValue() && inClearPipe) {
            FadeInAndOutSoundInstance insideSound = new FadeInAndOutSoundInstance(entity, (SoundEvent)SoundRegistry.CLEAR_PIPE_INSIDE.get(), SoundSource.BLOCKS, 20.0f, 10.0f);
            ACTIVE_PIPE_SOUNDS.put(uuid, insideSound);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)insideSound);
            entity.setData(DataAttachmentRegistry.PLAYED_INSIDE_PIPE_SOUND, (Object)true);
        }
        if (((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_INSIDE_PIPE_SOUND)).booleanValue() && !inClearPipe) {
            FadeInAndOutSoundInstance active = ACTIVE_PIPE_SOUNDS.get(uuid);
            if (active != null) {
                active.startFadeOut();
            }
            ACTIVE_PIPE_SOUNDS.remove(uuid);
            entity.setData(DataAttachmentRegistry.PLAYED_INSIDE_PIPE_SOUND, (Object)false);
        }
    }

    private static void renderCustomOverlay(GuiGraphics guiGraphics, ResourceLocation texture, float alpha) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        guiGraphics.blit(texture, 0, 0, -90, 0.0f, 0.0f, guiGraphics.guiWidth(), guiGraphics.guiHeight(), guiGraphics.guiWidth(), guiGraphics.guiHeight());
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

