/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.event_handlers;

import com.wenxin2.marioverse.Marioverse;
import com.wenxin2.marioverse.blocks.CheckpointFlagBlock;
import com.wenxin2.marioverse.blocks.PottedPiranhaPlantBlock;
import com.wenxin2.marioverse.blocks.QuestionBlock;
import com.wenxin2.marioverse.blocks.WarpPipeBlock;
import com.wenxin2.marioverse.blocks.client.WarpPipeScreen;
import com.wenxin2.marioverse.blocks.entities.BaseWarpBlockEntity;
import com.wenxin2.marioverse.blocks.entities.CheckpointFlagBlockEntity;
import com.wenxin2.marioverse.blocks.entities.PottedPiranhaPlantBlockEntity;
import com.wenxin2.marioverse.blocks.entities.QuestionBlockEntity;
import com.wenxin2.marioverse.blocks.entities.WarpDoorBlockEntity;
import com.wenxin2.marioverse.blocks.entities.WarpPipeBlockEntity;
import com.wenxin2.marioverse.blocks.entities.WarpTrapDoorBlockEntity;
import com.wenxin2.marioverse.entities.FireGoombaEntity;
import com.wenxin2.marioverse.entities.IceCubeEntity;
import com.wenxin2.marioverse.entities.KoopaShellEntity;
import com.wenxin2.marioverse.entities.KoopaTroopaEntity;
import com.wenxin2.marioverse.entities.WarpLinkableEntity;
import com.wenxin2.marioverse.entities.ai.goals.ChaseTargetGoal;
import com.wenxin2.marioverse.entities.ai.goals.CollectBlockGoal;
import com.wenxin2.marioverse.entities.ai.goals.PickupAndThrowShellGoal;
import com.wenxin2.marioverse.entities.ai.goals.ShootBouncingFireballGoal;
import com.wenxin2.marioverse.entities.ai.goals.ShootBouncingIceBallGoal;
import com.wenxin2.marioverse.entities.power_ups.FireFlowerEntity;
import com.wenxin2.marioverse.entities.power_ups.IceFlowerEntity;
import com.wenxin2.marioverse.entities.power_ups.MushroomEntity;
import com.wenxin2.marioverse.entities.power_ups.OneUpMushroomEntity;
import com.wenxin2.marioverse.entities.power_ups.SuperStarEntity;
import com.wenxin2.marioverse.integration.SupplementariesCompat;
import com.wenxin2.marioverse.items.LinkerItem;
import com.wenxin2.marioverse.items.PiranhaPlantPodItem;
import com.wenxin2.marioverse.items.WarpDisruptorItem;
import com.wenxin2.marioverse.network.server_bound.data.BouncePayload;
import com.wenxin2.marioverse.network.server_bound.data.FireballShootPayload;
import com.wenxin2.marioverse.network.server_bound.data.IceBallShootPayload;
import com.wenxin2.marioverse.network.server_bound.data.SquashEntityPayload;
import com.wenxin2.marioverse.registries.BlockRegistry;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.DataComponentRegistry;
import com.wenxin2.marioverse.registries.ItemRegistry;
import com.wenxin2.marioverse.registries.KeybindRegistry;
import com.wenxin2.marioverse.registries.ParticleRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.sounds.MarioverseSoundTypes;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.data.SlotTypeLoader;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.NameTagItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="marioverse")
public class MarioverseEventHandlers {
    private static final ResourceLocation SLOWDOWN_MODIFIER = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"mini_goomba_slowdown");

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.is(TagRegistry.SMASHABLE_BLOCK_ITEMS)) {
            event.getToolTip().add(Component.translatable((String)"tooltip.marioverse.smashable_blocks"));
        }
    }

    @SubscribeEvent
    public static void onJoinWorld(EntityJoinLevelEvent event) {
        AbilitiesHandler handler;
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        if (entity instanceof AbilitiesHandler && !(handler = (AbilitiesHandler)entity).mv$hasSuperMushroomOverride()) {
            if (entity.getType().is(TagRegistry.CAN_CONSUME_SUPER_MUSHROOMS) || ((Boolean)ConfigRegistry.SUPER_MUSHROOM_POWERS_ALL_MOBS.get()).booleanValue()) {
                LivingEntity livingEntity;
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if ((double)player.getHealth() > (Double)ConfigRegistry.SHRINK_PLAYERS_AT_HEALTH.get()) {
                        handler.mv$setSuperMushroom(true);
                    }
                } else if (entity instanceof LivingEntity && (double)(livingEntity = (LivingEntity)entity).getHealth() > (double)livingEntity.getMaxHealth() * (Double)ConfigRegistry.SHRINK_MOBS_AT_HEALTH.get()) {
                    handler.mv$setSuperMushroom(true);
                }
            } else {
                handler.mv$setSuperMushroom(true);
            }
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (mob.getType().is(TagRegistry.CAN_SHOOT_SUPPLEMENTARIES_CANNON) && ModList.get().isLoaded("supplementaries")) {
                SupplementariesCompat.addGoals(mob);
            }
            if (mob.getType().is(TagRegistry.CAN_PICKUP_AND_THROW_SHELLS)) {
                mob.goalSelector.addGoal(0, (Goal)new PickupAndThrowShellGoal(mob));
            }
            if (mob.getType().is(TagRegistry.CAN_COLLECT_COINS)) {
                mob.goalSelector.addGoal(5, (Goal)new CollectBlockGoal(mob, 0.25f, 5, 0.4f, state -> state.is(BlockRegistry.COIN)));
            }
            if (mob.getType().is(TagRegistry.CAN_COLLECT_STAR_COINS)) {
                mob.goalSelector.addGoal(5, (Goal)new CollectBlockGoal(mob, 0.15f, 5, 0.4f, state -> state.is(BlockRegistry.STAR_COIN)));
            }
            if (!(mob instanceof KoopaShellEntity) && mob instanceof AbilitiesHandler) {
                if (!(mob instanceof FireGoombaEntity)) {
                    mob.goalSelector.addGoal(5, (Goal)new ShootBouncingFireballGoal((LivingEntity)mob, (Integer)ConfigRegistry.MAX_MOB_FIREBALLS.get(), 0, true));
                    mob.goalSelector.addGoal(5, (Goal)new ShootBouncingIceBallGoal((LivingEntity)mob, (Integer)ConfigRegistry.MAX_MOB_ICE_BALLS.get(), 0, true));
                }
                if (mob instanceof PathfinderMob) {
                    PathfinderMob pathfinderMob = (PathfinderMob)mob;
                    if (!(mob instanceof KoopaTroopaEntity)) {
                        mob.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal(pathfinderMob, KoopaShellEntity.class, 3.0f, 1.0, 1.2));
                    }
                }
            }
            if (!mob.getType().is(TagRegistry.CANNOT_CONSUME_POWER_UPS)) {
                if (mob.getType().is(TagRegistry.CAN_CONSUME_FIRE_FLOWERS) || ((Boolean)ConfigRegistry.FIRE_FLOWER_POWERS_ALL_MOBS.get()).booleanValue()) {
                    mob.goalSelector.addGoal(3, new ChaseTargetGoal<FireFlowerEntity>(mob, 0.6f, FireFlowerEntity.class));
                }
                if (mob.getType().is(TagRegistry.CAN_CONSUME_ICE_FLOWERS) || ((Boolean)ConfigRegistry.ICE_FLOWER_POWERS_ALL_MOBS.get()).booleanValue()) {
                    mob.goalSelector.addGoal(3, new ChaseTargetGoal<IceFlowerEntity>(mob, 0.6f, IceFlowerEntity.class));
                }
                if (mob.getType().is(TagRegistry.CAN_CONSUME_ONE_UPS) || ((Boolean)ConfigRegistry.ONE_UP_HEALS_ALL_MOBS.get()).booleanValue()) {
                    mob.goalSelector.addGoal(3, new ChaseTargetGoal<OneUpMushroomEntity>(mob, 0.6f, OneUpMushroomEntity.class));
                }
                if (mob.getType().is(TagRegistry.CAN_CONSUME_SUPER_MUSHROOMS) || ((Boolean)ConfigRegistry.SUPER_MUSHROOM_POWERS_ALL_MOBS.get()).booleanValue()) {
                    mob.goalSelector.addGoal(3, new ChaseTargetGoal<MushroomEntity>(mob, 0.6f, MushroomEntity.class));
                }
                if (mob.getType().is(TagRegistry.CAN_CONSUME_SUPER_STARS) || ((Boolean)ConfigRegistry.SUPER_STAR_POWERS_ALL_MOBS.get()).booleanValue()) {
                    mob.goalSelector.addGoal(3, new ChaseTargetGoal<SuperStarEntity>(mob, 0.6f, SuperStarEntity.class));
                }
            }
        }
    }

    @SubscribeEvent
    public static void postEntityTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        UUID uuid = entity.getUUID();
        int spinningTicks = entity.getPersistentData().getInt("marioverse:spinning_ticks");
        if (entity.isVehicle() && spinningTicks > 0) {
            entity.setYRot(entity.getYRot() + 30.0f);
            entity.getPersistentData().putInt("marioverse:spinning_ticks", spinningTicks - 1);
            for (Entity rider : entity.getPassengers()) {
                rider.setYHeadRot(rider.getYHeadRot() + 30.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHeal(LivingHealEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof AbilitiesHandler) {
            AbilitiesHandler handler = (AbilitiesHandler)entity;
            if (entity.getType().is(TagRegistry.CAN_CONSUME_SUPER_MUSHROOMS) || ((Boolean)ConfigRegistry.SUPER_MUSHROOM_POWERS_ALL_MOBS.get()).booleanValue()) {
                LivingEntity livingEntity;
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if ((double)player.getHealth() > (Double)ConfigRegistry.SHRINK_PLAYERS_AT_HEALTH.get()) {
                        handler.mv$setSuperMushroom(true);
                    }
                } else if (entity instanceof LivingEntity && (double)(livingEntity = entity).getHealth() > (double)livingEntity.getMaxHealth() * (Double)ConfigRegistry.SHRINK_MOBS_AT_HEALTH.get()) {
                    handler.mv$setSuperMushroom(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDamaged(LivingIncomingDamageEvent event) {
        Player player;
        Level world = event.getEntity().level();
        DamageSource source = event.getSource();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).isDamageSourceBlocked(event.getSource()) && player instanceof AbilitiesHandler) {
            AccessoriesCapability capability;
            SoundSource soundSource;
            AbilitiesHandler handler = (AbilitiesHandler)player;
            float healthAfterDamage = player.getHealth() - event.getAmount();
            SoundSource soundSource2 = soundSource = event.getEntity() instanceof Player ? SoundSource.PLAYERS : SoundSource.NEUTRAL;
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                if (handler.mv$hasFireFlower() || handler.mv$hasIceFlower()) {
                    ServerParticleUtils.spawnPoweredUpParticles((ParticleOptions)ParticleTypes.CRIT, serverWorld, (Entity)player, 10);
                }
            }
            if (handler.mv$hasFireFlower()) {
                handler.mv$setFireFlower(false);
                world.playSound(null, player.blockPosition(), (SoundEvent)SoundRegistry.DAMAGE_TAKEN.get(), soundSource, 1.0f, 1.0f);
            }
            if (handler.mv$hasIceFlower()) {
                handler.mv$setIceFlower(false);
                world.playSound(null, player.blockPosition(), (SoundEvent)SoundRegistry.DAMAGE_TAKEN.get(), soundSource, 1.0f, 1.0f);
            }
            if (((Boolean)event.getEntity().getData(DataAttachmentRegistry.HAS_SUPER_STAR)).booleanValue() && !source.is(TagRegistry.BYPASSES_SUPER_STAR) && !source.is(TagRegistry.IS_SUPER_STAR)) {
                event.setCanceled(true);
            }
            if ((double)healthAfterDamage <= (Double)ConfigRegistry.SHRINK_PLAYERS_AT_HEALTH.get()) {
                handler.mv$setSuperMushroom(false);
                if (handler.mv$hasSuperMushroom()) {
                    world.playSound(null, player.blockPosition(), (SoundEvent)SoundRegistry.DAMAGE_TAKEN.get(), soundSource, 1.0f, 1.0f);
                }
            }
            if ((capability = AccessoriesCapability.get((LivingEntity)player)) != null && ((Boolean)ConfigRegistry.EQUIP_COSTUMES_PLAYERS.get()).booleanValue() && !player.getType().is(TagRegistry.CANNOT_LOSE_POWER_UP)) {
                String[] slotTypes;
                for (String slotType : slotTypes = new String[]{"costume_hat", "costume_shirt", "costume_pants", "costume_shoes"}) {
                    ItemStack stack;
                    AccessoriesContainer container = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)player, (String)slotType));
                    if (container == null || !(stack = container.getAccessories().getItem(0)).is(TagRegistry.POWER_UP_COSTUMES)) continue;
                    MarioverseEventHandlers.removeCostume((LivingEntity)player, capability);
                }
            }
        } else {
            LivingEntity entity;
            LivingEntity healthAfterDamage = event.getEntity();
            if (healthAfterDamage instanceof LivingEntity && !(entity = healthAfterDamage).isDamageSourceBlocked(event.getSource()) && entity instanceof AbilitiesHandler) {
                AccessoriesCapability capability;
                AbilitiesHandler handler = (AbilitiesHandler)entity;
                float maxHealth = entity.getMaxHealth();
                float healthAfterDamage2 = entity.getHealth() - event.getAmount();
                float threshold = maxHealth * ((Double)ConfigRegistry.SHRINK_MOBS_AT_HEALTH.get()).floatValue();
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    if (handler.mv$hasFireFlower() || handler.mv$hasIceFlower()) {
                        ServerParticleUtils.spawnPoweredUpParticles((ParticleOptions)ParticleTypes.CRIT, serverWorld, (Entity)entity, 10);
                    }
                }
                if (handler.mv$hasFireFlower() && !entity.getType().is(TagRegistry.CANNOT_LOSE_POWER_UP)) {
                    handler.mv$setFireFlower(false);
                    world.playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.DAMAGE_TAKEN.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                }
                if (handler.mv$hasIceFlower() && !entity.getType().is(TagRegistry.CANNOT_LOSE_POWER_UP)) {
                    handler.mv$setIceFlower(false);
                    world.playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.DAMAGE_TAKEN.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                }
                if (((Boolean)event.getEntity().getData(DataAttachmentRegistry.HAS_SUPER_STAR)).booleanValue() && !source.is(TagRegistry.BYPASSES_SUPER_STAR) && !source.is(TagRegistry.IS_SUPER_STAR)) {
                    event.setCanceled(true);
                }
                if (healthAfterDamage2 <= threshold) {
                    handler.mv$setSuperMushroom(false);
                }
                if ((capability = AccessoriesCapability.get((LivingEntity)entity)) != null && ((Boolean)ConfigRegistry.EQUIP_COSTUMES_MOBS.get()).booleanValue() && !entity.getType().is(TagRegistry.CANNOT_LOSE_POWER_UP)) {
                    String[] slotTypes;
                    for (String slotType : slotTypes = new String[]{"costume_hat", "costume_shirt", "costume_pants", "costume_shoes"}) {
                        ItemStack stack;
                        AccessoriesContainer container = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)slotType));
                        if (container == null || !(stack = container.getAccessories().getItem(0)).is(TagRegistry.POWER_UP_COSTUMES)) continue;
                        MarioverseEventHandlers.removeCostume(entity, capability);
                    }
                }
            }
        }
        if (event.getEntity().getType().is(TagRegistry.EQUIP_COSTUMES_IN_ARMOR_SLOTS)) {
            if (event.getEntity().getItemBySlot(EquipmentSlot.HEAD).is(TagRegistry.POWER_UP_COSTUMES)) {
                event.getEntity().getItemBySlot(EquipmentSlot.HEAD).shrink(1);
            }
            if (event.getEntity().getItemBySlot(EquipmentSlot.CHEST).is(TagRegistry.POWER_UP_COSTUMES)) {
                event.getEntity().getItemBySlot(EquipmentSlot.CHEST).shrink(1);
            }
            if (event.getEntity().getItemBySlot(EquipmentSlot.LEGS).is(TagRegistry.POWER_UP_COSTUMES)) {
                event.getEntity().getItemBySlot(EquipmentSlot.LEGS).shrink(1);
            }
            if (event.getEntity().getItemBySlot(EquipmentSlot.FEET).is(TagRegistry.POWER_UP_COSTUMES)) {
                event.getEntity().getItemBySlot(EquipmentSlot.FEET).shrink(1);
            }
        }
    }

    public static void onDeath(LivingDeathEvent event) {
        AbilitiesHandler handler;
        LivingEntity entity = event.getEntity();
        if (((Boolean)ConfigRegistry.ENABLE_STOMPABLE_ENEMIES.get()).booleanValue() && (entity.getType().is(TagRegistry.CAN_STOMP_ENEMIES) || ((Boolean)ConfigRegistry.ALL_MOBS_CAN_STOMP.get()).booleanValue() || entity.level().getGameRules().getBoolean(Marioverse.ALL_MOBS_CAN_STOMP)) && entity instanceof AbilitiesHandler && (handler = (AbilitiesHandler)entity).mv$getOneUpsRewarded() > 0) {
            handler.mv$setOneUpsRewarded(0);
        }
    }

    private static void removeCostume(LivingEntity entity, AccessoriesCapability capability) {
        ItemStack stack;
        AccessoriesContainer containerHat = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_hat"));
        AccessoriesContainer containerShirt = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_shirt"));
        AccessoriesContainer containerPants = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_pants"));
        AccessoriesContainer containerShoes = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_shoes"));
        if (containerHat != null) {
            stack = containerHat.getAccessories().getItem(0);
            ItemStack hatItem = new ItemStack((ItemLike)ItemRegistry.MARIO_HAT.get());
            if (stack.is(TagRegistry.MARIO_COSTUMES)) {
                containerHat.getAccessories().setItem(0, hatItem);
            }
            hatItem = new ItemStack((ItemLike)ItemRegistry.LUIGI_HAT.get());
            if (stack.is(TagRegistry.LUIGI_COSTUMES)) {
                containerHat.getAccessories().setItem(0, hatItem);
            }
            hatItem = new ItemStack((ItemLike)ItemRegistry.PEACH_CROWN.get());
            if (stack.is(TagRegistry.PEACH_COSTUMES)) {
                containerHat.getAccessories().setItem(0, hatItem);
            }
            hatItem.applyComponents(stack.getComponents());
        }
        if (containerShirt != null) {
            stack = containerShirt.getAccessories().getItem(0);
            ItemStack shirtItem = new ItemStack((ItemLike)ItemRegistry.MARIO_SHIRT.get());
            if (stack.is(TagRegistry.MARIO_COSTUMES)) {
                containerShirt.getAccessories().setItem(0, shirtItem);
            }
            shirtItem = new ItemStack((ItemLike)ItemRegistry.LUIGI_SHIRT.get());
            if (stack.is(TagRegistry.LUIGI_COSTUMES)) {
                containerShirt.getAccessories().setItem(0, shirtItem);
            }
            shirtItem = new ItemStack((ItemLike)ItemRegistry.PEACH_BODICE.get());
            if (stack.is(TagRegistry.PEACH_COSTUMES)) {
                containerShirt.getAccessories().setItem(0, shirtItem);
            }
            shirtItem.applyComponents(stack.getComponents());
        }
        if (containerPants != null) {
            stack = containerPants.getAccessories().getItem(0);
            ItemStack pantsItem = new ItemStack((ItemLike)ItemRegistry.MARIO_PANTS.get());
            if (stack.is(TagRegistry.MARIO_COSTUMES)) {
                containerPants.getAccessories().setItem(0, pantsItem);
            }
            pantsItem = new ItemStack((ItemLike)ItemRegistry.LUIGI_PANTS.get());
            if (stack.is(TagRegistry.LUIGI_COSTUMES)) {
                containerPants.getAccessories().setItem(0, pantsItem);
            }
            pantsItem = new ItemStack((ItemLike)ItemRegistry.PEACH_DRESS.get());
            if (stack.is(TagRegistry.PEACH_COSTUMES)) {
                containerPants.getAccessories().setItem(0, pantsItem);
            }
            pantsItem.applyComponents(stack.getComponents());
        }
        if (containerShoes != null) {
            stack = containerShoes.getAccessories().getItem(0);
            ItemStack shoesItem = new ItemStack((ItemLike)ItemRegistry.MARIO_SHOES.get());
            if (stack.is(TagRegistry.MARIO_COSTUMES)) {
                containerShoes.getAccessories().setItem(0, shoesItem);
            }
            shoesItem = new ItemStack((ItemLike)ItemRegistry.LUIGI_SHOES.get());
            if (stack.is(TagRegistry.LUIGI_COSTUMES)) {
                containerShoes.getAccessories().setItem(0, shoesItem);
            }
            shoesItem = new ItemStack((ItemLike)ItemRegistry.PEACH_SHOES.get());
            if (stack.is(TagRegistry.PEACH_COSTUMES)) {
                containerShoes.getAccessories().setItem(0, shoesItem);
            }
            shoesItem.applyComponents(stack.getComponents());
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockEntity blockEntity;
        WarpTrapDoorBlockEntity trapDoorBE;
        BlockEntity doorBEBelow;
        ServerLevel serverWorld;
        WarpDoorBlockEntity doorBE;
        BaseWarpBlockEntity warpBE;
        PottedPiranhaPlantBlockEntity piranhaPlantBE;
        BlockEntity blockEntity2;
        Block block;
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = world.getBlockState(pos);
        ItemStack heldItem = event.getItemStack();
        Player player = event.getEntity();
        Direction.Axis axis = event.getEntity().getDirection().getAxis();
        BlockState newState = (BlockState)((Block)BlockRegistry.POTTED_PIRANHA_PLANT.get()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)axis);
        if (heldItem.getItem() instanceof PiranhaPlantPodItem && (block = state.getBlock()) instanceof FlowerPotBlock) {
            FlowerPotBlock flowerPot = (FlowerPotBlock)block;
            if (!(state.getBlock() instanceof PottedPiranhaPlantBlock) && flowerPot.getPotted() == Blocks.AIR && !player.isShiftKeyDown()) {
                world.setBlock(pos, newState, 3);
                blockEntity2 = world.getBlockEntity(pos);
                if (blockEntity2 instanceof PottedPiranhaPlantBlockEntity) {
                    piranhaPlantBE = (PottedPiranhaPlantBlockEntity)blockEntity2;
                    piranhaPlantBE.setOwner((Entity)player);
                    piranhaPlantBE.setChanged();
                }
                world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                player.awardStat(Stats.POT_FLOWER);
                player.swing(InteractionHand.MAIN_HAND);
                heldItem.consume(1, (LivingEntity)player);
            }
        }
        if (heldItem.getItem() instanceof SpawnEggItem && state.getBlock() instanceof WarpPipeBlock && (blockEntity2 = world.getBlockEntity(pos)) instanceof BaseWarpBlockEntity && ((warpBE = (BaseWarpBlockEntity)blockEntity2).isWaxed() || !((Boolean)ConfigRegistry.WARP_PIPE_SPAWNS_MOBS.get()).booleanValue())) {
            event.setCancellationResult(InteractionResult.FAIL);
            event.setCanceled(true);
        }
        if (heldItem.getItem() instanceof HoneycombItem && (blockEntity2 = world.getBlockEntity(pos)) instanceof BaseWarpBlockEntity) {
            warpBE = (BaseWarpBlockEntity)blockEntity2;
            if ((((Boolean)ConfigRegistry.WAX_DISABLES_BUBBLES.get()).booleanValue() || ((Boolean)ConfigRegistry.WAX_DISABLES_CLOSING.get()).booleanValue() || ((Boolean)ConfigRegistry.WAX_DISABLES_RENAMING.get()).booleanValue() || ((Boolean)ConfigRegistry.WAX_DISABLES_WATER_SPOUTS.get()).booleanValue() || ((Boolean)ConfigRegistry.WAX_DISABLES_WARP_LINKING.get()).booleanValue()) && !warpBE.isWaxed()) {
                warpBE.setWaxed(true);
                warpBE.markUpdated();
                heldItem.consume(1, (LivingEntity)player);
                if (state.getBlock() instanceof DoorBlock && state.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.LOWER) {
                    ParticleUtils.spawnParticlesOnBlockFaces((Level)world, (BlockPos)pos.above(), (ParticleOptions)ParticleTypes.WAX_ON, (IntProvider)UniformInt.of((int)3, (int)5));
                }
                if (state.getBlock() instanceof DoorBlock && state.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.UPPER) {
                    ParticleUtils.spawnParticlesOnBlockFaces((Level)world, (BlockPos)pos.below(), (ParticleOptions)ParticleTypes.WAX_ON, (IntProvider)UniformInt.of((int)3, (int)5));
                }
                ParticleUtils.spawnParticlesOnBlockFaces((Level)world, (BlockPos)pos, (ParticleOptions)ParticleTypes.WAX_ON, (IntProvider)UniformInt.of((int)3, (int)5));
                world.playSound(player, pos, SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                world.sendBlockUpdated(pos, state, state, 3);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
        if (heldItem.getItem() instanceof AxeItem && (blockEntity2 = world.getBlockEntity(pos)) instanceof BaseWarpBlockEntity) {
            warpBE = (BaseWarpBlockEntity)blockEntity2;
            if (((Boolean)ConfigRegistry.ALLOW_WARP_UNWAXING.get()).booleanValue() && warpBE.isWaxed()) {
                warpBE.setWaxed(false);
                warpBE.markUpdated();
                heldItem.hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                if (state.getBlock() instanceof DoorBlock && state.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.LOWER) {
                    ParticleUtils.spawnParticlesOnBlockFaces((Level)world, (BlockPos)pos.above(), (ParticleOptions)ParticleTypes.WAX_OFF, (IntProvider)UniformInt.of((int)3, (int)5));
                }
                if (state.getBlock() instanceof DoorBlock && state.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.UPPER) {
                    ParticleUtils.spawnParticlesOnBlockFaces((Level)world, (BlockPos)pos.below(), (ParticleOptions)ParticleTypes.WAX_OFF, (IntProvider)UniformInt.of((int)3, (int)5));
                }
                ParticleUtils.spawnParticlesOnBlockFaces((Level)world, (BlockPos)pos, (ParticleOptions)ParticleTypes.WAX_OFF, (IntProvider)UniformInt.of((int)3, (int)5));
                world.playSound(null, pos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                world.sendBlockUpdated(pos, state, state, 3);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
        if (heldItem.is(TagRegistry.WARP_FUEL) && player.isShiftKeyDown() && (blockEntity2 = world.getBlockEntity(pos)) instanceof WarpDoorBlockEntity && (doorBE = (WarpDoorBlockEntity)blockEntity2).getWarpFuelCount() < ConfigRegistry.WARP_DOOR_FUEL_AMT.getAsInt()) {
            BlockEntity serverWorld2;
            WarpDoorBlockEntity doorBEAbove;
            doorBE.setWarpFuelCount(doorBE.getWarpFuelCount() + 1);
            if (doorBE.getWarpFuelCount() < ConfigRegistry.WARP_DOOR_FUEL_AMT.getAsInt()) {
                world.playSound(null, pos, (SoundEvent)SoundRegistry.WARP_FUEL_FILLS.get(), SoundSource.BLOCKS);
            } else if (doorBE.getWarpFuelCount() == ConfigRegistry.WARP_DOOR_FUEL_AMT.getAsInt()) {
                world.playSound(null, pos, (SoundEvent)SoundRegistry.WARP_COMPLETED.get(), SoundSource.BLOCKS);
            }
            if (world instanceof ServerLevel) {
                serverWorld = (ServerLevel)world;
                ServerParticleUtils.spawnThreeLayerBlockParticles((ParticleOptions)ParticleTypes.PORTAL, serverWorld, null, pos, 16);
            }
            player.swing(player.getUsedItemHand());
            heldItem.consume(1, (LivingEntity)player);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            if (state.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.LOWER && (piranhaPlantBE = world.getBlockEntity(pos.above())) instanceof WarpDoorBlockEntity && (doorBEAbove = (WarpDoorBlockEntity)((Object)piranhaPlantBE)).getWarpFuelCount() < ConfigRegistry.WARP_DOOR_FUEL_AMT.getAsInt()) {
                doorBEAbove.setWarpFuelCount(doorBEAbove.getWarpFuelCount() + 1);
                if (world instanceof ServerLevel) {
                    serverWorld2 = (ServerLevel)world;
                    ServerParticleUtils.spawnThreeLayerBlockParticles((ParticleOptions)ParticleTypes.PORTAL, (ServerLevel)serverWorld2, null, pos.above(), 16);
                }
            }
            if (state.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.UPPER && (serverWorld2 = world.getBlockEntity(pos.below())) instanceof WarpDoorBlockEntity && (doorBEBelow = (WarpDoorBlockEntity)serverWorld2).getWarpFuelCount() < ConfigRegistry.WARP_DOOR_FUEL_AMT.getAsInt()) {
                doorBEBelow.setWarpFuelCount(doorBEBelow.getWarpFuelCount() + 1);
                if (world instanceof ServerLevel) {
                    serverWorld2 = (ServerLevel)world;
                    ServerParticleUtils.spawnThreeLayerBlockParticles((ParticleOptions)ParticleTypes.PORTAL, (ServerLevel)serverWorld2, null, pos.below(), 16);
                }
            }
        }
        if (heldItem.is(TagRegistry.WARP_FUEL) && player.isShiftKeyDown() && (doorBEBelow = world.getBlockEntity(pos)) instanceof WarpTrapDoorBlockEntity && (trapDoorBE = (WarpTrapDoorBlockEntity)doorBEBelow).getWarpFuelCount() < ConfigRegistry.WARP_TRAPDOOR_FUEL_AMT.getAsInt()) {
            trapDoorBE.setWarpFuelCount(trapDoorBE.getWarpFuelCount() + 1);
            if (trapDoorBE.getWarpFuelCount() < ConfigRegistry.WARP_TRAPDOOR_FUEL_AMT.getAsInt()) {
                world.playSound(null, pos, (SoundEvent)SoundRegistry.WARP_FUEL_FILLS.get(), SoundSource.BLOCKS);
            } else if (trapDoorBE.getWarpFuelCount() == ConfigRegistry.WARP_TRAPDOOR_FUEL_AMT.getAsInt()) {
                world.playSound(null, pos, (SoundEvent)SoundRegistry.WARP_COMPLETED.get(), SoundSource.BLOCKS);
            }
            if (world instanceof ServerLevel) {
                serverWorld = (ServerLevel)world;
                ServerParticleUtils.spawnOneLayerBlockParticles((ParticleOptions)ParticleTypes.PORTAL, serverWorld, null, pos, 16);
            }
            player.swing(player.getUsedItemHand());
            heldItem.consume(1, (LivingEntity)player);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
        if (world.isClientSide() && (blockEntity = world.getBlockEntity(pos)) instanceof WarpPipeBlockEntity) {
            WarpPipeScreen.lastClickedPos = pos;
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Item item;
        Level world = event.getLevel();
        Entity target = event.getTarget();
        Player player = event.getEntity();
        BlockPos pos = target.blockPosition();
        ItemStack stack = event.getItemStack();
        if (stack.getItem() instanceof NameTagItem && target instanceof IceCubeEntity) {
            event.setCancellationResult(InteractionResult.PASS);
            event.setCanceled(true);
        }
        if ((item = stack.getItem()) instanceof LinkerItem) {
            LinkerItem linker = (LinkerItem)item;
            if (!player.isCreative() && ((Boolean)ConfigRegistry.CREATIVE_WRENCH_LINKING.get()).booleanValue() && !((Boolean)ConfigRegistry.DISABLE_WARP_PAINTINGS.get()).booleanValue()) {
                player.displayClientMessage((Component)Component.translatable((String)(stack.getDescriptionId() + ".message.requires_creative")), true);
                player.swing(player.getUsedItemHand());
            } else if (!((Boolean)ConfigRegistry.DISABLE_WARP_PAINTINGS.get()).booleanValue() && player.isShiftKeyDown()) {
                uuid = target.getUUID();
                if (world instanceof ServerLevel) {
                    WarpLinkableEntity linkableEntity;
                    WarpLinkableEntity linkableEntity2;
                    ServerLevel serverWorld = (ServerLevel)world;
                    if (target instanceof WarpLinkableEntity && (linkableEntity2 = (WarpLinkableEntity)target).mv$isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_WARP_LINKING.get()).booleanValue()) {
                        player.displayClientMessage((Component)Component.translatable((String)(linker.getDescriptionId() + ".message.waxed"), (Object[])new Object[]{target.getName()}).withStyle(ChatFormatting.GOLD), true);
                    } else if (!player.isCreative() && target instanceof WarpLinkableEntity && (linkableEntity = (WarpLinkableEntity)target).mv$getWarpFuelCount() < ConfigRegistry.WARP_PAINTING_FUEL_AMT.getAsInt()) {
                        if (linkableEntity.mv$getWarpFuelCount() < ConfigRegistry.WARP_PAINTING_FUEL_AMT.getAsInt()) {
                            Painting painting;
                            if (linkableEntity instanceof Painting && (painting = (Painting)linkableEntity).getVariant().getKey() != null) {
                                player.displayClientMessage((Component)Component.translatable((String)(linker.getDescriptionId() + ".message.painting_fuel_required"), (Object[])new Object[]{Component.translatable((String)painting.getVariant().getKey().location().toLanguageKey("painting", "title")), target.getName(), ConfigRegistry.WARP_PAINTING_FUEL_AMT.getAsInt() - linkableEntity.mv$getWarpFuelCount()}).withStyle(ChatFormatting.RED).withStyle(ChatFormatting.BOLD), true);
                            } else {
                                player.displayClientMessage((Component)Component.translatable((String)(linker.getDescriptionId() + ".message.entity_fuel_required"), (Object[])new Object[]{target.getName(), ConfigRegistry.WARP_PAINTING_FUEL_AMT.getAsInt() - linkableEntity.mv$getWarpFuelCount()}).withStyle(ChatFormatting.RED).withStyle(ChatFormatting.BOLD), true);
                            }
                        }
                    } else if (!LinkerItem.getIsBound(stack)) {
                        if (target instanceof Painting) {
                            Painting painting = (Painting)target;
                            int width = ((PaintingVariant)painting.getVariant().value()).width();
                            Direction direction = painting.getDirection();
                            WarpLinkableEntity.setWarpPos((UUID)uuid, pos, direction, width);
                            LinkerItem.setWarpPos(stack, pos);
                            LinkerItem.setWarpEntity(stack, (Entity)painting);
                            if (painting.getVariant().getKey() != null) {
                                player.displayClientMessage((Component)Component.translatable((String)(stack.getDescriptionId() + ".message.bound_painting"), (Object[])new Object[]{Component.translatable((String)painting.getVariant().getKey().location().toLanguageKey("painting", "title")), target.getName()}).withStyle(ChatFormatting.GREEN), true);
                                LinkerItem.setWarpPainting(stack, painting);
                            }
                        } else {
                            WarpLinkableEntity.setWarpPos((UUID)uuid, pos, Direction.NORTH, 1);
                            LinkerItem.setWarpPos(stack, pos);
                            player.displayClientMessage((Component)Component.translatable((String)(stack.getDescriptionId() + ".message.bound"), (Object[])new Object[]{target.getName()}).withStyle(ChatFormatting.GREEN), true);
                        }
                        LinkerItem.setWarpDimension(stack, target.level().dimension().toString());
                        LinkerItem.setWarpUUID(stack, (UUID)uuid);
                        LinkerItem.setIsBound(stack, true);
                        stack.remove((DataComponentType)DataComponentRegistry.WARP_BLOCK.get());
                        WarpLinkableEntity.WARP_ENTITY_LOCATIONS.put(pos, target);
                        ServerParticleUtils.spawnParticlesOnEntityRandomly((ParticleOptions)ParticleTypes.ENCHANT, serverWorld, target, 0.5, 128);
                        linker.playSound(world, pos, (SoundEvent)SoundRegistry.WRENCH_BOUND.get(), SoundSource.PLAYERS, 1.0f, 0.1f);
                    } else {
                        WarpLinkableEntity.WarpTarget warpTarget;
                        BlockPos warpPos = LinkerItem.getWarpPos(stack);
                        UUID warpUUID = LinkerItem.getWarpUUID(stack);
                        Entity warpEntity = serverWorld.getEntity(warpUUID);
                        if (warpEntity == null && (warpTarget = WarpLinkableEntity.WARP_LOCATIONS.get(warpUUID)) != null) {
                            warpPos = warpTarget.pos();
                        }
                        if (target instanceof Painting) {
                            Painting warpPainting;
                            Painting painting = (Painting)target;
                            int width = ((PaintingVariant)painting.getVariant().value()).width();
                            WarpLinkableEntity.setWarpPos(warpUUID, warpPos, painting.getDirection(), width);
                            if (warpEntity instanceof Painting && (warpPainting = (Painting)warpEntity).getVariant().getKey() != null && painting.getVariant().getKey() != null) {
                                player.displayClientMessage((Component)Component.translatable((String)(stack.getDescriptionId() + ".message.linked_warp_painting"), (Object[])new Object[]{Component.translatable((String)painting.getVariant().getKey().location().toLanguageKey("painting", "title")), target.getName(), Component.translatable((String)warpPainting.getVariant().getKey().location().toLanguageKey("painting", "title")), warpPainting.getName()}).withStyle(ChatFormatting.GOLD), true);
                            }
                        } else if (warpEntity != null) {
                            player.displayClientMessage((Component)Component.translatable((String)(stack.getDescriptionId() + ".message.linked_warp_block"), (Object[])new Object[]{target.getName(), warpEntity.getName()}).withStyle(ChatFormatting.GOLD), true);
                        }
                        linker.link(stack, warpEntity, target, warpPos);
                        ServerParticleUtils.spawnParticlesOnEntityRandomly((ParticleOptions)ParticleTypes.ENCHANT, serverWorld, target, 0.5, 128);
                        linker.playSound(world, pos, (SoundEvent)SoundRegistry.PIPES_LINKED.get(), SoundSource.BLOCKS, 1.0f, 0.1f);
                        LinkerItem.setIsBound(stack, false);
                    }
                }
                player.swing(player.getUsedItemHand());
            }
        } else {
            WarpLinkableEntity warpLinkableEntity;
            uuid = stack.getItem();
            if (uuid instanceof WarpDisruptorItem) {
                WarpDisruptorItem disruptorItem = (WarpDisruptorItem)((Object)uuid);
                if (!(((Boolean)ConfigRegistry.DISABLE_WARP_PAINTINGS.get()).booleanValue() || !(target instanceof WarpLinkableEntity) || (linkableEntity = (WarpLinkableEntity)target).mv$getPreventWarp() && linkableEntity.mv$isBreakPainting())) {
                    if (world instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)world;
                        if (linkableEntity.mv$isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_WARP_LINKING.get()).booleanValue()) {
                            Painting painting;
                            if (linkableEntity instanceof Painting && (painting = (Painting)linkableEntity).getVariant().getKey() != null) {
                                player.displayClientMessage((Component)Component.translatable((String)(disruptorItem.getDescriptionId() + ".message.waxed_painting"), (Object[])new Object[]{Component.translatable((String)painting.getVariant().getKey().location().toLanguageKey("painting", "title")), target.getName()}).withStyle(ChatFormatting.GOLD), true);
                            } else {
                                player.displayClientMessage((Component)Component.translatable((String)(disruptorItem.getDescriptionId() + ".message.waxed"), (Object[])new Object[]{target.getName()}).withStyle(ChatFormatting.GOLD), true);
                            }
                        } else if (linkableEntity.mv$getPreventWarp()) {
                            Painting painting;
                            ServerParticleUtils.spawnPoweredUpParticles((ParticleOptions)ParticleTypes.WARPED_SPORE, serverWorld, target, 16);
                            if (linkableEntity instanceof Painting && (painting = (Painting)linkableEntity).getVariant().getKey() != null) {
                                player.displayClientMessage((Component)Component.translatable((String)(disruptorItem.getDescriptionId() + ".message.break_painting"), (Object[])new Object[]{Component.translatable((String)painting.getVariant().getKey().location().toLanguageKey("painting", "title")), target.getName()}).withStyle(ChatFormatting.DARK_AQUA), true);
                            } else {
                                player.displayClientMessage((Component)Component.translatable((String)(disruptorItem.getDescriptionId() + ".message.break_entity"), (Object[])new Object[]{target.getName()}).withStyle(ChatFormatting.DARK_AQUA), true);
                            }
                            linkableEntity.mv$setBreakPainting(Boolean.TRUE);
                        } else {
                            Painting painting;
                            ServerParticleUtils.spawnPoweredUpParticles((ParticleOptions)ParticleTypes.CRIMSON_SPORE, serverWorld, target, 16);
                            if (linkableEntity instanceof Painting && (painting = (Painting)linkableEntity).getVariant().getKey() != null) {
                                player.displayClientMessage((Component)Component.translatable((String)(disruptorItem.getDescriptionId() + ".message.prevent_painting_warp"), (Object[])new Object[]{Component.translatable((String)painting.getVariant().getKey().location().toLanguageKey("painting", "title")), target.getName()}).withStyle(ChatFormatting.RED), true);
                            } else {
                                player.displayClientMessage((Component)Component.translatable((String)(disruptorItem.getDescriptionId() + ".message.prevent_entity_warp"), (Object[])new Object[]{target.getDisplayName()}).withStyle(ChatFormatting.RED), true);
                            }
                            linkableEntity.mv$setPreventWarp(Boolean.TRUE);
                        }
                        if (!player.isCreative()) {
                            stack.hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                        }
                    }
                    player.swing(player.getUsedItemHand());
                }
            } else if (!((Boolean)ConfigRegistry.DISABLE_WARP_PAINTINGS.get()).booleanValue() && stack.is(TagRegistry.WARP_FUEL) && target instanceof WarpLinkableEntity && (warpLinkableEntity = (WarpLinkableEntity)target).mv$getWarpFuelCount() < ConfigRegistry.WARP_PAINTING_FUEL_AMT.getAsInt()) {
                warpLinkableEntity.mv$setWarpFuelCount(warpLinkableEntity.mv$getWarpFuelCount() + 1);
                if (warpLinkableEntity.mv$getWarpFuelCount() < ConfigRegistry.WARP_PAINTING_FUEL_AMT.getAsInt()) {
                    world.playSound(null, pos, (SoundEvent)SoundRegistry.WARP_FUEL_FILLS.get(), SoundSource.BLOCKS);
                } else if (warpLinkableEntity.mv$getWarpFuelCount() == ConfigRegistry.WARP_PAINTING_FUEL_AMT.getAsInt()) {
                    world.playSound(null, pos, (SoundEvent)SoundRegistry.WARP_COMPLETED.get(), SoundSource.BLOCKS);
                }
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    ServerParticleUtils.spawnOneLayerBlockParticles((ParticleOptions)ParticleTypes.PORTAL, serverWorld, target, pos, 16);
                }
                player.swing(player.getUsedItemHand());
                stack.consume(1, (LivingEntity)player);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            } else if (stack.getItem() instanceof HoneycombItem && target instanceof WarpLinkableEntity) {
                linkableEntity = (WarpLinkableEntity)target;
                if (((Boolean)ConfigRegistry.WAX_DISABLES_WARP_LINKING.get()).booleanValue() && !linkableEntity.mv$isWaxed()) {
                    if (world instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)world;
                        world.playSound(player, pos, SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
                        ServerParticleUtils.spawnParticlesOnEntityRandomly((ParticleOptions)ParticleTypes.WAX_ON, serverWorld, target, 0.5, 64);
                        stack.consume(1, (LivingEntity)player);
                    }
                    linkableEntity.mv$setWaxed(true);
                    player.swing(player.getUsedItemHand());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ServerPlayer player;
        BlockPos respawnPos;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (respawnPos = (player = (ServerPlayer)player2).getRespawnPosition()) != null) {
            Block block;
            Level world = player.level();
            BlockState state = world.getBlockState(respawnPos);
            if (state.getBlock() instanceof CheckpointFlagBlock) {
                if (((Boolean)ConfigRegistry.CHECKPOINT_FLAG_MODIFY_HEALTH.get()).booleanValue()) {
                    player.setHealth(((Double)ConfigRegistry.CHECKPOINT_FLAG_RESPAWN_HEALTH.get()).floatValue());
                    player.getFoodData().setFoodLevel(((Integer)ConfigRegistry.CHECKPOINT_FLAG_FOOD_AMT.get()).intValue());
                    if ((double)player.getHealth() <= (Double)ConfigRegistry.SHRINK_PLAYERS_AT_HEALTH.get() && player instanceof AbilitiesHandler) {
                        AbilitiesHandler handler = (AbilitiesHandler)player;
                        handler.mv$setSuperMushroom(false);
                    }
                }
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    serverWorld.sendParticles((ParticleOptions)((SimpleParticleType)ParticleRegistry.GLOWING_STAR.get()), (double)respawnPos.getX() + 0.5, (double)respawnPos.getY() + 0.5, (double)respawnPos.getZ() + 0.5, 10, 0.4, 0.5, 0.4, 0.6);
                }
            }
            if ((block = state.getBlock()) instanceof CheckpointFlagBlock) {
                CheckpointFlagBlock flagBlock = (CheckpointFlagBlock)block;
                block = world.getBlockEntity(respawnPos);
                if (block instanceof CheckpointFlagBlockEntity) {
                    ItemStack storedItem;
                    CheckpointFlagBlockEntity flagBE = (CheckpointFlagBlockEntity)block;
                    if (((Boolean)ConfigRegistry.CHECKPOINT_FLAG_RESPAWN_USES_ITEMS.get()).booleanValue() && !(storedItem = flagBE.getTheItem()).isEmpty()) {
                        CheckpointFlagBlock.spawnFromCheckpointFlag(world, respawnPos, storedItem, (LivingEntity)player, true);
                        MarioverseSoundTypes.playSounds(world, respawnPos, storedItem);
                        flagBE.splitTheItem(1);
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            BlockPos posBelowEntity = BlockPos.containing((double)player.position().x, (double)(player.position().y - 0.3), (double)player.position().z);
            BlockState stateBelowEntity = player.level().getBlockState(posBelowEntity);
            if (!player.isSpectator() && (KeybindRegistry.ACTIVATE_POWER_UP.isDown() || player.isSprinting() && ((Boolean)ConfigRegistry.RUNNING_ACTIVATES_POWER_UPS.get()).booleanValue())) {
                PacketDistributor.sendToServer((CustomPacketPayload)new FireballShootPayload(player.blockPosition()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                PacketDistributor.sendToServer((CustomPacketPayload)new IceBallShootPayload(player.blockPosition()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (stateBelowEntity.is(TagRegistry.BOUNCY_BLOCKS) && !player.getType().is(TagRegistry.CANNOT_BOUNCE_ON_BLOCKS) && !player.isSuppressingBounce() && !player.isNoGravity()) {
                if (Minecraft.getInstance().options.keyJump.isDown()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new BouncePayload(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    PacketDistributor.sendToServer((CustomPacketPayload)new BouncePayload(false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            if (((Boolean)ConfigRegistry.ENABLE_STOMPABLE_ENEMIES.get()).booleanValue() && (player.getType().is(TagRegistry.CAN_STOMP_ENEMIES) || ((Boolean)ConfigRegistry.ALL_MOBS_CAN_STOMP.get()).booleanValue() || player.level().getGameRules().getBoolean(Marioverse.ALL_MOBS_CAN_STOMP)) && (player.fallDistance > 0.0f || player.isInWaterOrBubble())) {
                if (Minecraft.getInstance().options.keyJump.isDown()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new SquashEntityPayload(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    PacketDistributor.sendToServer((CustomPacketPayload)new SquashEntityPayload(false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        MarioverseEventHandlers.removeMiniGoombaSpeedModifier((LivingEntity)player);
    }

    @SubscribeEvent
    public static void onPlayerTeleport(EntityTeleportEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            MarioverseEventHandlers.removeMiniGoombaSpeedModifier(entity2);
        }
    }

    @SubscribeEvent
    public static void onDismount(EntityMountEvent event) {
        IceCubeEntity iceCube;
        Entity entity = event.getEntityBeingMounted();
        if (entity instanceof IceCubeEntity && (iceCube = (IceCubeEntity)entity).isAlive() && event.isDismounting()) {
            Player player;
            Entity entity2 = event.getEntityMounting();
            if (entity2 instanceof Player && !(player = (Player)entity2).isCreative() && player.isAlive()) {
                event.setCanceled(true);
            } else if (!(event.getEntityMounting() instanceof Player)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJump(LivingEvent.LivingJumpEvent event) {
        BlockEntity blockEntity;
        AbilitiesHandler handler;
        LivingEntity entity = event.getEntity();
        Level world = entity.level();
        BlockPos pos = entity.blockPosition();
        BlockPos posAboveEntity = pos.above(Math.round(entity.getBbHeight()));
        BlockState stateAboveEntity = world.getBlockState(posAboveEntity);
        if (!((Boolean)ConfigRegistry.DISABLE_JUMP_SOUND.get()).booleanValue() && !entity.isShiftKeyDown() && entity instanceof AbilitiesHandler && ((handler = (AbilitiesHandler)entity).mv$hasMarioCostume(entity) || handler.mv$hasLuigiCostume(entity) || handler.mv$hasPeachCostume(entity))) {
            entity.level().playSound(null, entity.blockPosition(), entity instanceof Player ? (SoundEvent)SoundRegistry.PLAYER_JUMP.get() : (SoundEvent)SoundRegistry.MOB_JUMP.get(), entity instanceof Player ? SoundSource.PLAYERS : SoundSource.NEUTRAL);
        }
        if (stateAboveEntity.is(TagRegistry.SMASHABLE_BLOCKS) && entity.getType().is(TagRegistry.CAN_SMASH_BLOCKS) && EventHooks.canEntityGrief((Level)world, (Entity)entity) && !entity.isSpectator() && !world.isClientSide && !((Boolean)entity.getData(DataAttachmentRegistry.HAS_HIT_BLOCK.get())).booleanValue() && entity instanceof AbilitiesHandler) {
            handler = (AbilitiesHandler)entity;
            handler.mv$smashBlock(world, posAboveEntity, stateAboveEntity, (Entity)entity);
        }
        if ((blockEntity = world.getBlockEntity(posAboveEntity)) instanceof QuestionBlockEntity) {
            QuestionBlockEntity questionBlockEntity = (QuestionBlockEntity)blockEntity;
            if (entity.getType().is(TagRegistry.CAN_HIT_QUESTION_BLOCKS) && EventHooks.canEntityGrief((Level)world, (Entity)entity) && !entity.isSpectator() && !world.isClientSide && !((Boolean)entity.getData(DataAttachmentRegistry.HAS_HIT_BLOCK.get())).booleanValue() && entity instanceof AbilitiesHandler) {
                AbilitiesHandler handler2 = (AbilitiesHandler)entity;
                handler2.mv$hitQuestionBlock(world, posAboveEntity, (Entity)entity, questionBlockEntity);
            }
        }
        if (stateAboveEntity.is(TagRegistry.BONKABLE_BLOCKS) && entity.getType().is(TagRegistry.CAN_BONK_BLOCKS) && !entity.isSpectator() && !world.isClientSide) {
            if (stateAboveEntity.hasProperty((Property)QuestionBlock.EMPTY) && ((Boolean)stateAboveEntity.getValue((Property)QuestionBlock.EMPTY)).booleanValue()) {
                world.playSound(null, posAboveEntity, (SoundEvent)SoundRegistry.BLOCK_BONK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                world.playSound(null, posAboveEntity, (SoundEvent)SoundRegistry.BLOCK_BONK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    private static void removeMiniGoombaSpeedModifier(LivingEntity entity) {
        AttributeInstance speedAttribute = entity.getAttribute(Attributes.MOVEMENT_SPEED);
        if (speedAttribute != null && speedAttribute.hasModifier(SLOWDOWN_MODIFIER)) {
            speedAttribute.removeModifier(SLOWDOWN_MODIFIER);
        }
    }
}

