/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.items;

import com.wenxin2.marioverse.entities.KoopaShellEntity;
import com.wenxin2.marioverse.items.BetterSpawnEggItem;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class KoopaShellItem
extends BetterSpawnEggItem {
    public KoopaShellItem(Supplier<? extends EntityType<? extends Mob>> entityType, int primaryColor, int secondaryColor, Item.Properties properties) {
        super(entityType, primaryColor, secondaryColor, properties);
    }

    public KoopaShellItem(int tooltipLineAmt, Supplier<? extends EntityType<? extends Mob>> entityType, int primaryColor, int secondaryColor, Item.Properties properties) {
        super(entityType, primaryColor, secondaryColor, properties);
        this.tooltipLineAmt = tooltipLineAmt;
    }

    @Override
    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        if (context.getPlayer() != null && context.getPlayer().getType().is(TagRegistry.CAN_PICKUP_AND_THROW_SHELLS)) {
            return super.useOn(context);
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        EntityType entityType = this.getType(stack);
        Entity entity = entityType.create(world);
        if (entity instanceof KoopaShellEntity) {
            KoopaShellEntity shell = (KoopaShellEntity)entity;
            if (player.getType().is(TagRegistry.CAN_PICKUP_AND_THROW_SHELLS)) {
                this.throwShell(world, (LivingEntity)player, shell, stack);
                return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide());
            }
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    @NotNull
    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity livingEntity, InteractionHand hand) {
        EntityType entityType = this.getType(stack);
        Entity entity = entityType.create(player.level());
        if (entity instanceof KoopaShellEntity) {
            KoopaShellEntity shell = (KoopaShellEntity)entity;
            if (player.getType().is(TagRegistry.CAN_PICKUP_AND_THROW_SHELLS)) {
                this.throwShell(player.level(), (LivingEntity)player, shell, stack);
                return InteractionResult.SUCCESS;
            }
        }
        return super.interactLivingEntity(stack, player, livingEntity, hand);
    }

    public void throwShell(Level world, LivingEntity entity, KoopaShellEntity shell, ItemStack stack) {
        double speed = 1.0;
        double spawnDistance = 1.0;
        Vec3 look = entity.getLookAngle();
        Vec3 spawnPos = entity.position().add(look.x * spawnDistance, (double)entity.getEyeHeight() - 0.6 + look.y * spawnDistance, look.z * spawnDistance);
        shell.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
        world.addFreshEntity((Entity)shell);
        if (look.y >= 0.9) {
            shell.setDeltaMovement(look.x, 1.25, look.z);
            world.playSound((Entity)entity, entity.blockPosition(), (SoundEvent)SoundRegistry.KOOPA_SHELL_THROWN_UP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        } else {
            shell.setDeltaMovement(look.x * speed, look.y * speed, look.z * speed);
            world.playSound((Entity)entity, entity.blockPosition(), (SoundEvent)SoundRegistry.KOOPA_SHELL_THROWN.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        shell.hasImpulse = true;
        shell.setOwner((Entity)entity);
        world.gameEvent((Entity)entity, (Holder)GameEvent.ENTITY_PLACE, spawnPos);
        if (!entity.getType().is(TagRegistry.HAS_INFINITE_SHELL_AMMO)) {
            stack.consume(1, entity);
        }
    }
}

