/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wenxin2.marioverse.Marioverse;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class AddItemsModifier
extends LootModifier {
    public static final MapCodec<AddItemsModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> LootModifier.codecStart((RecordCodecBuilder.Instance)instance).and((App)ExtraCodecs.nonEmptyList((Codec)BuiltInRegistries.ITEM.byNameCodec().listOf()).fieldOf("items").forGetter(o -> o.itemList)).apply((Applicative)instance, AddItemsModifier::new));
    public static final Supplier<MapCodec<AddItemsModifier>> ADD_ITEMS_MODIFIER = Marioverse.GLOBAL_LOOT_MODIFIERS.register("add_items_modifier", () -> CODEC);
    private final List<Item> itemList;

    public AddItemsModifier(LootItemCondition[] conditions, List<Item> itemList) {
        super(conditions);
        this.itemList = itemList;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return ADD_ITEMS_MODIFIER.get();
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ObjectArrayList newLoot = new ObjectArrayList();
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)context)) continue;
            return generatedLoot;
        }
        this.itemList.forEach(item -> generatedLoot.add((Object)item.getDefaultInstance()));
        newLoot.add((Object)((ItemStack)Util.getRandom(generatedLoot, (RandomSource)context.getRandom())));
        return newLoot;
    }
}

