/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.mixin;

import com.wenxin2.marioverse.blocks.CoinBlock;
import com.wenxin2.marioverse.blocks.StarCoinBlock;
import com.wenxin2.marioverse.blocks.entities.QuestionBlockEntity;
import com.wenxin2.marioverse.entities.PiranhaPlantEntity;
import com.wenxin2.marioverse.entities.projectiles.LargeSnowballProjectile;
import com.wenxin2.marioverse.integration.CompatRegistry;
import com.wenxin2.marioverse.items.BasePowerUpItem;
import com.wenxin2.marioverse.items.DashMushroomItem;
import com.wenxin2.marioverse.items.LargeSnowballItem;
import com.wenxin2.marioverse.items.PiranhaPlantPodItem;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownExperienceBottle;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.ArmorStandItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.EndCrystalItem;
import net.minecraft.world.item.ExperienceBottleItem;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.WindChargeItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Containers.class})
public class ContainersMixin {
    @Inject(method={"dropContents(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/Container;)V"}, at={@At(value="HEAD")})
    private static void dropContents(Level world, double x, double y, double z, Container container, CallbackInfo ci) {
        block6: {
            block5: {
                if (!(container instanceof DecoratedPotBlockEntity)) break block5;
                DecoratedPotBlockEntity decoratedPotBE = (DecoratedPotBlockEntity)container;
                if (((Boolean)ConfigRegistry.DISABLE_DECORATED_POT_TWEAKS.get()).booleanValue()) break block5;
                for (int i = 0; i < container.getContainerSize(); ++i) {
                    ContainersMixin.mv$playSounds(world, decoratedPotBE.getBlockPos(), container.getItem(i), (Container)decoratedPotBE);
                    int mv$stackCount = decoratedPotBE.getTheItem().getCount();
                    for (int j = 0; j < mv$stackCount; ++j) {
                        ContainersMixin.mv$spawnFromContainer(world, decoratedPotBE.getBlockPos(), container.getItem(i), (Boolean)ConfigRegistry.DECORATED_POT_SPAWNS_MOBS.get(), (Boolean)ConfigRegistry.DECORATED_POT_SPAWNS_POWER_UPS.get(), (Boolean)ConfigRegistry.DECORATED_POT_BUCKET_TWEAKS.get(), TagRegistry.DECORATED_POT_CANNOT_SPAWN);
                    }
                    decoratedPotBE.removeTheItem();
                }
                break block6;
            }
            if (!(container instanceof QuestionBlockEntity)) break block6;
            QuestionBlockEntity questionBE = (QuestionBlockEntity)container;
            for (int i = 0; i < container.getContainerSize(); ++i) {
                int j;
                ContainersMixin.mv$playSounds(world, questionBE.getBlockPos(), container.getItem(i), (Container)questionBE);
                int mv$stackCount = questionBE.getTheItem().getCount();
                for (j = 0; j < mv$stackCount; ++j) {
                    ContainersMixin.mv$spawnFromContainer(world, questionBE.getBlockPos(), container.getItem(i), (Boolean)ConfigRegistry.QUESTION_SPAWNS_MOBS.get(), (Boolean)ConfigRegistry.QUESTION_SPAWNS_POWER_UPS.get(), (Boolean)ConfigRegistry.QUESTION_BUCKET_TWEAKS.get(), TagRegistry.QUESTION_BLOCK_CANNOT_SPAWN);
                }
                for (j = 0; j < mv$stackCount; ++j) {
                    questionBE.removeTheItem();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Unique
    private static void mv$spawnFromContainer(Level world, BlockPos pos, ItemStack stack, boolean spawnMobs, boolean spawnPowerUps, boolean canEmptyBuckets, TagKey<EntityType<?>> cannotSpawn) {
        Item item;
        BlockItem blockItem;
        Item item2;
        Item item3;
        if (!(world instanceof ServerLevel)) return;
        ServerLevel serverWorld = (ServerLevel)world;
        Item item4 = stack.getItem();
        if (item4 instanceof BasePowerUpItem) {
            BasePowerUpItem powerUpItem = (BasePowerUpItem)item4;
            if (spawnPowerUps) {
                EntityType entityType = powerUpItem.getType(stack);
                if (!entityType.is(cannotSpawn)) {
                    entityType.spawn(serverWorld, stack, null, pos, MobSpawnType.SPAWN_EGG, true, false);
                    stack.copyWithCount(1);
                    return;
                }
                ContainersMixin.mv$spawnItem(world, pos, stack);
                return;
            }
        }
        if ((item3 = stack.getItem()) instanceof PiranhaPlantPodItem) {
            PiranhaPlantPodItem pod = (PiranhaPlantPodItem)item3;
            if (spawnMobs) {
                EntityType entityType = pod.getType(stack);
                if (entityType.is(cannotSpawn)) {
                    ContainersMixin.mv$spawnItem(world, pos, stack);
                    return;
                }
                Entity entity = entityType.spawn(serverWorld, stack, null, pos, MobSpawnType.SPAWN_EGG, true, false);
                if (entity instanceof PiranhaPlantEntity) {
                    PiranhaPlantEntity piranhaPlant = (PiranhaPlantEntity)entity;
                    piranhaPlant.setAge(-24000);
                }
                stack.copyWithCount(1);
                return;
            }
        }
        if ((item2 = stack.getItem()) instanceof SpawnEggItem) {
            SpawnEggItem spawnEgg = (SpawnEggItem)item2;
            if (spawnMobs) {
                EntityType entityType = spawnEgg.getType(stack);
                if (!entityType.is(cannotSpawn)) {
                    entityType.spawn(serverWorld, stack, null, pos, MobSpawnType.SPAWN_EGG, true, false);
                    stack.copyWithCount(1);
                    return;
                }
                ContainersMixin.mv$spawnItem(world, pos, stack);
                return;
            }
        }
        if (stack.getItem() instanceof LargeSnowballItem) {
            LargeSnowballProjectile largeSnowballProjectile = new LargeSnowballProjectile((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
            if (!largeSnowballProjectile.getType().is(cannotSpawn)) {
                largeSnowballProjectile.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
                world.addFreshEntity((Entity)largeSnowballProjectile);
                stack.copyWithCount(1);
                return;
            }
            ContainersMixin.mv$spawnItem(world, pos, stack);
            return;
        }
        if (stack.getItem() instanceof ArmorStandItem) {
            Consumer consumer = EntityType.createDefaultStackConfig((ServerLevel)serverWorld, (ItemStack)stack, null);
            ArmorStand armorStand = (ArmorStand)EntityType.ARMOR_STAND.create(serverWorld, consumer, pos, MobSpawnType.SPAWN_EGG, true, true);
            if (armorStand != null && !armorStand.getType().is(cannotSpawn)) {
                armorStand.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                world.addFreshEntity((Entity)armorStand);
                stack.copyWithCount(1);
                return;
            }
            ContainersMixin.mv$spawnItem(world, pos, stack);
            return;
        }
        Item item5 = stack.getItem();
        if (item5 instanceof MinecartItem) {
            MinecartItem cart = (MinecartItem)item5;
            AbstractMinecart abstractMinecart = AbstractMinecart.createMinecart((ServerLevel)serverWorld, (double)((double)pos.getX() + 0.5), (double)pos.getY(), (double)((double)pos.getZ() + 0.5), (AbstractMinecart.Type)cart.type, (ItemStack)stack, null);
            if (!abstractMinecart.getType().is(cannotSpawn)) {
                abstractMinecart.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                world.addFreshEntity((Entity)abstractMinecart);
                stack.copyWithCount(1);
                return;
            }
            ContainersMixin.mv$spawnItem(world, pos, stack);
            return;
        }
        Item item6 = stack.getItem();
        if (item6 instanceof BoatItem) {
            ChestBoat chestBoat;
            BoatItem boatItem = (BoatItem)item6;
            Object object = chestBoat = boatItem.hasChest ? new ChestBoat((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5) : new Boat((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            if (!chestBoat.getType().is(cannotSpawn)) {
                chestBoat.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                chestBoat.setVariant(boatItem.type);
                world.addFreshEntity((Entity)chestBoat);
                stack.copyWithCount(1);
                return;
            }
            ContainersMixin.mv$spawnItem(world, pos, stack);
            return;
        }
        Item item7 = stack.getItem();
        if (item7 instanceof BlockItem && (blockItem = (BlockItem)item7).getBlock() instanceof TntBlock) {
            PrimedTnt primedTnt = new PrimedTnt((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, null);
            if (!primedTnt.getType().is(cannotSpawn)) {
                primedTnt.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                world.addFreshEntity((Entity)primedTnt);
                stack.copyWithCount(1);
                serverWorld.gameEvent(null, (Holder)GameEvent.PRIME_FUSE, pos);
                return;
            }
            ContainersMixin.mv$spawnItem(world, pos, stack);
            return;
        }
        if (stack.getItem() instanceof WindChargeItem) {
            WindCharge windCharge = new WindCharge((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, new Vec3(0.0, -0.5, 0.0));
            if (!windCharge.getType().is(cannotSpawn)) {
                windCharge.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                world.addFreshEntity((Entity)windCharge);
                stack.copyWithCount(1);
                return;
            }
            ContainersMixin.mv$spawnItem(world, pos, stack);
            return;
        }
        if (stack.getItem() instanceof FireChargeItem) {
            SmallFireball smallFireball = new SmallFireball((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, new Vec3(0.0, -0.5, 0.0));
            if (!smallFireball.getType().is(cannotSpawn)) {
                smallFireball.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                world.addFreshEntity((Entity)smallFireball);
                stack.copyWithCount(1);
                return;
            }
            ContainersMixin.mv$spawnItem(world, pos, stack);
            return;
        }
        if (stack.getItem() instanceof ThrowablePotionItem) {
            ThrownPotion thrownPotion = new ThrownPotion((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            if (!thrownPotion.getType().is(cannotSpawn)) {
                thrownPotion.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
                thrownPotion.setItem(stack);
                world.addFreshEntity((Entity)thrownPotion);
                stack.copyWithCount(1);
                return;
            }
            ContainersMixin.mv$spawnItem(world, pos, stack);
            return;
        }
        if (stack.getItem() instanceof ExperienceBottleItem) {
            ThrownExperienceBottle thrownExperienceBottle = new ThrownExperienceBottle((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            if (!thrownExperienceBottle.getType().is(cannotSpawn)) {
                thrownExperienceBottle.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
                thrownExperienceBottle.setItem(stack);
                world.addFreshEntity((Entity)thrownExperienceBottle);
                stack.copyWithCount(1);
                return;
            }
            ContainersMixin.mv$spawnItem(world, pos, stack);
            return;
        }
        if (stack.getItem() instanceof EndCrystalItem) {
            EndCrystal endCrystal = new EndCrystal((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            if (!endCrystal.getType().is(cannotSpawn)) {
                endCrystal.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
                endCrystal.setDeltaMovement(new Vec3(0.0, -0.5, 0.0));
                endCrystal.setShowBottom(false);
                world.addFreshEntity((Entity)endCrystal);
                world.gameEvent(null, (Holder)GameEvent.ENTITY_PLACE, pos);
                stack.copyWithCount(1);
                return;
            }
            ContainersMixin.mv$spawnItem(world, pos, stack);
            return;
        }
        if (stack.getItem() instanceof FireworkRocketItem) {
            FireworkRocketEntity fireworkRocketEntity = new FireworkRocketEntity((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, stack);
            if (!fireworkRocketEntity.getType().is(cannotSpawn)) {
                fireworkRocketEntity.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                world.addFreshEntity((Entity)fireworkRocketEntity);
                stack.copyWithCount(1);
                return;
            }
            ContainersMixin.mv$spawnItem(world, pos, stack);
            return;
        }
        if (stack.getItem() instanceof EggItem) {
            ThrownEgg thrownEgg = new ThrownEgg((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            if (!thrownEgg.getType().is(cannotSpawn)) {
                thrownEgg.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
                thrownEgg.setItem(stack);
                world.addFreshEntity((Entity)thrownEgg);
                stack.copyWithCount(1);
                return;
            }
            ContainersMixin.mv$spawnItem(world, pos, stack);
            return;
        }
        Item item8 = stack.getItem();
        if (item8 instanceof BucketItem) {
            BucketItem bucket = (BucketItem)item8;
            if (bucket.content != Fluids.EMPTY && canEmptyBuckets) {
                if (bucket.emptyContents(null, world, pos, null, stack)) {
                    bucket.checkExtraContent(null, world, stack, pos);
                }
                ContainersMixin.mv$spawnItem(world, pos, new ItemStack((ItemLike)Items.BUCKET));
                return;
            }
        }
        if ((item = stack.getItem()) instanceof SolidBucketItem) {
            SolidBucketItem bucket = (SolidBucketItem)item;
            if (canEmptyBuckets) {
                if (bucket.emptyContents(null, world, pos, null, stack)) {
                    bucket.checkExtraContent(null, world, stack, pos);
                }
                ContainersMixin.mv$spawnItem(world, pos, new ItemStack((ItemLike)Items.BUCKET));
                return;
            }
        }
        if (stack.getItem() == CompatRegistry.HAT_STAND_ITEM.get()) {
            Entity entity = CompatRegistry.HAT_STAND.get().create((Level)serverWorld);
            if (entity != null && !entity.getType().is(cannotSpawn)) {
                entity.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                world.addFreshEntity(entity);
                stack.copyWithCount(1);
                return;
            }
            ContainersMixin.mv$spawnItem(world, pos, stack);
            return;
        }
        if (stack.getItem() == CompatRegistry.CANNONBALL_ITEM.get()) {
            Entity entity = CompatRegistry.CANNONBALL.get().create((Level)serverWorld);
            if (entity != null && !entity.getType().is(cannotSpawn)) {
                entity.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                entity.setDeltaMovement(new Vec3(world.random.triangle(0.0, 0.3), world.random.triangle(0.5, 0.3), world.random.triangle(0.0, 0.3)));
                world.addFreshEntity(entity);
                stack.copyWithCount(1);
                return;
            }
            ContainersMixin.mv$spawnItem(world, pos, stack);
            return;
        }
        if (stack.getItem() == CompatRegistry.BOMB_ITEM.get()) {
            Entity entity = CompatRegistry.BOMB.get().create((Level)serverWorld);
            if (entity != null && !entity.getType().is(cannotSpawn)) {
                if (world.getBlockState(pos.above()).isAir() || world.getFluidState(pos.above()).is(FluidTags.WATER)) {
                    entity.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
                    entity.setDeltaMovement(new Vec3(world.random.triangle(0.0, 0.2), world.random.triangle(0.5, 0.2), world.random.triangle(0.0, 0.2)));
                } else {
                    entity.setPos((double)pos.getX() + 0.5, (double)((float)pos.getY() - entity.getBbHeight()), (double)pos.getZ() + 0.5);
                    entity.setDeltaMovement(new Vec3(0.0, -0.5, 0.0));
                }
                world.addFreshEntity(entity);
                stack.copyWithCount(1);
                return;
            }
            ContainersMixin.mv$spawnItem(world, pos, stack);
            return;
        }
        if (stack.getItem() == CompatRegistry.BOMB_BLUE_ITEM.get()) {
            Entity entity = CompatRegistry.BOMB.get().create((Level)serverWorld);
            if (entity != null && !entity.getType().is(cannotSpawn)) {
                CompoundTag nbt = new CompoundTag();
                entity.save(nbt);
                nbt.putInt("Type", 1);
                entity.load(nbt);
                entity.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
                entity.setDeltaMovement(new Vec3(world.random.triangle(0.0, 0.2), world.random.triangle(0.5, 0.2), world.random.triangle(0.0, 0.2)));
                world.addFreshEntity(entity);
                stack.copyWithCount(1);
                return;
            }
            ContainersMixin.mv$spawnItem(world, pos, stack);
            return;
        }
        if (stack.getItem() == CompatRegistry.BOMB_SPIKY_ITEM.get()) {
            Entity entity = CompatRegistry.BOMB.get().create((Level)serverWorld);
            if (entity != null && !entity.getType().is(cannotSpawn)) {
                CompoundTag nbt = new CompoundTag();
                entity.save(nbt);
                nbt.putInt("Type", 2);
                entity.load(nbt);
                entity.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
                entity.setDeltaMovement(new Vec3(world.random.triangle(0.0, 0.2), world.random.triangle(0.5, 0.2), world.random.triangle(0.0, 0.2)));
                world.addFreshEntity(entity);
                stack.copyWithCount(1);
                return;
            }
            ContainersMixin.mv$spawnItem(world, pos, stack);
            return;
        }
        if (stack.getItem() == CompatRegistry.CONFETTI_POPPER_ITEM.get()) {
            Creeper creeper = (Creeper)EntityType.CREEPER.create((Level)serverWorld);
            if (creeper != null) {
                CompoundTag nbt = new CompoundTag();
                creeper.save(nbt);
                nbt.putBoolean("Party", true);
                nbt.putInt("Fuse", 0);
                creeper.setNoAi(true);
                creeper.ignite();
                creeper.setInvisible(true);
                creeper.setSilent(true);
                creeper.load(nbt);
                creeper.setPos((double)pos.getX() + 0.5, (double)pos.getY() - 1.0, (double)pos.getZ() + 0.5);
                world.broadcastEntityEvent((Entity)creeper, (byte)113);
                world.addFreshEntity((Entity)creeper);
            }
            world.gameEvent(null, (Holder)GameEvent.EXPLODE, pos);
            return;
        }
        if (stack.getItem() != CompatRegistry.ICE_BOMB_ITEM.get()) {
            ContainersMixin.mv$spawnItem(world, pos, stack);
            return;
        }
        Entity entity = CompatRegistry.ICE_BOMB.get().create((Level)serverWorld);
        if (entity != null && !entity.getType().is(cannotSpawn)) {
            entity.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            entity.setDeltaMovement(new Vec3(world.random.triangle(0.0, 0.2), world.random.triangle(0.5, 0.2), world.random.triangle(0.0, 0.2)));
            world.addFreshEntity(entity);
            stack.copyWithCount(1);
            return;
        }
        ContainersMixin.mv$spawnItem(world, pos, stack);
    }

    @Unique
    private static void mv$spawnItem(Level world, BlockPos pos, ItemStack stack) {
        ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, stack.split(world.random.nextInt(21) + 10));
        itemEntity.setDeltaMovement(world.random.triangle(0.0, 0.11485000171139836), world.random.triangle(0.2, 0.11485000171139836), world.random.triangle(0.0, 0.11485000171139836));
        world.addFreshEntity((Entity)itemEntity);
    }

    @Unique
    private static void mv$playSounds(Level world, BlockPos pos, ItemStack stack, Container container) {
        BlockItem blockItem;
        Item item = stack.getItem();
        if (item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof StarCoinBlock) {
            world.playSound(null, pos, (SoundEvent)SoundRegistry.STAR_COIN_PICKUP.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            BlockItem blockItem2;
            item = stack.getItem();
            if (item instanceof BlockItem && (blockItem2 = (BlockItem)item).getBlock() instanceof CoinBlock) {
                world.playSound(null, pos, (SoundEvent)SoundRegistry.COIN_PICKUP.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                BlockItem blockItem3;
                item = stack.getItem();
                if (item instanceof BlockItem && (blockItem3 = (BlockItem)item).getBlock() instanceof TntBlock) {
                    world.playSound(null, pos, SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() instanceof ArmorStandItem) {
                    world.playSound(null, pos, SoundEvents.ARMOR_STAND_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() instanceof BasePowerUpItem || stack.getItem() instanceof DashMushroomItem) {
                    world.playSound(null, pos, (SoundEvent)SoundRegistry.POWER_UP_SPAWNS.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() instanceof BoatItem) {
                    world.playSound(null, pos, SoundEvents.BOAT_PADDLE_WATER, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() instanceof EggItem) {
                    world.playSound(null, pos, SoundEvents.EGG_THROW, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() instanceof ExperienceBottleItem) {
                    world.playSound(null, pos, SoundEvents.EXPERIENCE_BOTTLE_THROW, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() instanceof FireChargeItem) {
                    world.playSound(null, pos, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() instanceof LingeringPotionItem) {
                    world.playSound(null, pos, SoundEvents.LINGERING_POTION_THROW, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() instanceof MinecartItem) {
                    world.playSound(null, pos, SoundEvents.MINECART_RIDING, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() instanceof PotionItem) {
                    world.playSound(null, pos, SoundEvents.SPLASH_POTION_THROW, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() instanceof SpawnEggItem) {
                    world.playSound(null, pos, (SoundEvent)SoundRegistry.MOB_SPAWNS.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() instanceof WindChargeItem) {
                    world.playSound(null, pos, SoundEvents.WIND_CHARGE_THROW, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() == CompatRegistry.BOMB_ITEM.get() || stack.getItem() == CompatRegistry.BOMB_BLUE_ITEM.get() || stack.getItem() == CompatRegistry.BOMB_SPIKY_ITEM.get()) {
                    world.playSound(null, pos, CompatRegistry.BOMB_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() == CompatRegistry.CANNONBALL_ITEM.get()) {
                    world.playSound(null, pos, CompatRegistry.CANNON_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() == CompatRegistry.CONFETTI_POPPER_ITEM.get()) {
                    world.playSound(null, pos, CompatRegistry.CONFETTI_POPPER_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() == CompatRegistry.HAT_STAND_ITEM.get()) {
                    world.playSound(null, pos, SoundEvents.ARMOR_STAND_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() == CompatRegistry.ICE_BOMB_ITEM.get()) {
                    world.playSound(null, pos, CompatRegistry.ICE_BOMB_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (!stack.isEmpty() && !(container instanceof DecoratedPotBlockEntity)) {
                    world.playSound(null, pos, (SoundEvent)SoundRegistry.ITEM_SPAWNS.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
        }
    }
}

