/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.wenxin2.marioverse.blocks.WarpPipeBlock;
import com.wenxin2.marioverse.blocks.entities.WarpDoorBlockEntity;
import com.wenxin2.marioverse.blocks.entities.WarpTrapDoorBlockEntity;
import com.wenxin2.marioverse.entities.IceCubeEntity;
import com.wenxin2.marioverse.registries.AttributesRegistry;
import com.wenxin2.marioverse.registries.BlockRegistry;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.BlockWarpEntityHandler;
import com.wenxin2.marioverse.utils.EntityWarpEntityHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements BlockWarpEntityHandler,
EntityWarpEntityHandler {
    @Unique
    protected float mv$appliedHeightScale = 1.0f;
    @Unique
    protected float mv$appliedWidthScale = 1.0f;
    @Unique
    private boolean mv$preventWarp;
    @Unique
    private int mv$preventWarpCooldown;
    @Unique
    private int mv$warpCooldown;

    @Shadow
    public abstract Level level();

    @Shadow
    public abstract double getX();

    @Shadow
    public abstract double getY();

    @Shadow
    public abstract double getZ();

    @Shadow
    public abstract float getBbHeight();

    @Shadow
    public abstract int getId();

    @Shadow
    public abstract BlockPos blockPosition();

    @Shadow
    public abstract EntityType<?> getType();

    @Shadow
    public abstract void setPos(Vec3 var1);

    @Override
    public boolean mv$getBlockWarpTeleportConfig() {
        return (Boolean)ConfigRegistry.TELEPORT_NON_MOBS.get();
    }

    @Override
    public boolean mv$getEntityWarpTeleportConfig() {
        return (Boolean)ConfigRegistry.TELEPORT_NON_MOBS.get();
    }

    @Inject(method={"save"}, at={@At(value="TAIL")})
    public void save(CompoundTag tag, CallbackInfoReturnable<Boolean> cir) {
        Entity entity = (Entity)this;
        if (!entity.getType().is(TagRegistry.CANNOT_WARP) && ((Boolean)ConfigRegistry.TELEPORT_NON_MOBS.get()).booleanValue()) {
            tag.putBoolean("marioverse:prevent_warp", this.mv$doPreventWarp());
            tag.putInt("marioverse:warp_cooldown", this.mv$getWarpCooldown());
        }
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    public void load(CompoundTag tag, CallbackInfo ci) {
        Entity entity = (Entity)this;
        if (!entity.getType().is(TagRegistry.CANNOT_WARP) && ((Boolean)ConfigRegistry.TELEPORT_NON_MOBS.get()).booleanValue()) {
            this.mv$setPreventWarp(tag.getBoolean("marioverse:prevent_warp"));
            this.mv$setWarpCooldown(tag.getInt("marioverse:warp_cooldown"));
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    public void tick(CallbackInfo ci) {
        float f7;
        float f6;
        Entity entity = (Entity)this;
        Level world = entity.level();
        BlockPos pos = entity.blockPosition();
        BlockPos posAboveEntity = pos.above(Math.round(entity.getBbHeight()));
        BlockPos posInBlock = pos.above(Math.round(entity.getBbHeight()) - 1);
        BlockState state = world.getBlockState(pos);
        BlockState stateAboveEntity = world.getBlockState(posAboveEntity);
        BlockState stateInBlock = world.getBlockState(posInBlock);
        if (this.mv$getWarpCooldown() > 0) {
            this.mv$setWarpCooldown(this.mv$getWarpCooldown() - 1);
        }
        EntityMixin.mv$rideIceCube(entity);
        for (Direction facing : Direction.values()) {
            BlockPos offsetPos = pos.relative(facing);
            BlockState offsetState = world.getBlockState(offsetPos);
            if (this.mv$doPreventWarp() && !(entity instanceof Player)) continue;
            if (offsetState.getBlock() instanceof WarpPipeBlock && !((Boolean)offsetState.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue()) {
                this.enterWarp(entity, world, offsetPos);
            }
            if (!(state.getBlock() instanceof WarpPipeBlock) || ((Boolean)state.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue()) continue;
            this.enterWarp(entity, world, pos);
        }
        if (stateAboveEntity.getBlock() instanceof WarpPipeBlock && !((Boolean)stateAboveEntity.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() && !this.mv$doPreventWarp()) {
            this.enterWarp(entity, world, pos);
        }
        if (!((Boolean)ConfigRegistry.DISABLE_WARP_DOORS.get()).booleanValue() && world.getBlockEntity(pos) instanceof WarpDoorBlockEntity && state.getBlock() instanceof DoorBlock && ((Boolean)state.getValue((Property)DoorBlock.OPEN)).booleanValue() && state.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.LOWER && !this.mv$doPreventWarp()) {
            this.enterWarp(entity, world, pos);
        }
        if (!((Boolean)ConfigRegistry.DISABLE_WARP_TRAPDOORS.get()).booleanValue() && world.getBlockEntity(pos) instanceof WarpTrapDoorBlockEntity && state.getBlock() instanceof TrapDoorBlock && ((Boolean)state.getValue((Property)TrapDoorBlock.OPEN)).booleanValue() && !this.mv$doPreventWarp()) {
            this.enterWarp(entity, world, pos);
        }
        if (!((Boolean)ConfigRegistry.DISABLE_WARP_TRAPDOORS.get()).booleanValue() && world.getBlockEntity(posInBlock) instanceof WarpTrapDoorBlockEntity && stateInBlock.getBlock() instanceof TrapDoorBlock && ((Boolean)stateInBlock.getValue((Property)TrapDoorBlock.OPEN)).booleanValue() && !this.mv$doPreventWarp()) {
            this.enterWarp(entity, world, posInBlock);
        }
        if (!((Boolean)ConfigRegistry.DISABLE_WARP_PAINTINGS.get()).booleanValue() && !this.mv$doPreventWarp()) {
            this.enterWarp(entity, world);
        }
        if ((f6 = this.mv$getHeightScale()) != this.mv$appliedHeightScale) {
            this.mv$appliedHeightScale = f6;
            entity.refreshDimensions();
        }
        if ((f7 = this.mv$getWidthScale()) != this.mv$appliedWidthScale) {
            this.mv$appliedWidthScale = f6;
            entity.refreshDimensions();
        }
    }

    @ModifyReturnValue(method={"isInWaterOrBubble"}, at={@At(value="RETURN")})
    private boolean isInWaterOrBubble(boolean original) {
        BlockState state = this.level().getBlockState(this.blockPosition());
        if (!original && state.is((Block)BlockRegistry.PIPE_BUBBLES.get())) {
            return true;
        }
        return original;
    }

    @ModifyReturnValue(method={"isInWaterRainOrBubble"}, at={@At(value="RETURN")})
    private boolean isInWaterRainOrBubble(boolean original) {
        BlockState state = this.level().getBlockState(this.blockPosition());
        if (!original && state.is((Block)BlockRegistry.PIPE_BUBBLES.get())) {
            return true;
        }
        return original;
    }

    @Override
    public boolean mv$doPreventWarp() {
        return this.mv$preventWarp;
    }

    @Override
    public void mv$setPreventWarp(boolean preventWarp) {
        this.mv$preventWarp = preventWarp;
    }

    @Override
    public int mv$getPreventWarpCooldown() {
        return this.mv$preventWarpCooldown;
    }

    @Override
    public void mv$setPreventWarpCooldown(int preventWarpCooldown) {
        this.mv$preventWarpCooldown = preventWarpCooldown;
    }

    @Override
    public int mv$getWarpCooldown() {
        return this.mv$warpCooldown;
    }

    @Override
    public void mv$setWarpCooldown(int warpCooldown) {
        this.mv$warpCooldown = warpCooldown;
    }

    @Inject(method={"handleEntityEvent"}, at={@At(value="HEAD")})
    private void handleEntityEvent(byte id, CallbackInfo ci) {
        Entity entity = (Entity)this;
        RandomSource random = entity.getRandom();
        if (id == 120) {
            for (int i = 0; i < 100; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.ENCHANT, entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), (random.nextDouble() - 0.5) * 2.0, -random.nextDouble(), (random.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    @Inject(method={"getBbHeight"}, at={@At(value="HEAD")}, cancellable=true)
    private void getBbHeight(CallbackInfoReturnable<Float> cir) {
        LivingEntity livingEntity;
        AttributeMap attributeMap;
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity && (attributeMap = (livingEntity = (LivingEntity)entity).getAttributes()) != null) {
            float height = entity.getDimensions(entity.getPose()).height();
            cir.setReturnValue((Object)Float.valueOf(height));
        }
    }

    @Inject(method={"getBbWidth"}, at={@At(value="HEAD")}, cancellable=true)
    private void getBbWidth(CallbackInfoReturnable<Float> cir) {
        LivingEntity livingEntity;
        AttributeMap attributeMap;
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity && (attributeMap = (livingEntity = (LivingEntity)entity).getAttributes()) != null) {
            float width = entity.getDimensions(entity.getPose()).width();
            cir.setReturnValue((Object)Float.valueOf(width));
        }
    }

    @Inject(method={"isInWall"}, at={@At(value="HEAD")}, cancellable=true)
    public void isInWall(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity;
        AttributeMap attributeMap;
        Entity entity = (Entity)this;
        if (entity.noPhysics) {
            cir.setReturnValue((Object)false);
            return;
        }
        if (entity instanceof LivingEntity && (attributeMap = (livingEntity = (LivingEntity)entity).getAttributes()) != null) {
            float widthScale = (float)attributeMap.getValue(AttributesRegistry.WIDTH_SCALE);
            if (widthScale != 1.0f) {
                float scaledWidth = entity.getDimensions(entity.getPose()).width() * 0.8f * widthScale;
                AABB aabb = AABB.ofSize((Vec3)entity.getEyePosition(), (double)scaledWidth, (double)1.0E-6, (double)scaledWidth);
                boolean isInWall = BlockPos.betweenClosedStream((AABB)aabb).anyMatch(pos -> {
                    BlockState blockState = entity.level().getBlockState(pos);
                    return !blockState.isAir() && blockState.isSuffocating((BlockGetter)entity.level(), pos) && Shapes.joinIsNotEmpty((VoxelShape)blockState.getCollisionShape((BlockGetter)entity.level(), pos).move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), (VoxelShape)Shapes.create((AABB)aabb), (BooleanOp)BooleanOp.AND);
                });
                cir.setReturnValue((Object)isInWall);
            } else {
                cir.setReturnValue((Object)((Boolean)cir.getReturnValue()));
            }
        }
    }

    @Unique
    private static void mv$rideIceCube(Entity entity) {
        IceCubeEntity iceCube;
        Vec3 iceMovement;
        Entity belowEntity = null;
        for (Entity e : entity.level().getEntities(entity, entity.getBoundingBox().move(0.0, -1.0, 0.0))) {
            if (!(e instanceof IceCubeEntity)) continue;
            belowEntity = e;
            break;
        }
        if (belowEntity instanceof IceCubeEntity && !(iceMovement = (iceCube = (IceCubeEntity)belowEntity).getDeltaMovement()).equals((Object)Vec3.ZERO)) {
            entity.setDeltaMovement(iceMovement.x, 0.0, iceMovement.z);
            entity.move(MoverType.SELF, iceMovement);
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.getNavigation().stop();
            }
        }
    }

    @Unique
    public float mv$getHeightScale() {
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            AttributeMap attributeMap = livingEntity.getAttributes();
            return attributeMap == null ? 1.0f : this.mv$sanitizeScales((float)attributeMap.getValue(AttributesRegistry.HEIGHT_SCALE));
        }
        return 1.0f;
    }

    @Unique
    public float mv$getWidthScale() {
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            AttributeMap attributeMap = livingEntity.getAttributes();
            return attributeMap == null ? 1.0f : this.mv$sanitizeScales((float)attributeMap.getValue(AttributesRegistry.WIDTH_SCALE));
        }
        return 1.0f;
    }

    @Unique
    public float mv$sanitizeScales(float scale) {
        return scale;
    }
}

