/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.registries;

import com.wenxin2.marioverse.Marioverse;
import com.wenxin2.marioverse.items.BasePowerUpItem;
import com.wenxin2.marioverse.items.BetterSpawnEggItem;
import com.wenxin2.marioverse.items.CharacterSmithingTemplateItem;
import com.wenxin2.marioverse.items.CheckpointFlagBlockItem;
import com.wenxin2.marioverse.items.ChristmasHatItem;
import com.wenxin2.marioverse.items.CostumeItem;
import com.wenxin2.marioverse.items.DashMushroomItem;
import com.wenxin2.marioverse.items.FluidPlasticBucketItem;
import com.wenxin2.marioverse.items.KoopaShellItem;
import com.wenxin2.marioverse.items.KoopaShoesItem;
import com.wenxin2.marioverse.items.LargeSnowballItem;
import com.wenxin2.marioverse.items.OneUpMushroomItem;
import com.wenxin2.marioverse.items.PiranhaPlantPodItem;
import com.wenxin2.marioverse.items.PlasticBucketItem;
import com.wenxin2.marioverse.items.PokeySpawnEggItem;
import com.wenxin2.marioverse.items.SnowPokeySpawnEggItem;
import com.wenxin2.marioverse.items.SolidPlasticBucketItem;
import com.wenxin2.marioverse.items.StarCoinBlockItem;
import com.wenxin2.marioverse.items.WarpDisruptorItem;
import com.wenxin2.marioverse.items.WrenchItem;
import com.wenxin2.marioverse.registries.BlockRegistry;
import com.wenxin2.marioverse.registries.EntityRegistry;
import com.wenxin2.marioverse.registries.FoodRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredItem;

public class ItemRegistry {
    public static final EnumMap<DyeColor, DeferredItem<Item>> CHECKPOINT_FLAGS = new EnumMap(DyeColor.class);
    public static final DeferredItem<Item> BOO_SPAWN_EGG;
    public static final DeferredItem<Item> BOWSER_BANNER_PATTERN;
    public static final DeferredItem<Item> BOWSER_POTTERY_SHERD;
    public static final DeferredItem<Item> CHRISTMAS_HAT;
    public static final DeferredItem<Item> CLASSIC_CHECKPOINT_FLAG;
    public static final DeferredItem<Item> DASH_MUSHROOM;
    public static final DeferredItem<Item> DRY_BONES_SPAWN_EGG;
    public static final DeferredItem<Item> FIRE_COSTUME_SMITHING_TEMPLATE;
    public static final DeferredItem<Item> FIRE_FLOWER;
    public static final DeferredItem<Item> FIRE_GOOMBA_SPAWN_EGG;
    public static final DeferredItem<Item> GOLDEN_KOOPA_SHOES;
    public static final DeferredItem<Item> GOLD_KOOPA_SHELL;
    public static final DeferredItem<Item> GOLD_KOOPA_TROOPA_SPAWN_EGG;
    public static final DeferredItem<Item> GOOMBA_SPAWN_EGG;
    public static final DeferredItem<Item> GREEN_KOOPA_SHELL;
    public static final DeferredItem<Item> GREEN_KOOPA_SHOES;
    public static final DeferredItem<Item> GREEN_KOOPA_TROOPA_SPAWN_EGG;
    public static final DeferredItem<Item> HEFTY_GOOMBA_SPAWN_EGG;
    public static final DeferredItem<Item> ICE_COSTUME_SMITHING_TEMPLATE;
    public static final DeferredItem<Item> ICE_FLOWER;
    public static final DeferredItem<Item> LARGE_SNOWBALL;
    public static final DeferredItem<Item> LUIGI_COSTUME_SMITHING_TEMPLATE;
    public static final DeferredItem<Item> LUIGI_FIRE_HAT;
    public static final DeferredItem<Item> LUIGI_FIRE_PANTS;
    public static final DeferredItem<Item> LUIGI_FIRE_SHIRT;
    public static final DeferredItem<Item> LUIGI_FIRE_SHOES;
    public static final DeferredItem<Item> LUIGI_HAT;
    public static final DeferredItem<Item> LUIGI_ICE_HAT;
    public static final DeferredItem<Item> LUIGI_ICE_PANTS;
    public static final DeferredItem<Item> LUIGI_ICE_SHIRT;
    public static final DeferredItem<Item> LUIGI_ICE_SHOES;
    public static final DeferredItem<Item> LUIGI_PANTS;
    public static final DeferredItem<Item> LUIGI_SHIRT;
    public static final DeferredItem<Item> LUIGI_SHOES;
    public static final DeferredItem<Item> MARIO_COSTUME_SMITHING_TEMPLATE;
    public static final DeferredItem<Item> MARIO_FIRE_HAT;
    public static final DeferredItem<Item> MARIO_FIRE_PANTS;
    public static final DeferredItem<Item> MARIO_FIRE_SHIRT;
    public static final DeferredItem<Item> MARIO_FIRE_SHOES;
    public static final DeferredItem<Item> MARIO_HAT;
    public static final DeferredItem<Item> MARIO_ICE_HAT;
    public static final DeferredItem<Item> MARIO_ICE_PANTS;
    public static final DeferredItem<Item> MARIO_ICE_SHIRT;
    public static final DeferredItem<Item> MARIO_ICE_SHOES;
    public static final DeferredItem<Item> MARIO_PANTS;
    public static final DeferredItem<Item> MARIO_SHIRT;
    public static final DeferredItem<Item> MARIO_SHOES;
    public static final DeferredItem<Item> MEGA_GOOMBA_SPAWN_EGG;
    public static final DeferredItem<Item> MINI_GOOMBA_SPAWN_EGG;
    public static final DeferredItem<Item> ONE_UP_MUSHROOM;
    public static final DeferredItem<Item> PEACH_BODICE;
    public static final DeferredItem<Item> PEACH_COSTUME_SMITHING_TEMPLATE;
    public static final DeferredItem<Item> PEACH_CROWN;
    public static final DeferredItem<Item> PEACH_DRESS;
    public static final DeferredItem<Item> PEACH_FIRE_BODICE;
    public static final DeferredItem<Item> PEACH_FIRE_DRESS;
    public static final DeferredItem<Item> PEACH_FIRE_SHOES;
    public static final DeferredItem<Item> PEACH_ICE_BODICE;
    public static final DeferredItem<Item> PEACH_ICE_DRESS;
    public static final DeferredItem<Item> PEACH_ICE_SHOES;
    public static final DeferredItem<Item> PEACH_SHOES;
    public static final DeferredItem<Item> PIRANHA_PLANT_POD;
    public static final DeferredItem<Item> PIRANHA_PLANT_SPAWN_EGG;
    public static final DeferredItem<Item> PLASTIC_BUCKET;
    public static final DeferredItem<Item> PLUMBER_BANNER_PATTERN;
    public static final DeferredItem<Item> PLUMBER_POTTERY_SHERD;
    public static final DeferredItem<Item> POKEY_SPAWN_EGG;
    public static final DeferredItem<Item> PLASTIC_POWDER_SNOW_BUCKET;
    public static final DeferredItem<Item> QUICKSAND_BUCKET;
    public static final DeferredItem<Item> PLASTIC_QUICKSAND_BUCKET;
    public static final DeferredItem<Item> RED_KOOPA_SHELL;
    public static final DeferredItem<Item> RED_KOOPA_SHOES;
    public static final DeferredItem<Item> RED_KOOPA_TROOPA_SPAWN_EGG;
    public static final DeferredItem<Item> RED_QUICKSAND_BUCKET;
    public static final DeferredItem<Item> PLASTIC_RED_QUICKSAND_BUCKET;
    public static final DeferredItem<Item> SNOW_POKEY_SPAWN_EGG;
    public static final DeferredItem<Item> SPLUNKIN_SPAWN_EGG;
    public static final DeferredItem<Item> STAR_COIN;
    public static final DeferredItem<Item> SUPER_MUSHROOM;
    public static final DeferredItem<Item> SUPER_STAR;
    public static final DeferredItem<Item> WARP_DISRUPTOR;
    public static final DeferredItem<Item> PLASTIC_WATER_BUCKET;
    public static final DeferredItem<Item> WHITE_KOOPA_SHOES;
    public static final DeferredItem<Item> WRENCH;

    public static <T extends Item> DeferredItem<T> registerItem(String name, Supplier<T> item) {
        return Marioverse.ITEMS.register(name, item);
    }

    public static void init() {
    }

    static {
        STAR_COIN = ItemRegistry.registerItem("star_coin", () -> new StarCoinBlockItem((Block)BlockRegistry.STAR_COIN.get(), new Item.Properties()));
        CLASSIC_CHECKPOINT_FLAG = ItemRegistry.registerItem("classic_checkpoint_flag", () -> new CheckpointFlagBlockItem((Block)BlockRegistry.CLASSIC_CHECKPOINT_FLAG.get(), new Item.Properties()));
        Arrays.stream(DyeColor.values()).forEach(color -> CHECKPOINT_FLAGS.put((DyeColor)color, ItemRegistry.registerItem(color.getName() + "_checkpoint_flag", () -> new CheckpointFlagBlockItem((Block)BlockRegistry.CHECKPOINT_FLAGS.get(color).get(), new Item.Properties()))));
        WRENCH = ItemRegistry.registerItem("wrench", () -> new WrenchItem(new Item.Properties().attributes(WrenchItem.createAttributes((Tier)Tiers.IRON, 3, -3.2f)).durability(128), (Tier)Tiers.IRON));
        QUICKSAND_BUCKET = ItemRegistry.registerItem("quicksand_bucket", () -> new SolidBucketItem((Block)BlockRegistry.QUICKSAND.get(), SoundEvents.BUCKET_EMPTY_POWDER_SNOW, new Item.Properties().stacksTo(1).craftRemainder(Items.BUCKET)));
        RED_QUICKSAND_BUCKET = ItemRegistry.registerItem("red_quicksand_bucket", () -> new SolidBucketItem((Block)BlockRegistry.RED_QUICKSAND.get(), SoundEvents.BUCKET_EMPTY_POWDER_SNOW, new Item.Properties().stacksTo(1).craftRemainder(Items.BUCKET)));
        PLASTIC_BUCKET = ItemRegistry.registerItem("plastic_bucket", () -> new PlasticBucketItem(2, Ingredient.of((TagKey)ItemTags.COALS), (Holder<ArmorMaterial>)ArmorMaterials.IRON, ArmorItem.Type.HELMET, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.HELMET.getDurability(10))));
        PLASTIC_WATER_BUCKET = ItemRegistry.registerItem("plastic_water_bucket", () -> new FluidPlasticBucketItem(3, (Fluid)Fluids.WATER, new Item.Properties().stacksTo(1).durability(128)));
        PLASTIC_POWDER_SNOW_BUCKET = ItemRegistry.registerItem("plastic_powder_snow_bucket", () -> new SolidPlasticBucketItem(2, Blocks.POWDER_SNOW, SoundEvents.BUCKET_EMPTY_POWDER_SNOW, new Item.Properties().stacksTo(1).durability(128).craftRemainder((Item)PLASTIC_BUCKET.get())));
        PLASTIC_QUICKSAND_BUCKET = ItemRegistry.registerItem("plastic_quicksand_bucket", () -> new SolidPlasticBucketItem(2, (Block)BlockRegistry.QUICKSAND.get(), SoundEvents.BUCKET_EMPTY_POWDER_SNOW, new Item.Properties().stacksTo(1).durability(128).craftRemainder((Item)PLASTIC_BUCKET.get())));
        PLASTIC_RED_QUICKSAND_BUCKET = ItemRegistry.registerItem("plastic_red_quicksand_bucket", () -> new SolidPlasticBucketItem(2, (Block)BlockRegistry.RED_QUICKSAND.get(), SoundEvents.BUCKET_EMPTY_POWDER_SNOW, new Item.Properties().stacksTo(1).durability(128).craftRemainder((Item)PLASTIC_BUCKET.get())));
        SUPER_MUSHROOM = ItemRegistry.registerItem("super_mushroom", () -> new BasePowerUpItem(2, (Supplier<? extends EntityType<? extends Mob>>)EntityRegistry.SUPER_MUSHROOM, 0xFFFFFF, 0xFFFFFF, new Item.Properties()));
        DASH_MUSHROOM = ItemRegistry.registerItem("dash_mushroom", () -> new DashMushroomItem(3, new Item.Properties().food(FoodRegistry.DASH_MUSHROOM)));
        ONE_UP_MUSHROOM = ItemRegistry.registerItem("one_up_mushroom", () -> new OneUpMushroomItem(4, (Supplier<? extends EntityType<? extends Mob>>)EntityRegistry.ONE_UP_MUSHROOM, 0xFFFFFF, 0xFFFFFF, new Item.Properties().stacksTo(1)));
        SUPER_STAR = ItemRegistry.registerItem("super_star", () -> new BasePowerUpItem(3, (Supplier<? extends EntityType<? extends Mob>>)EntityRegistry.SUPER_STAR, 0xFFFFFF, 0xFFFFFF, new Item.Properties()));
        FIRE_FLOWER = ItemRegistry.registerItem("fire_flower", () -> new BasePowerUpItem(2, (Supplier<? extends EntityType<? extends Mob>>)EntityRegistry.FIRE_FLOWER, 0xFFFFFF, 0xFFFFFF, new Item.Properties()));
        ICE_FLOWER = ItemRegistry.registerItem("ice_flower", () -> new BasePowerUpItem(2, (Supplier<? extends EntityType<? extends Mob>>)EntityRegistry.ICE_FLOWER, 0xFFFFFF, 0xFFFFFF, new Item.Properties()));
        LARGE_SNOWBALL = ItemRegistry.registerItem("large_snowball", () -> new LargeSnowballItem(new Item.Properties().stacksTo(16)));
        GOLD_KOOPA_SHELL = ItemRegistry.registerItem("gold_koopa_shell", () -> new KoopaShellItem(3, (Supplier<? extends EntityType<? extends Mob>>)EntityRegistry.GOLD_KOOPA_SHELL, 0xFFFFFF, 0xFFFFFF, new Item.Properties().stacksTo(16)));
        GREEN_KOOPA_SHELL = ItemRegistry.registerItem("green_koopa_shell", () -> new KoopaShellItem(2, (Supplier<? extends EntityType<? extends Mob>>)EntityRegistry.GREEN_KOOPA_SHELL, 0xFFFFFF, 0xFFFFFF, new Item.Properties().stacksTo(16)));
        RED_KOOPA_SHELL = ItemRegistry.registerItem("red_koopa_shell", () -> new KoopaShellItem(2, (Supplier<? extends EntityType<? extends Mob>>)EntityRegistry.RED_KOOPA_SHELL, 0xFFFFFF, 0xFFFFFF, new Item.Properties().stacksTo(16)));
        WARP_DISRUPTOR = ItemRegistry.registerItem("warp_disruptor", () -> new WarpDisruptorItem(new Item.Properties().durability(128)));
        PIRANHA_PLANT_POD = ItemRegistry.registerItem("piranha_plant_pod", () -> new PiranhaPlantPodItem(5, (Supplier<? extends EntityType<? extends Mob>>)EntityRegistry.PIRANHA_PLANT, 0xFFFFFF, 0xFFFFFF, new Item.Properties()));
        MARIO_COSTUME_SMITHING_TEMPLATE = ItemRegistry.registerItem("mario_costume_smithing_template", CharacterSmithingTemplateItem::createCharacterUpgradeTemplate);
        LUIGI_COSTUME_SMITHING_TEMPLATE = ItemRegistry.registerItem("luigi_costume_smithing_template", CharacterSmithingTemplateItem::createCharacterUpgradeTemplate);
        PEACH_COSTUME_SMITHING_TEMPLATE = ItemRegistry.registerItem("peach_costume_smithing_template", CharacterSmithingTemplateItem::createCharacterUpgradeTemplate);
        FIRE_COSTUME_SMITHING_TEMPLATE = ItemRegistry.registerItem("fire_costume_smithing_template", CharacterSmithingTemplateItem::createFireUpgradeTemplate);
        ICE_COSTUME_SMITHING_TEMPLATE = ItemRegistry.registerItem("ice_costume_smithing_template", CharacterSmithingTemplateItem::createIceUpgradeTemplate);
        CHRISTMAS_HAT = ItemRegistry.registerItem("christmas_hat", () -> new ChristmasHatItem(Ingredient.of((TagKey)ItemTags.WOOL), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.HELMET, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.HELMET.getDurability(8))));
        GOLDEN_KOOPA_SHOES = ItemRegistry.registerItem("golden_koopa_shoes", () -> new KoopaShoesItem(Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), (Holder<ArmorMaterial>)ArmorMaterials.GOLD, ArmorItem.Type.BOOTS, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.BOOTS.getDurability(12))));
        GREEN_KOOPA_SHOES = ItemRegistry.registerItem("green_koopa_shoes", () -> new KoopaShoesItem(Ingredient.of((ItemLike[])new ItemLike[]{Items.TURTLE_SCUTE}), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.BOOTS, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.BOOTS.getDurability(10))));
        RED_KOOPA_SHOES = ItemRegistry.registerItem("red_koopa_shoes", () -> new KoopaShoesItem(Ingredient.of((ItemLike[])new ItemLike[]{Items.TURTLE_SCUTE}), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.BOOTS, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.BOOTS.getDurability(10))));
        WHITE_KOOPA_SHOES = ItemRegistry.registerItem("white_koopa_shoes", () -> new KoopaShoesItem(Ingredient.of((ItemLike[])new ItemLike[]{Items.TURTLE_SCUTE}), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.BOOTS, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.BOOTS.getDurability(10))));
        MARIO_HAT = ItemRegistry.registerItem("mario_hat", () -> new CostumeItem(Ingredient.of((TagKey)ItemTags.WOOL), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.HELMET, "mario_costume", 4, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.HELMET.getDurability(10))));
        MARIO_SHIRT = ItemRegistry.registerItem("mario_shirt", () -> new CostumeItem(Ingredient.of((TagKey)ItemTags.WOOL), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.CHESTPLATE, "mario_costume", 4, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.CHESTPLATE.getDurability(10))));
        MARIO_PANTS = ItemRegistry.registerItem("mario_pants", () -> new CostumeItem(Ingredient.of((TagKey)ItemTags.WOOL), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.LEGGINGS, "mario_costume", 4, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.LEGGINGS.getDurability(10))));
        MARIO_SHOES = ItemRegistry.registerItem("mario_shoes", () -> new CostumeItem(Ingredient.of((TagKey)ItemTags.WOOL), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.BOOTS, "mario_costume", 4, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.BOOTS.getDurability(10))));
        LUIGI_HAT = ItemRegistry.registerItem("luigi_hat", () -> new CostumeItem(Ingredient.of((TagKey)ItemTags.WOOL), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.HELMET, "luigi_costume", 4, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.HELMET.getDurability(10))));
        LUIGI_SHIRT = ItemRegistry.registerItem("luigi_shirt", () -> new CostumeItem(Ingredient.of((TagKey)ItemTags.WOOL), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.CHESTPLATE, "luigi_costume", 4, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.CHESTPLATE.getDurability(10))));
        LUIGI_PANTS = ItemRegistry.registerItem("luigi_pants", () -> new CostumeItem(Ingredient.of((TagKey)ItemTags.WOOL), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.LEGGINGS, "luigi_costume", 4, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.LEGGINGS.getDurability(10))));
        LUIGI_SHOES = ItemRegistry.registerItem("luigi_shoes", () -> new CostumeItem(Ingredient.of((TagKey)ItemTags.WOOL), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.BOOTS, "luigi_costume", 4, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.BOOTS.getDurability(10))));
        PEACH_CROWN = ItemRegistry.registerItem("peach_crown", () -> new CostumeItem(Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), (Holder<ArmorMaterial>)ArmorMaterials.GOLD, ArmorItem.Type.HELMET, "peach_costume", 5, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.HELMET.getDurability(12))));
        PEACH_BODICE = ItemRegistry.registerItem("peach_bodice", () -> new CostumeItem(Ingredient.of((TagKey)ItemTags.WOOL), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.CHESTPLATE, "peach_costume", 5, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.CHESTPLATE.getDurability(10))));
        PEACH_DRESS = ItemRegistry.registerItem("peach_dress", () -> new CostumeItem(Ingredient.of((TagKey)ItemTags.WOOL), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.LEGGINGS, "peach_costume", 5, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.LEGGINGS.getDurability(10))));
        PEACH_SHOES = ItemRegistry.registerItem("peach_shoes", () -> new CostumeItem(Ingredient.of((TagKey)ItemTags.WOOL), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.BOOTS, "peach_costume", 5, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.BOOTS.getDurability(10))));
        MARIO_FIRE_HAT = ItemRegistry.registerItem("mario_fire_hat", () -> new CostumeItem(Ingredient.of((ItemLike[])new ItemLike[]{FIRE_FLOWER}), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.HELMET, "mario_costume", 4, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.HELMET.getDurability(10))));
        MARIO_FIRE_SHIRT = ItemRegistry.registerItem("mario_fire_shirt", () -> new CostumeItem(Ingredient.of((ItemLike[])new ItemLike[]{FIRE_FLOWER}), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.CHESTPLATE, "mario_costume", 4, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.CHESTPLATE.getDurability(10))));
        MARIO_FIRE_PANTS = ItemRegistry.registerItem("mario_fire_pants", () -> new CostumeItem(Ingredient.of((ItemLike[])new ItemLike[]{FIRE_FLOWER}), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.LEGGINGS, "mario_costume", 4, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.LEGGINGS.getDurability(10))));
        MARIO_FIRE_SHOES = ItemRegistry.registerItem("mario_fire_shoes", () -> new CostumeItem(Ingredient.of((ItemLike[])new ItemLike[]{FIRE_FLOWER}), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.BOOTS, "mario_costume", 4, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.BOOTS.getDurability(10))));
        LUIGI_FIRE_HAT = ItemRegistry.registerItem("luigi_fire_hat", () -> new CostumeItem(Ingredient.of((ItemLike[])new ItemLike[]{FIRE_FLOWER}), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.HELMET, "luigi_costume", 4, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.HELMET.getDurability(10))));
        LUIGI_FIRE_SHIRT = ItemRegistry.registerItem("luigi_fire_shirt", () -> new CostumeItem(Ingredient.of((ItemLike[])new ItemLike[]{FIRE_FLOWER}), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.CHESTPLATE, "luigi_costume", 4, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.CHESTPLATE.getDurability(10))));
        LUIGI_FIRE_PANTS = ItemRegistry.registerItem("luigi_fire_pants", () -> new CostumeItem(Ingredient.of((ItemLike[])new ItemLike[]{FIRE_FLOWER}), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.LEGGINGS, "luigi_costume", 4, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.LEGGINGS.getDurability(10))));
        LUIGI_FIRE_SHOES = ItemRegistry.registerItem("luigi_fire_shoes", () -> new CostumeItem(Ingredient.of((ItemLike[])new ItemLike[]{FIRE_FLOWER}), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.BOOTS, "luigi_costume", 4, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.BOOTS.getDurability(10))));
        PEACH_FIRE_BODICE = ItemRegistry.registerItem("peach_fire_bodice", () -> new CostumeItem(Ingredient.of((ItemLike[])new ItemLike[]{FIRE_FLOWER}), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.CHESTPLATE, "peach_costume", 5, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.CHESTPLATE.getDurability(10))));
        PEACH_FIRE_DRESS = ItemRegistry.registerItem("peach_fire_dress", () -> new CostumeItem(Ingredient.of((ItemLike[])new ItemLike[]{FIRE_FLOWER}), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.LEGGINGS, "peach_costume", 5, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.LEGGINGS.getDurability(10))));
        PEACH_FIRE_SHOES = ItemRegistry.registerItem("peach_fire_shoes", () -> new CostumeItem(Ingredient.of((ItemLike[])new ItemLike[]{FIRE_FLOWER}), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.BOOTS, "peach_costume", 5, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.BOOTS.getDurability(10))));
        MARIO_ICE_HAT = ItemRegistry.registerItem("mario_ice_hat", () -> new CostumeItem(Ingredient.of((ItemLike[])new ItemLike[]{ICE_FLOWER}), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.HELMET, "mario_costume", 4, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.HELMET.getDurability(10))));
        MARIO_ICE_SHIRT = ItemRegistry.registerItem("mario_ice_shirt", () -> new CostumeItem(Ingredient.of((ItemLike[])new ItemLike[]{ICE_FLOWER}), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.CHESTPLATE, "mario_costume", 4, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.CHESTPLATE.getDurability(10))));
        MARIO_ICE_PANTS = ItemRegistry.registerItem("mario_ice_pants", () -> new CostumeItem(Ingredient.of((ItemLike[])new ItemLike[]{ICE_FLOWER}), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.LEGGINGS, "mario_costume", 4, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.LEGGINGS.getDurability(10))));
        MARIO_ICE_SHOES = ItemRegistry.registerItem("mario_ice_shoes", () -> new CostumeItem(Ingredient.of((ItemLike[])new ItemLike[]{ICE_FLOWER}), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.BOOTS, "mario_costume", 4, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.BOOTS.getDurability(10))));
        LUIGI_ICE_HAT = ItemRegistry.registerItem("luigi_ice_hat", () -> new CostumeItem(Ingredient.of((ItemLike[])new ItemLike[]{ICE_FLOWER}), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.HELMET, "luigi_costume", 4, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.HELMET.getDurability(10))));
        LUIGI_ICE_SHIRT = ItemRegistry.registerItem("luigi_ice_shirt", () -> new CostumeItem(Ingredient.of((ItemLike[])new ItemLike[]{ICE_FLOWER}), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.CHESTPLATE, "luigi_costume", 4, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.CHESTPLATE.getDurability(10))));
        LUIGI_ICE_PANTS = ItemRegistry.registerItem("luigi_ice_pants", () -> new CostumeItem(Ingredient.of((ItemLike[])new ItemLike[]{ICE_FLOWER}), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.LEGGINGS, "luigi_costume", 4, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.LEGGINGS.getDurability(10))));
        LUIGI_ICE_SHOES = ItemRegistry.registerItem("luigi_ice_shoes", () -> new CostumeItem(Ingredient.of((ItemLike[])new ItemLike[]{ICE_FLOWER}), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.BOOTS, "luigi_costume", 4, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.BOOTS.getDurability(10))));
        PEACH_ICE_BODICE = ItemRegistry.registerItem("peach_ice_bodice", () -> new CostumeItem(Ingredient.of((ItemLike[])new ItemLike[]{ICE_FLOWER}), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.CHESTPLATE, "peach_costume", 5, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.CHESTPLATE.getDurability(10))));
        PEACH_ICE_DRESS = ItemRegistry.registerItem("peach_ice_dress", () -> new CostumeItem(Ingredient.of((ItemLike[])new ItemLike[]{ICE_FLOWER}), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.LEGGINGS, "peach_costume", 5, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.LEGGINGS.getDurability(10))));
        PEACH_ICE_SHOES = ItemRegistry.registerItem("peach_ice_shoes", () -> new CostumeItem(Ingredient.of((ItemLike[])new ItemLike[]{ICE_FLOWER}), (Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.BOOTS, "peach_costume", 5, new Item.Properties().stacksTo(1).durability(ArmorItem.Type.BOOTS.getDurability(10))));
        BOWSER_BANNER_PATTERN = ItemRegistry.registerItem("bowser_banner_pattern", () -> new BannerPatternItem(TagRegistry.BOWSER_BANNER_PATTERN, new Item.Properties().stacksTo(1).rarity(Rarity.UNCOMMON)));
        BOWSER_POTTERY_SHERD = ItemRegistry.registerItem("bowser_pottery_sherd", () -> new Item(new Item.Properties().rarity(Rarity.UNCOMMON)));
        PLUMBER_BANNER_PATTERN = ItemRegistry.registerItem("plumber_banner_pattern", () -> new BannerPatternItem(TagRegistry.PLUMBER_BANNER_PATTERN, new Item.Properties().stacksTo(1)));
        PLUMBER_POTTERY_SHERD = ItemRegistry.registerItem("plumber_pottery_sherd", () -> new Item(new Item.Properties()));
        BOO_SPAWN_EGG = ItemRegistry.registerItem("boo_spawn_egg", () -> new DeferredSpawnEggItem(EntityRegistry.BOO, 0xFFFFFF, 0xFFFFFF, new Item.Properties()));
        DRY_BONES_SPAWN_EGG = ItemRegistry.registerItem("dry_bones_spawn_egg", () -> new DeferredSpawnEggItem(EntityRegistry.DRY_BONES, 0xFFFFFF, 0xFFFFFF, new Item.Properties()));
        FIRE_GOOMBA_SPAWN_EGG = ItemRegistry.registerItem("fire_goomba_spawn_egg", () -> new DeferredSpawnEggItem(EntityRegistry.FIRE_GOOMBA, 0xFFFFFF, 0xFFFFFF, new Item.Properties()));
        GOLD_KOOPA_TROOPA_SPAWN_EGG = ItemRegistry.registerItem("gold_koopa_troopa_spawn_egg", () -> new DeferredSpawnEggItem(EntityRegistry.GOLD_KOOPA_TROOPA, 0xFFFFFF, 0xFFFFFF, new Item.Properties()));
        GOOMBA_SPAWN_EGG = ItemRegistry.registerItem("goomba_spawn_egg", () -> new DeferredSpawnEggItem(EntityRegistry.GOOMBA, 0xFFFFFF, 0xFFFFFF, new Item.Properties()));
        GREEN_KOOPA_TROOPA_SPAWN_EGG = ItemRegistry.registerItem("green_koopa_troopa_spawn_egg", () -> new DeferredSpawnEggItem(EntityRegistry.GREEN_KOOPA_TROOPA, 0xFFFFFF, 0xFFFFFF, new Item.Properties()));
        HEFTY_GOOMBA_SPAWN_EGG = ItemRegistry.registerItem("hefty_goomba_spawn_egg", () -> new DeferredSpawnEggItem(EntityRegistry.HEFTY_GOOMBA, 0xFFFFFF, 0xFFFFFF, new Item.Properties()));
        MEGA_GOOMBA_SPAWN_EGG = ItemRegistry.registerItem("mega_goomba_spawn_egg", () -> new DeferredSpawnEggItem(EntityRegistry.MEGA_GOOMBA, 0xFFFFFF, 0xFFFFFF, new Item.Properties()));
        MINI_GOOMBA_SPAWN_EGG = ItemRegistry.registerItem("mini_goomba_spawn_egg", () -> new DeferredSpawnEggItem(EntityRegistry.MINI_GOOMBA, 0xFFFFFF, 0xFFFFFF, new Item.Properties()));
        PIRANHA_PLANT_SPAWN_EGG = ItemRegistry.registerItem("piranha_plant_spawn_egg", () -> new BetterSpawnEggItem((Supplier<? extends EntityType<? extends Mob>>)EntityRegistry.PIRANHA_PLANT, 0xFFFFFF, 0xFFFFFF, new Item.Properties()));
        POKEY_SPAWN_EGG = ItemRegistry.registerItem("pokey_spawn_egg", () -> new PokeySpawnEggItem((Supplier<? extends EntityType<? extends Mob>>)EntityRegistry.POKEY_BODY, 0xFFFFFF, 0xFFFFFF, new Item.Properties()));
        RED_KOOPA_TROOPA_SPAWN_EGG = ItemRegistry.registerItem("red_koopa_troopa_spawn_egg", () -> new DeferredSpawnEggItem(EntityRegistry.RED_KOOPA_TROOPA, 0xFFFFFF, 0xFFFFFF, new Item.Properties()));
        SNOW_POKEY_SPAWN_EGG = ItemRegistry.registerItem("snow_pokey_spawn_egg", () -> new SnowPokeySpawnEggItem((Supplier<? extends EntityType<? extends Mob>>)EntityRegistry.SNOW_POKEY_BODY, 0xFFFFFF, 0xFFFFFF, new Item.Properties()));
        SPLUNKIN_SPAWN_EGG = ItemRegistry.registerItem("splunkin_spawn_egg", () -> new DeferredSpawnEggItem(EntityRegistry.SPLUNKIN, 0xFFFFFF, 0xFFFFFF, new Item.Properties()));
    }
}

