/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.world;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.wenxin2.marioverse.blocks.WarpPipeBlock;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.extensions.IOwnedSpawner;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class PipeSpawner
extends BaseSpawner {
    public static final String SPAWN_DATA_TAG = "SpawnData";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int EVENT_SPAWN = 1;
    private SimpleWeightedRandomList<SpawnData> spawnPotentials = SimpleWeightedRandomList.empty();
    @Nullable
    private Entity displayEntity;
    @Nullable
    private SpawnData nextSpawnData;
    private double oSpin;
    private double spin;
    public int maxNearbyEntities = 1;
    private int maxSpawnDelay = 200;
    private int minSpawnDelay = 300;
    private int requiredPlayerRange = 16;
    private int spawnCount = 1;
    private int spawnDelay = 20;
    private int spawnRange = 1;

    public void setEntityId(EntityType<?> entityType, @Nullable Level world, RandomSource random, BlockPos pos) {
        this.getOrCreateNextSpawnData(world, random, pos).getEntityToSpawn().putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString());
    }

    private boolean isNearPlayer(Level world, BlockPos pos) {
        boolean within16Blocks = world.hasNearbyAlivePlayer((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (double)this.requiredPlayerRange);
        boolean within1Block = world.hasNearbyAlivePlayer((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 1.0);
        return within16Blocks && !within1Block;
    }

    public void clientTick(Level world, BlockPos pos) {
        if (!this.isNearPlayer(world, pos)) {
            this.oSpin = this.spin;
        } else if (this.displayEntity != null) {
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            this.oSpin = this.spin;
            this.spin = (this.spin + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
        }
    }

    public void serverTick(@NotNull ServerLevel serverWorld, BlockPos pos) {
        BlockState state = serverWorld.getBlockState(pos);
        if (state.getBlock() instanceof WarpPipeBlock && !((Boolean)ConfigRegistry.WARP_PIPE_SPAWNS_MOBS.get()).booleanValue()) {
            return;
        }
        if (this.isNearPlayer((Level)serverWorld, pos)) {
            if (this.spawnDelay == -1) {
                this.delay((Level)serverWorld, pos);
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            } else {
                boolean spawned = false;
                RandomSource random = serverWorld.getRandom();
                SpawnData spawnData = this.getOrCreateNextSpawnData((Level)serverWorld, random, pos);
                Direction facing = state.getOptionalValue((Property)BlockStateProperties.FACING).orElse(Direction.UP);
                for (int i = 0; i < this.spawnCount; ++i) {
                    Mob mob;
                    BlockPos spawnPos;
                    double z;
                    CompoundTag tag = spawnData.getEntityToSpawn();
                    Optional entityTypeOpt = EntityType.by((CompoundTag)tag);
                    if (entityTypeOpt.isEmpty()) {
                        this.delay((Level)serverWorld, pos);
                        return;
                    }
                    EntityType entityType = (EntityType)entityTypeOpt.get();
                    int nearbyEntities = serverWorld.getEntities((EntityTypeTest)entityType, new AABB(pos).inflate(1.0), EntitySelector.NO_SPECTATORS).size();
                    if (nearbyEntities >= this.maxNearbyEntities || entityType.is(TagRegistry.WARP_PIPE_CANNOT_SPAWN) || state.hasProperty((Property)WarpPipeBlock.CLOSED) && ((Boolean)state.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue()) {
                        this.delay((Level)serverWorld, pos);
                        return;
                    }
                    ListTag listTag = tag.getList("Pos", 6);
                    int j = listTag.size();
                    double x = j >= 1 ? listTag.getDouble(0) : (double)pos.getX() + (random.nextDouble() - random.nextDouble()) * (double)this.spawnRange + 0.5;
                    double y = j >= 2 ? listTag.getDouble(1) : (double)(pos.getY() + random.nextInt(3) - 1);
                    double d = z = j >= 3 ? listTag.getDouble(2) : (double)pos.getZ() + (random.nextDouble() - random.nextDouble()) * (double)this.spawnRange + 0.5;
                    if (state.hasProperty((Property)BlockStateProperties.FACING)) {
                        spawnPos = pos.relative(facing);
                        double entityWidth = (double)entityType.getWidth() / 2.0;
                        double entityHeight = entityType.getHeight();
                        switch (facing) {
                            case UP: {
                                x = (double)spawnPos.getX() + 0.5;
                                y = (double)spawnPos.getY() + 0.1;
                                z = (double)spawnPos.getZ() + 0.5;
                                break;
                            }
                            case DOWN: {
                                x = (double)spawnPos.getX() + 0.5;
                                y = (double)spawnPos.getY() + 1.0 - entityHeight - 0.1;
                                z = (double)spawnPos.getZ() + 0.5;
                                break;
                            }
                            case NORTH: {
                                x = (double)spawnPos.getX() + 0.5;
                                y = spawnPos.getY();
                                z = (double)spawnPos.getZ() + entityWidth + 0.1;
                                break;
                            }
                            case SOUTH: {
                                x = (double)spawnPos.getX() + 0.5;
                                y = spawnPos.getY();
                                z = (double)spawnPos.getZ() + entityWidth + 0.1;
                                break;
                            }
                            case WEST: {
                                x = (double)spawnPos.getX() + entityWidth + 0.1;
                                y = spawnPos.getY();
                                z = (double)spawnPos.getZ() + 0.5;
                                break;
                            }
                            case EAST: {
                                x = (double)spawnPos.getX() + entityWidth + 0.1;
                                y = spawnPos.getY();
                                z = (double)spawnPos.getZ() + 0.5;
                            }
                        }
                    } else {
                        spawnPos = BlockPos.containing((double)x, (double)y, (double)z);
                    }
                    if (!serverWorld.noCollision(entityType.getSpawnAABB(x, y, z))) continue;
                    double finalX = x;
                    double finalY = y;
                    double finalZ = z;
                    Entity entity = EntityType.loadEntityRecursive((CompoundTag)tag, (Level)serverWorld, e -> {
                        e.moveTo(finalX, finalY, finalZ, e.getYRot(), e.getXRot());
                        return e;
                    });
                    if (entity == null) {
                        this.delay((Level)serverWorld, pos);
                        return;
                    }
                    entity.moveTo(x, y, z, random.nextFloat() * 360.0f, 0.0f);
                    if (entity instanceof Mob) {
                        mob = (Mob)entity;
                        EventHooks.finalizeMobSpawnSpawner((Mob)mob, (ServerLevelAccessor)serverWorld, (DifficultyInstance)serverWorld.getCurrentDifficultyAt(entity.blockPosition()), (MobSpawnType)MobSpawnType.SPAWNER, null, (IOwnedSpawner)this, (boolean)true);
                        spawnData.getEquipment().ifPresent(arg_0 -> ((Mob)mob).equip(arg_0));
                    }
                    if (!serverWorld.tryAddFreshEntityWithPassengers(entity)) {
                        this.delay((Level)serverWorld, pos);
                        return;
                    }
                    serverWorld.gameEvent(entity, (Holder)GameEvent.ENTITY_PLACE, spawnPos);
                    if (entity instanceof Mob) {
                        mob = (Mob)entity;
                        mob.spawnAnim();
                    }
                    spawned = true;
                }
                if (spawned) {
                    this.delay((Level)serverWorld, pos);
                }
            }
        }
    }

    private void delay(Level world, BlockPos pos) {
        RandomSource randomsource = world.random;
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + randomsource.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
        this.spawnPotentials.getRandom(randomsource).ifPresent(p_337965_ -> this.setNextSpawnData(world, pos, (SpawnData)p_337965_.data()));
        this.broadcastEvent(world, pos, 1);
    }

    protected void setNextSpawnData(@Nullable Level world, BlockPos pos, SpawnData data) {
        this.nextSpawnData = data;
    }

    private SpawnData getOrCreateNextSpawnData(@Nullable Level world, RandomSource random, BlockPos pos) {
        if (this.nextSpawnData != null) {
            return this.nextSpawnData;
        }
        this.setNextSpawnData(world, pos, this.spawnPotentials.getRandom(random).map(WeightedEntry.Wrapper::data).orElseGet(SpawnData::new));
        return this.nextSpawnData;
    }

    public void load(@Nullable Level world, BlockPos pos, CompoundTag tag) {
        boolean hasSpawnPotentials;
        this.spawnDelay = tag.getShort("Delay");
        boolean hasSpawnData = tag.contains(SPAWN_DATA_TAG, 10);
        if (hasSpawnData) {
            SpawnData spawndata = SpawnData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound(SPAWN_DATA_TAG)).resultOrPartial(warn -> LOGGER.warn("Invalid SpawnData: {}", warn)).orElseGet(SpawnData::new);
            this.setNextSpawnData(world, pos, spawndata);
        }
        if (hasSpawnPotentials = tag.contains("SpawnPotentials", 9)) {
            ListTag listTag = tag.getList("SpawnPotentials", 10);
            this.spawnPotentials = SpawnData.LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)listTag).resultOrPartial(warn -> LOGGER.warn("Invalid SpawnPotentials list: {}", warn)).orElseGet(SimpleWeightedRandomList::empty);
        } else {
            this.spawnPotentials = SimpleWeightedRandomList.single((Object)(this.nextSpawnData != null ? this.nextSpawnData : new SpawnData()));
        }
        if (tag.contains("MinSpawnDelay", 99)) {
            this.minSpawnDelay = tag.getShort("MinSpawnDelay");
            this.maxSpawnDelay = tag.getShort("MaxSpawnDelay");
            this.spawnCount = tag.getShort("SpawnCount");
        }
        if (tag.contains("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = tag.getShort("MaxNearbyEntities");
            this.requiredPlayerRange = tag.getShort("RequiredPlayerRange");
        }
        if (tag.contains("SpawnRange", 99)) {
            this.spawnRange = tag.getShort("SpawnRange");
        }
        this.displayEntity = null;
    }

    public CompoundTag save(CompoundTag tag) {
        tag.putShort("Delay", (short)this.spawnDelay);
        tag.putShort("MinSpawnDelay", (short)this.minSpawnDelay);
        tag.putShort("MaxSpawnDelay", (short)this.maxSpawnDelay);
        tag.putShort("SpawnCount", (short)this.spawnCount);
        tag.putShort("MaxNearbyEntities", (short)this.maxNearbyEntities);
        tag.putShort("RequiredPlayerRange", (short)this.requiredPlayerRange);
        tag.putShort("SpawnRange", (short)this.spawnRange);
        if (this.nextSpawnData != null) {
            tag.put(SPAWN_DATA_TAG, (Tag)SpawnData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.nextSpawnData).getOrThrow(warn -> new IllegalStateException("Invalid SpawnData: " + warn)));
        }
        tag.put("SpawnPotentials", (Tag)SpawnData.LIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.spawnPotentials).getOrThrow());
        return tag;
    }
}

