/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.astraldimension.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelmelee_astral_golem<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"astral_dimension", (String)"modelmelee_astral_golem"), "main");
    public final ModelPart head;
    public final ModelPart l_arm;
    public final ModelPart r_arm;
    public final ModelPart l_leg;
    public final ModelPart r_leg;
    public final ModelPart bb_main;

    public Modelmelee_astral_golem(ModelPart root) {
        this.head = root.getChild("head");
        this.l_arm = root.getChild("l_arm");
        this.r_arm = root.getChild("r_arm");
        this.l_leg = root.getChild("l_leg");
        this.r_leg = root.getChild("r_leg");
        this.bb_main = root.getChild("bb_main");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 13).addBox(-2.0f, -4.75f, -2.5f, 8.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(12, 24).addBox(1.0f, -0.75f, -4.5f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(44, 0).addBox(1.0f, -6.75f, -3.5f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(44, 0).addBox(1.0f, -4.75f, -3.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(44, 0).addBox(1.0f, -4.75f, 1.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)6.75f, (float)-4.5f));
        PartDefinition l_arm = partdefinition.addOrReplaceChild("l_arm", CubeListBuilder.create().texOffs(0, 24).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 13.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.5f, (float)7.5f, (float)-0.5f));
        PartDefinition r_arm = partdefinition.addOrReplaceChild("r_arm", CubeListBuilder.create().texOffs(21, 21).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 13.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.5f, (float)7.5f, (float)-0.5f));
        PartDefinition l_leg = partdefinition.addOrReplaceChild("l_leg", CubeListBuilder.create().texOffs(30, 0).addBox(-1.5f, 0.5f, -1.5f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)16.5f, (float)-0.5f));
        PartDefinition r_leg = partdefinition.addOrReplaceChild("r_leg", CubeListBuilder.create().texOffs(33, 19).addBox(-1.5f, 0.5f, -1.5f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)16.5f, (float)-0.5f));
        PartDefinition bb_main = partdefinition.addOrReplaceChild("bb_main", CubeListBuilder.create().texOffs(24, 13).addBox(-3.0f, -10.0f, -2.0f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-5.0f, -18.0f, -3.0f, 10.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.l_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.r_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.l_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.r_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.bb_main.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.r_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.l_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.l_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.r_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
    }
}

