/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.astraldimension.procedures;

import net.mcreator.astraldimension.init.AstralDimensionModItems;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;

@EventBusSubscriber
public class EntityFallsWithBouncyBootsProcedure {
    @SubscribeEvent
    public static void onEntityFall(LivingFallEvent event) {
        Player player;
        ItemStack boots;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && (boots = (player = (Player)entity).getInventory().getArmor(0)).getItem() == AstralDimensionModItems.BOUNCY_BOOTS.get()) {
            event.setCanceled(true);
            player.fallDistance = 0.0f;
            float distance = event.getDistance();
            if (distance > 2.0f) {
                Vec3 motion = player.getDeltaMovement();
                double bounce = (double)distance * 0.4;
                double maxBounce = 15.0;
                if ((bounce /= 1.0 + (double)distance / 10.0) > maxBounce) {
                    bounce = maxBounce;
                }
                if (player.isShiftKeyDown() && (bounce *= 0.3) < 0.5) {
                    bounce = 0.0;
                }
                if (bounce > 0.0) {
                    player.setDeltaMovement(motion.x, bounce, motion.z);
                    player.hurtMarked = true;
                }
            }
        }
    }
}

