/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.astraldimension.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.PlantType;

public class DeadKelpBlock
extends SugarCaneBlock {
    public DeadKelpBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).randomTicks().sound(SoundType.STONE).strength(0.2f, 0.0f).noCollission().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState groundState = worldIn.getBlockState(blockpos);
        return groundState.is((Block)this) || groundState.is(Blocks.GRAVEL) || groundState.is(Blocks.STONE) || groundState.is(Blocks.GRANITE) || groundState.is(Blocks.DIORITE) || groundState.is(Blocks.ANDESITE);
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.WATER;
    }

    public void randomTick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        if (world.isEmptyBlock(pos.above())) {
            int i = 1;
            while (world.getBlockState(pos.below(i)).is((Block)this)) {
                ++i;
            }
            if (i < 14) {
                int j = (Integer)blockstate.getValue((Property)AGE);
                if (CommonHooks.canCropGrow((Level)world, (BlockPos)pos, (BlockState)blockstate, (boolean)true)) {
                    if (j == 15) {
                        world.setBlockAndUpdate(pos.above(), this.defaultBlockState());
                        CommonHooks.fireCropGrowPost((Level)world, (BlockPos)pos.above(), (BlockState)this.defaultBlockState());
                        world.setBlock(pos, (BlockState)blockstate.setValue((Property)AGE, (Comparable)Integer.valueOf(0)), 4);
                    } else {
                        world.setBlock(pos, (BlockState)blockstate.setValue((Property)AGE, (Comparable)Integer.valueOf(j + 1)), 4);
                    }
                }
            }
        }
    }
}

