/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.astraldimension.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelscourge<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("astral_dimension", "modelscourge"), "main");
    public final ModelPart r_leg_1;
    public final ModelPart l_leg_2;
    public final ModelPart l_leg_1;
    public final ModelPart body;
    public final ModelPart r_whip;
    public final ModelPart l_whip;
    public final ModelPart head;
    public final ModelPart r_leg_2;

    public Modelscourge(ModelPart root) {
        this.r_leg_1 = root.getChild("r_leg_1");
        this.l_leg_2 = root.getChild("l_leg_2");
        this.l_leg_1 = root.getChild("l_leg_1");
        this.body = root.getChild("body");
        this.r_whip = root.getChild("r_whip");
        this.l_whip = root.getChild("l_whip");
        this.head = root.getChild("head");
        this.r_leg_2 = root.getChild("r_leg_2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition r_leg_1 = partdefinition.addOrReplaceChild("r_leg_1", CubeListBuilder.create().texOffs(36, 45).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)15.0f, (float)-4.0f));
        PartDefinition l_leg_2 = partdefinition.addOrReplaceChild("l_leg_2", CubeListBuilder.create().texOffs(52, 45).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)15.0f, (float)4.0f));
        PartDefinition l_leg_1 = partdefinition.addOrReplaceChild("l_leg_1", CubeListBuilder.create().texOffs(62, 19).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)15.0f, (float)-4.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(40, 23).addBox(-3.0f, -6.0f, -5.0f, 6.0f, 12.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition r_whip = partdefinition.addOrReplaceChild("r_whip", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)12.6101f, (float)-3.9734f));
        PartDefinition cube_r1 = r_whip.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 17).addBox(1.0f, -6.0f, -14.0f, 0.0f, 12.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.6101f, (float)-1.0266f, (float)0.0873f, (float)0.3054f, (float)0.0f));
        PartDefinition l_whip = partdefinition.addOrReplaceChild("l_whip", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)12.6101f, (float)-3.9734f));
        PartDefinition cube_r2 = l_whip.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 4).addBox(-1.0f, -6.0f, -15.0f, 0.0f, 12.0f, 19.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.6101f, (float)-1.0266f, (float)0.0873f, (float)-0.3054f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, -9.5f, -6.0f, 14.0f, 11.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.5f, (float)0.0f));
        PartDefinition r_ear_2 = head.addOrReplaceChild("r_ear_2", CubeListBuilder.create(), PartPose.offset((float)-7.1533f, (float)-8.7294f, (float)3.5f));
        PartDefinition cube_r3 = r_ear_2.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(68, 45).addBox(-2.5f, -1.5f, 5.0f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.6533f, (float)-0.2706f, (float)-6.5f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition l_ear_2 = head.addOrReplaceChild("l_ear_2", CubeListBuilder.create(), PartPose.offset((float)7.3446f, (float)-8.7675f, (float)3.5f));
        PartDefinition cube_r4 = l_ear_2.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(68, 52).addBox(-1.5f, -1.0f, 5.5f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.8446f, (float)-0.7325f, (float)-7.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition l_ear_1 = head.addOrReplaceChild("l_ear_1", CubeListBuilder.create(), PartPose.offset((float)7.3446f, (float)-8.7675f, (float)-3.5f));
        PartDefinition cube_r5 = l_ear_1.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(68, 52).addBox(-1.5f, -1.0f, -1.5f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.8446f, (float)-0.7325f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition r_ear_1 = head.addOrReplaceChild("r_ear_1", CubeListBuilder.create(), PartPose.offset((float)-7.1533f, (float)-8.7294f, (float)-3.5f));
        PartDefinition cube_r6 = r_ear_1.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(68, 45).addBox(-2.5f, -1.5f, -2.0f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.6533f, (float)-0.2706f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition r_leg_2 = partdefinition.addOrReplaceChild("r_leg_2", CubeListBuilder.create().texOffs(0, 47).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)15.0f, (float)4.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.r_leg_1.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.l_leg_2.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.l_leg_1.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.r_whip.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.l_whip.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.r_leg_2.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.l_leg_2.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.r_leg_2.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.l_leg_1.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.l_whip.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.r_leg_1.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.r_whip.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
    }
}

