/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.astraldimension.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelslurker<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("astral_dimension", "modelslurker"), "main");
    public final ModelPart head;
    public final ModelPart r_arm;
    public final ModelPart l_arm;
    public final ModelPart l_leg;
    public final ModelPart r_leg;
    public final ModelPart bb_main;

    public Modelslurker(ModelPart root) {
        this.head = root.getChild("head");
        this.r_arm = root.getChild("r_arm");
        this.l_arm = root.getChild("l_arm");
        this.l_leg = root.getChild("l_leg");
        this.r_leg = root.getChild("r_leg");
        this.bb_main = root.getChild("bb_main");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(28, 30).addBox(-3.0f, -5.9053f, -3.7586f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(52, 37).addBox(-5.0f, -3.9053f, -5.7586f, 10.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(50, 16).addBox(-5.0f, -3.9053f, 4.2414f, 10.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(40, 11).addBox(5.0f, -3.9053f, -5.7586f, 0.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(36, 37).addBox(-5.0f, -3.9053f, -5.7586f, 0.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(50, 0).addBox(-5.0f, -8.9053f, -5.7586f, 10.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(36, 32).addBox(5.0f, -8.9053f, -5.7586f, 0.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(30, 6).addBox(-5.0f, -8.9053f, -5.7586f, 0.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(30, 0).addBox(-5.0f, -8.9053f, 4.2414f, 10.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 15).addBox(-5.0f, -13.9053f, -5.7586f, 10.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(30, 5).addBox(-5.0f, 1.0947f, -5.7586f, 10.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-16.0947f, (float)0.7586f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -2.5f, 2.0f, 10.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-12.4053f, (float)1.2414f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition r_arm = partdefinition.addOrReplaceChild("r_arm", CubeListBuilder.create().texOffs(30, 5).addBox(-2.1f, 4.7f, 2.0f, 5.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 20).addBox(-2.1f, 4.7f, -2.0f, 5.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(52, 26).addBox(-2.1f, -2.3f, -2.0f, 5.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 11).addBox(-2.1f, 4.7f, -2.0f, 0.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(28, 42).addBox(-0.1f, 4.7f, -1.0f, 2.0f, 25.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.9f, (float)-11.7f, (float)0.0f));
        PartDefinition l_arm = partdefinition.addOrReplaceChild("l_arm", CubeListBuilder.create().texOffs(36, 52).addBox(-1.9f, 4.7f, -1.0f, 2.0f, 25.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(18, 54).addBox(-2.9f, 4.7f, 2.0f, 5.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(22, 30).addBox(-2.9f, 4.7f, -2.0f, 5.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 54).addBox(-2.9f, -2.3f, -2.0f, 5.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(2.1f, 4.7f, -2.0f, 0.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.9f, (float)-11.7f, (float)0.0f));
        PartDefinition l_leg = partdefinition.addOrReplaceChild("l_leg", CubeListBuilder.create().texOffs(44, 52).addBox(-1.0f, 1.0f, -1.0f, 2.0f, 20.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)3.0f, (float)0.0f));
        PartDefinition r_leg = partdefinition.addOrReplaceChild("r_leg", CubeListBuilder.create().texOffs(52, 52).addBox(-1.0f, 1.0f, -1.0f, 2.0f, 20.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)3.0f, (float)0.0f));
        PartDefinition bb_main = partdefinition.addOrReplaceChild("bb_main", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition cube_r2 = bb_main.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 30).addBox(-4.0f, -9.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-29.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.r_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.l_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.l_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.r_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.bb_main.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.r_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.l_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.l_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.r_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
    }
}

