/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.astraldimension.entity;

import net.mcreator.astraldimension.init.AstralDimensionModEntities;
import net.mcreator.astraldimension.procedures.BacteriaProjectileProjectileHitsLivingEntityProcedure;
import net.mcreator.astraldimension.procedures.BacteriaProjectileWhileProjectileFlyingTickProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class BacteriaProjectileEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)Blocks.AIR);

    public BacteriaProjectileEntity(EntityType<? extends BacteriaProjectileEntity> type, Level world) {
        super(type, world, PROJECTILE_ITEM);
    }

    public BacteriaProjectileEntity(EntityType<? extends BacteriaProjectileEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world, PROJECTILE_ITEM);
    }

    public BacteriaProjectileEntity(EntityType<? extends BacteriaProjectileEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world, PROJECTILE_ITEM);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Blocks.AIR);
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }

    public void playerTouch(Player entity) {
        super.playerTouch(entity);
        BacteriaProjectileProjectileHitsLivingEntityProcedure.execute((Entity)entity);
    }

    public void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        BacteriaProjectileProjectileHitsLivingEntityProcedure.execute(entityHitResult.getEntity());
    }

    public void tick() {
        super.tick();
        BacteriaProjectileWhileProjectileFlyingTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
        if (this.inGround) {
            this.discard();
        }
    }

    public static BacteriaProjectileEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return BacteriaProjectileEntity.shoot(world, entity, source, 1.0f, 1.0, 1);
    }

    public static BacteriaProjectileEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return BacteriaProjectileEntity.shoot(world, entity, source, pullingPower * 1.0f, 1.0, 1);
    }

    public static BacteriaProjectileEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        BacteriaProjectileEntity entityarrow = new BacteriaProjectileEntity((EntityType<? extends BacteriaProjectileEntity>)((EntityType)AstralDimensionModEntities.BACTERIA_PROJECTILE.get()), entity, world);
        entityarrow.shoot(entity.getViewVector((float)1.0f).x, entity.getViewVector((float)1.0f).y, entity.getViewVector((float)1.0f).z, power * 2.0f, 0.0f);
        entityarrow.setSilent(true);
        entityarrow.setCritArrow(false);
        entityarrow.setBaseDamage(damage);
        entityarrow.setKnockback(knockback);
        world.addFreshEntity((Entity)entityarrow);
        world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("astral_dimension:fatal_mushroom_shoots")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static BacteriaProjectileEntity shoot(LivingEntity entity, LivingEntity target) {
        BacteriaProjectileEntity entityarrow = new BacteriaProjectileEntity((EntityType<? extends BacteriaProjectileEntity>)((EntityType)AstralDimensionModEntities.BACTERIA_PROJECTILE.get()), entity, entity.level());
        double dx = target.getX() - entity.getX();
        double dy = target.getY() + (double)target.getEyeHeight() - 1.1;
        double dz = target.getZ() - entity.getZ();
        entityarrow.shoot(dx, dy - entityarrow.getY() + Math.hypot(dx, dz) * (double)0.2f, dz, 2.0f, 12.0f);
        entityarrow.setSilent(true);
        entityarrow.setBaseDamage(1.0);
        entityarrow.setKnockback(1);
        entityarrow.setCritArrow(false);
        entity.level().addFreshEntity((Entity)entityarrow);
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("astral_dimension:fatal_mushroom_shoots")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.create().nextFloat() * 0.5f + 1.0f));
        return entityarrow;
    }
}

