/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.astraldimension.entity;

import net.mcreator.astraldimension.init.AstralDimensionModEntities;
import net.mcreator.astraldimension.init.AstralDimensionModItems;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class ElectricProjectileShooterProjectileEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)AstralDimensionModItems.ELECTRIC_PROJECTILE.get());

    public ElectricProjectileShooterProjectileEntity(EntityType<? extends ElectricProjectileShooterProjectileEntity> type, Level world) {
        super(type, world, PROJECTILE_ITEM);
    }

    public ElectricProjectileShooterProjectileEntity(EntityType<? extends ElectricProjectileShooterProjectileEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world, PROJECTILE_ITEM);
    }

    public ElectricProjectileShooterProjectileEntity(EntityType<? extends ElectricProjectileShooterProjectileEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world, PROJECTILE_ITEM);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)AstralDimensionModItems.ELECTRIC_PROJECTILE.get());
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }

    public void tick() {
        super.tick();
        if (this.inGround) {
            this.discard();
        }
    }

    public static ElectricProjectileShooterProjectileEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return ElectricProjectileShooterProjectileEntity.shoot(world, entity, source, 0.9f, 3.4, 1);
    }

    public static ElectricProjectileShooterProjectileEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return ElectricProjectileShooterProjectileEntity.shoot(world, entity, source, pullingPower * 0.9f, 3.4, 1);
    }

    public static ElectricProjectileShooterProjectileEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        ElectricProjectileShooterProjectileEntity entityarrow = new ElectricProjectileShooterProjectileEntity((EntityType<? extends ElectricProjectileShooterProjectileEntity>)((EntityType)AstralDimensionModEntities.ELECTRIC_PROJECTILE_SHOOTER_PROJECTILE.get()), entity, world);
        entityarrow.shoot(entity.getViewVector((float)1.0f).x, entity.getViewVector((float)1.0f).y, entity.getViewVector((float)1.0f).z, power * 2.0f, 0.0f);
        entityarrow.setSilent(true);
        entityarrow.setCritArrow(false);
        entityarrow.setBaseDamage(damage);
        entityarrow.setKnockback(knockback);
        world.addFreshEntity((Entity)entityarrow);
        world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.blaze.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static ElectricProjectileShooterProjectileEntity shoot(LivingEntity entity, LivingEntity target) {
        ElectricProjectileShooterProjectileEntity entityarrow = new ElectricProjectileShooterProjectileEntity((EntityType<? extends ElectricProjectileShooterProjectileEntity>)((EntityType)AstralDimensionModEntities.ELECTRIC_PROJECTILE_SHOOTER_PROJECTILE.get()), entity, entity.level());
        double dx = target.getX() - entity.getX();
        double dy = target.getY() + (double)target.getEyeHeight() - 1.1;
        double dz = target.getZ() - entity.getZ();
        entityarrow.shoot(dx, dy - entityarrow.getY() + Math.hypot(dx, dz) * (double)0.2f, dz, 1.8f, 12.0f);
        entityarrow.setSilent(true);
        entityarrow.setBaseDamage(3.4);
        entityarrow.setKnockback(1);
        entityarrow.setCritArrow(false);
        entity.level().addFreshEntity((Entity)entityarrow);
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.blaze.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.create().nextFloat() * 0.5f + 1.0f));
        return entityarrow;
    }
}

