/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.astraldimension.entity;

import net.mcreator.astraldimension.init.AstralDimensionModEntities;
import net.mcreator.astraldimension.init.AstralDimensionModItems;
import net.mcreator.astraldimension.procedures.MediumFireballProjectileHitsBlockProcedure;
import net.mcreator.astraldimension.procedures.MediumFireballProjectileWhileProjectileFlyingTickProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class MediumFireballProjectileEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)AstralDimensionModItems.MEDIUM_FIREBALL.get());

    public MediumFireballProjectileEntity(EntityType<? extends MediumFireballProjectileEntity> type, Level world) {
        super(type, world, PROJECTILE_ITEM);
    }

    public MediumFireballProjectileEntity(EntityType<? extends MediumFireballProjectileEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world, PROJECTILE_ITEM);
    }

    public MediumFireballProjectileEntity(EntityType<? extends MediumFireballProjectileEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world, PROJECTILE_ITEM);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)AstralDimensionModItems.MEDIUM_FIREBALL.get());
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }

    public void playerTouch(Player entity) {
        super.playerTouch(entity);
        MediumFireballProjectileHitsBlockProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
    }

    public void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        MediumFireballProjectileHitsBlockProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
    }

    public void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        MediumFireballProjectileHitsBlockProcedure.execute((LevelAccessor)this.level(), blockHitResult.getBlockPos().getX(), blockHitResult.getBlockPos().getY(), blockHitResult.getBlockPos().getZ());
    }

    public void tick() {
        super.tick();
        MediumFireballProjectileWhileProjectileFlyingTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
        if (this.inGround) {
            this.discard();
        }
    }

    public static MediumFireballProjectileEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return MediumFireballProjectileEntity.shoot(world, entity, source, 0.0f, 0.8, 1);
    }

    public static MediumFireballProjectileEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return MediumFireballProjectileEntity.shoot(world, entity, source, pullingPower * 0.0f, 0.8, 1);
    }

    public static MediumFireballProjectileEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        MediumFireballProjectileEntity entityarrow = new MediumFireballProjectileEntity((EntityType<? extends MediumFireballProjectileEntity>)((EntityType)AstralDimensionModEntities.MEDIUM_FIREBALL_PROJECTILE.get()), entity, world);
        entityarrow.shoot(entity.getViewVector((float)1.0f).x, entity.getViewVector((float)1.0f).y, entity.getViewVector((float)1.0f).z, power * 2.0f, 0.0f);
        entityarrow.setSilent(true);
        entityarrow.setCritArrow(false);
        entityarrow.setBaseDamage(damage);
        entityarrow.setKnockback(knockback);
        entityarrow.igniteForSeconds(100);
        world.addFreshEntity((Entity)entityarrow);
        world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static MediumFireballProjectileEntity shoot(LivingEntity entity, LivingEntity target) {
        MediumFireballProjectileEntity entityarrow = new MediumFireballProjectileEntity((EntityType<? extends MediumFireballProjectileEntity>)((EntityType)AstralDimensionModEntities.MEDIUM_FIREBALL_PROJECTILE.get()), entity, entity.level());
        double dx = target.getX() - entity.getX();
        double dy = target.getY() + (double)target.getEyeHeight() - 1.1;
        double dz = target.getZ() - entity.getZ();
        entityarrow.shoot(dx, dy - entityarrow.getY() + Math.hypot(dx, dz) * (double)0.2f, dz, 0.0f, 12.0f);
        entityarrow.setSilent(true);
        entityarrow.setBaseDamage(0.8);
        entityarrow.setKnockback(1);
        entityarrow.setCritArrow(false);
        entityarrow.igniteForSeconds(100);
        entity.level().addFreshEntity((Entity)entityarrow);
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.create().nextFloat() * 0.5f + 1.0f));
        return entityarrow;
    }
}

